<?php
/**
 * Block about us widget.
 *
 * @package RedParts\Sputnik
 * @since 1.0.0
 */

namespace RedParts\Sputnik\Widgets;

use RedParts\Sputnik\Widget;

defined( 'ABSPATH' ) || exit;

if ( ! class_exists( 'RedParts\Sputnik\Widgets\Block_About_Us' ) ) {

	/**
	 * Class Block_Products_Carousel
	 */
	class Block_About_Us extends Widget {
		/**
		 * Indicates whether to display the widget title or not.
		 *
		 * @var bool
		 */
		protected $display_title = false;

		/**
		 * Constructor.
		 */
		public function __construct() {
			$widget_ops = array(
				'classname'                   => 'widget_redparts_sputnik_block_about_us',
				'description'                 => esc_html_x( 'Displays about us.', 'Admin', 'redparts-sputnik' ),
				'customize_selective_refresh' => true,
			);

			parent::__construct(
				'redparts_sputnik_block_about_us',
				esc_html_x( 'RedParts: Block About Us', 'Admin', 'redparts-sputnik' ),
				$widget_ops
			);
		}

		/**
		 * Echoes the widget body content.
		 *
		 * @param array $args     Display arguments including 'before_title', 'after_title', 'before_widget', and 'after_widget'.
		 * @param array $instance The settings for the particular instance of the widget.
		 */
		protected function widget_body( array $args, array $instance ) {
			$title          = isset( $instance['title'] ) ? $instance['title'] : '';
			$text           = isset( $instance['text'] ) ? $instance['text'] : '';
			$signature      = isset( $instance['signature'] ) ? $instance['signature'] : '';
			$facsimile      = isset( $instance['facsimile'] ) ? $instance['facsimile'] : '';
			$background     = isset( $instance['background'] ) ? $instance['background'] : '';
			$indicators_raw = isset( $instance['indicators'] ) && is_array( $instance['indicators'] ) ? array_values( $instance['indicators'] ) : array();
			$indicators     = array();

			$background_url = wp_get_attachment_image_url( absint( $background ), 'full' );

			foreach ( $indicators_raw as $indicator_raw ) {
				$indicator_raw = is_array( $indicator_raw ) ? $indicator_raw : array();

				$indicators[] = array(
					'value'   => isset( $indicator_raw['value'] ) ? $indicator_raw['value'] : '',
					'caption' => isset( $indicator_raw['caption'] ) ? $indicator_raw['caption'] : '',
					'order'   => isset( $indicator_raw['order'] ) ? $indicator_raw['order'] : 0,
				);
			}

			uasort(
				$indicators,
				function( $a, $b ) {
					$a = intval( $a['order'] );
					$b = intval( $b['order'] );

					if ( $a === $b ) {
						return 0;
					}

					return ( $a < $b ) ? -1 : 1;
				}
			);

			?>
			<div class="th-block-about">
				<div class="th-block-about__body">
					<?php if ( ! empty( $background_url ) ) : ?>
						<div class="th-block-about__image">
							<div
								class="th-block-about__image-bg"
								style="background-image: url('<?php echo esc_url( $background_url ); ?>');"
							></div>

							<div class="th-decor th-decor--type--bottom th-block-about__image-decor">
								<div class="th-decor__body">
									<div class="th-decor__start"></div>
									<div class="th-decor__end"></div>
									<div class="th-decor__center"></div>
								</div>
							</div>
						</div>
					<?php endif; ?>

					<div class="th-block-about__card">
						<?php if ( ! empty( $title ) ) : ?>
							<div class="th-block-about__card-title">
								<?php echo esc_html( $title ); ?>
							</div>
						<?php endif; ?>
						<?php if ( ! empty( $text ) ) : ?>
							<div class="th-block-about__card-text">
								<?php echo wp_kses( $text, 'redparts_sputnik_text' ); ?>
							</div>
						<?php endif; ?>
						<?php if ( ! empty( $signature ) ) : ?>
							<div class="th-block-about__card-author">
								<?php echo wp_kses( $signature, 'redparts_sputnik_text' ); ?>
							</div>
						<?php endif; ?>
						<?php if ( wp_attachment_is_image( absint( $facsimile ) ) ) : ?>
							<div class="th-block-about__card-signature">
								<?php echo wp_get_attachment_image( $facsimile, 'full' ); ?>
							</div>
						<?php endif; ?>
					</div>

					<?php if ( ! empty( $indicators ) ) : ?>
						<div class="th-block-about__indicators">
							<div class="th-block-about__indicators-body">
								<?php foreach ( $indicators as $indicator ) : ?>
									<div class="th-block-about__indicators-item">
										<div class="th-block-about__indicators-item-value">
											<?php echo esc_html( $indicator['value'] ); ?>
										</div>
										<div class="th-block-about__indicators-item-title">
											<?php echo esc_html( $indicator['caption'] ); ?>
										</div>
									</div>
								<?php endforeach; ?>
							</div>
						</div>
					<?php endif; ?>
				</div>
			</div>
			<?php
		}

		/**
		 * Returns form fields.
		 *
		 * @return array
		 */
		public function form_fields(): array {
			return array(
				array(
					'key'          => 'title',
					'label'        => esc_html__( 'Title', 'redparts-sputnik' ),
					'type'         => 'text',
					'translatable' => $this->is_elementor_widget(),
				),
				array(
					'key'          => 'text',
					'label'        => esc_html__( 'Text', 'redparts-sputnik' ),
					'type'         => 'textarea',
					'translatable' => true,
				),
				array(
					'key'          => 'signature',
					'label'        => esc_html__( 'Signature', 'redparts-sputnik' ),
					'type'         => 'text',
					'translatable' => true,
				),
				array(
					'key'   => 'facsimile',
					'label' => esc_html__( 'Facsimile', 'redparts-sputnik' ),
					'type'  => 'image',
				),
				array(
					'key'   => 'background',
					'label' => esc_html__( 'Background image', 'redparts-sputnik' ),
					'type'  => 'image',
				),
				array(
					'key'        => 'indicators',
					'select_key' => 'current_indicator',
					'label'      => esc_html__( 'Indicators', 'redparts-sputnik' ),
					'type'       => 'tabs',
					'max'        => 3,
					'fields'     => array(
						array(
							'key'          => 'value',
							'label'        => esc_html__( 'Value', 'redparts-sputnik' ),
							'type'         => 'text',
							'translatable' => true,
						),
						array(
							'key'          => 'caption',
							'label'        => esc_html__( 'Caption', 'redparts-sputnik' ),
							'type'         => 'text',
							'translatable' => true,
						),
						array(
							'key'     => 'order',
							'label'   => esc_html__( 'Order', 'redparts-sputnik' ),
							'type'    => 'number',
							'default' => 0,
						),
					),
					'l10n'       => array(
						'add'    => esc_html__( 'Add Indicator', 'redparts-sputnik' ),
						'remove' => esc_html__( 'Remove Indicator', 'redparts-sputnik' ),
						/* translators: %s: Group number. */
						'title'  => esc_html__( 'Indicator %s', 'redparts-sputnik' ),
					),
				),
			);
		}
	}
}
