<?php
/**
 * Product card, which is used in widgets.
 *
 * @package RedParts\Sputnik
 * @since 1.0.0
 */

namespace RedParts\Sputnik;

defined( 'ABSPATH' ) || exit;

if ( ! class_exists( 'RedParts\Sputnik\Product_Card' ) ) {
	/**
	 * Class Product_Card.
	 */
	class Product_Card extends Singleton {
		/**
		 * Initialization.
		 */
		public function init() {
			add_action( 'init', array( $this, 'deferred_init' ) );
		}

		/**
		 * Deferred initialization.
		 *
		 * @since 1.5.0
		 */
		public function deferred_init() {
			// Product card content.
			add_action( 'redparts_sputnik_product_card_content', array( $this, 'body' ), 100 );
			add_action( 'redparts_sputnik_product_card_content', array( $this, 'footer' ), 100 );

			// Product card body content.
			add_action( 'redparts_sputnik_product_card_body_content', array( $this, 'link' ), 100 );

			// Product card link content.
			add_action( 'redparts_sputnik_product_card_link_content', 'woocommerce_show_product_loop_sale_flash', 100 );
			add_action( 'redparts_sputnik_product_card_link_content', 'woocommerce_template_loop_product_thumbnail', 200 );
			add_action( 'redparts_sputnik_product_card_link_content', 'woocommerce_template_loop_product_title', 300 );

			// Product card footer content.
			add_action( 'redparts_sputnik_product_card_footer_content', 'woocommerce_template_loop_price', 100 );
			add_action( 'redparts_sputnik_product_card_footer_content', array( $this, 'actions' ), 200 );

			// Product card actions content.
			add_action( 'redparts_sputnik_product_card_actions_content', 'woocommerce_template_loop_add_to_cart', 100 );
			if ( Wishlist::instance()->is_enabled() ) {
				add_action( 'redparts_sputnik_product_card_actions_content', array( Wishlist::instance(), 'the_button' ), 200 );
			}
			if ( Compare::instance()->is_enabled() ) {
				add_action( 'redparts_sputnik_product_card_actions_content', array( Compare::instance(), 'the_button' ), 300 );
			}
		}

		/**
		 * Outputs product card.
		 */
		public function render() {
			global $product;

			if ( ! is_a( $product, 'WC_Product' ) ) {
				return;
			}

			?>
			<div <?php wc_product_class( '', $product ); ?>>
				<div class="th-product-card__wrap">
					<?php
					/**
					 * Hook: redparts_sputnik_product_card_content.
					 *
					 * @hooked Product_Card::body   - 100
					 * @hooked Product_Card::footer - 200
					 */
					do_action( 'redparts_sputnik_product_card_content' );
					?>
				</div>
			</div>
			<?php
		}

		/**
		 * Outputs product card body.
		 */
		public function body() {
			?>
			<div class="th-product-card__body">
				<?php
				/**
				 * Hook: redparts_sputnik_product_card_body_content.
				 *
				 * @hooked Product_Card::link - 100
				 */
				do_action( 'redparts_sputnik_product_card_body_content' );
				?>
			</div>
			<?php
		}

		/**
		 * Outputs product card link.
		 */
		public function link() {
			global $product;

			if ( ! is_a( $product, 'WC_Product' ) ) {
				return;
			}

			?>
			<a
				href="<?php echo esc_url( $product->get_permalink() ); ?>"
				class="woocommerce-LoopProduct-link woocommerce-loop-product__link"
			>
				<?php
				/**
				 * Hook: redparts_sputnik_product_card_link_content.
				 *
				 * @hooked woocommerce_show_product_loop_sale_flash    - 100
				 * @hooked woocommerce_template_loop_product_thumbnail - 200
				 * @hooked woocommerce_template_loop_product_title     - 300
				 */
				do_action( 'redparts_sputnik_product_card_link_content' );
				?>
			</a>
			<?php
		}

		/**
		 * Outputs product card footer.
		 */
		public function footer() {
			?>
			<div class="th-product-card__footer">
				<?php
				/**
				 * Hook: redparts_sputnik_product_card_footer_content.
				 *
				 * @hooked woocommerce_template_loop_price - 100
				 * @hooked Product_Card::actions           - 200
				 */
				do_action( 'redparts_sputnik_product_card_footer_content' );
				?>
			</div>
			<?php
		}

		/**
		 * Outputs product card actions.
		 */
		public function actions() {
			?>
			<div class="th-product-card__actions">
				<?php
				/**
				 * Hook: redparts_sputnik_product_card_actions_content.
				 *
				 * @hooked woocommerce_template_loop_add_to_cart - 100
				 * @hooked RedParts\Sputnik\Wishlist->the_button  - 200
				 * @hooked RedParts\Sputnik\Compare->the_button   - 300
				 */
				do_action( 'redparts_sputnik_product_card_actions_content' );
				?>
			</div>
			<?php
		}
	}
}


