<?php
/**
 * Block finder widget.
 *
 * @package RedParts\Sputnik
 * @since 1.0.0
 */

namespace RedParts\Sputnik\Widgets;

use RedParts\Sputnik\Settings;
use RedParts\Sputnik\Widget;

defined( 'ABSPATH' ) || exit;

if ( ! class_exists( 'RedParts\Sputnik\Widgets\Block_Finder' ) ) {
	/**
	 * Class Block_Finder
	 */
	class Block_Finder extends Widget {
		/**
		 * Indicates whether to display the widget title or not.
		 *
		 * @var bool
		 */
		protected $display_title = false;

		/**
		 * Constructor.
		 */
		public function __construct() {
			$widget_ops = array(
				'classname'                   => 'widget_redparts_sputnik_block_finder',
				'description'                 => esc_html_x( 'Displays a part finder block.', 'Admin', 'redparts-sputnik' ),
				'customize_selective_refresh' => true,
			);

			parent::__construct(
				'redparts_sputnik_block_finder',
				esc_html_x( 'RedParts: Block Finder', 'Admin', 'redparts-sputnik' ),
				$widget_ops
			);
		}

		/**
		 * Echoes the widget content.
		 *
		 * @param array $args     Display arguments including 'before_title', 'after_title', 'before_widget', and 'after_widget'.
		 * @param array $instance The settings for the particular instance of the widget.
		 */
		public function widget( $args, $instance ) {
			if ( 'yes' !== Settings::instance()->get( 'autoparts_features' ) ) {
				return;
			}

			parent::widget( $args, $instance );
		}

		/**
		 * Echoes the widget body content.
		 *
		 * @param array $args     Display arguments including 'before_title', 'after_title', 'before_widget', and 'after_widget'.
		 * @param array $instance The settings for the particular instance of the widget.
		 */
		protected function widget_body( array $args, array $instance ) {
			$title    = isset( $instance['title'] ) ? $instance['title'] : '';
			$subtitle = isset( $instance['subtitle'] ) ? $instance['subtitle'] : '';
			$button   = isset( $instance['button'] ) ? $instance['button'] : '';
			$image    = isset( $instance['image'] ) ? absint( $instance['image'] ) : '';

			?>
			<div class="th-block th-block-finder th-block-finder--type--default">
				<div class="th-decor th-decor--type--bottom th-block-finder__decor">
					<div class="th-decor__body">
						<div class="th-decor__start"></div>
						<div class="th-decor__end"></div>
						<div class="th-decor__center"></div>
					</div>
				</div>
				<div
					class="th-block-finder__image"
					style="background-image: url('<?php echo esc_url( wp_get_attachment_image_url( $image, 'full' ) ); ?>');"
				></div>
				<div class="th-block-finder__body th-container th-container--max--xl">
					<?php if ( ! empty( $title ) || ! empty( $subtitle ) ) : ?>
						<div class="th-block-finder__header">
							<?php if ( ! empty( $title ) ) : ?>
								<div class="th-block-finder__title">
									<?php echo esc_html( $title ); ?>
								</div>
							<?php endif; ?>
							<?php if ( ! empty( $subtitle ) ) : ?>
								<div class="th-block-finder__subtitle">
									<?php echo esc_html( $subtitle ); ?>
								</div>
							<?php endif; ?>
						</div>
					<?php endif; ?>
					<form class="th-block-finder__form">
						<?php echo do_shortcode( '[redparts_sputnik_vehicle_select class="th-block-finder__vehicle-select" location="block-finder"]' ); ?>

						<button
							class="th-block-finder__button"
							type="submit"
						>
							<?php
							if ( empty( $button ) ) {
								echo esc_html__( 'Search', 'redparts-sputnik' );
							} else {
								echo esc_html( $button );
							}
							?>
						</button>
					</form>
				</div>
			</div>
			<?php
		}

		/**
		 * Returns form fields.
		 *
		 * @return array
		 */
		public function form_fields(): array {
			return array(
				array(
					'key'          => 'title',
					'label'        => esc_html__( 'Title', 'redparts-sputnik' ),
					'type'         => 'text',
					'translatable' => $this->is_elementor_widget(),
				),
				array(
					'key'          => 'subtitle',
					'label'        => esc_html__( 'Subtitle', 'redparts-sputnik' ),
					'type'         => 'text',
					'translatable' => true,
				),
				array(
					'key'          => 'button',
					'label'        => esc_html__( 'Button Text', 'redparts-sputnik' ),
					'type'         => 'text',
					'translatable' => true,
				),
				array(
					'key'   => 'image',
					'label' => esc_html__( 'Image', 'redparts-sputnik' ),
					'type'  => 'image',
				),
			);
		}

		/**
		 * Enqueue frontend scripts.
		 */
		public function enqueue_frontend_scripts() {
			wp_enqueue_script( 'redparts-sputnik-widget-block-finder' );
		}

		/**
		 * Enqueue admin scripts.
		 */
		public function enqueue_admin_scripts() {
			wp_enqueue_media();
		}
	}
}
