<?php
/**
 * Filters widget.
 *
 * @package RedParts\Sputnik
 * @since 1.0.0
 */

namespace RedParts\Sputnik\Widgets;

use RedParts\Sputnik\Widget;

defined( 'ABSPATH' ) || exit;

if ( ! class_exists( 'RedParts\Sputnik\Widgets\Filters' ) ) {
	/**
	 * Class Filters
	 */
	class Filters extends Widget {
		/**
		 * Constructor.
		 */
		public function __construct() {
			$widget_ops = array(
				'classname'                   => 'widget_redparts_sputnik_filters th-widget-filters',
				'description'                 => esc_html_x( 'Displays filter widgets.', 'Admin', 'redparts-sputnik' ),
				'customize_selective_refresh' => true,
			);

			parent::__construct(
				'redparts_sputnik_filters',
				esc_html_x( 'RedParts: Filters', 'Admin', 'redparts-sputnik' ),
				$widget_ops
			);
		}

		/**
		 * Echoes the widget content.
		 *
		 * @param array $args     Display arguments including 'before_title', 'after_title', 'before_widget', and 'after_widget'.
		 * @param array $instance The settings for the particular instance of the widget.
		 */
		public function widget( $args, $instance ) {
			static $depth = 0;

			// Check that the sidebar does not call itself.
			if ( 0 === $depth ) {
				$depth++;

				parent::widget( $args, $instance );

				$depth--;
			}
		}

		/**
		 * Echoes the widget body content.
		 *
		 * @param array $args     Display arguments including 'before_title', 'after_title', 'before_widget', and 'after_widget'.
		 * @param array $instance The settings for the particular instance of the widget.
		 */
		protected function widget_body( array $args, array $instance ) {
			global $wp_registered_sidebars;

			$sidebar = isset( $instance['sidebar'] ) ? $instance['sidebar'] : '';

			if ( ! isset( $wp_registered_sidebars[ $sidebar ] ) ) {
				$sidebar = '';
			}

			$sidebar = apply_filters( 'redparts_sputnik_widget_filters_sidebar', $sidebar, $args, $instance );

			if ( '' !== $sidebar ) :
				?>
				<div class="th-widget-filters__list" data-collapse data-collapse-open-class="th-filter--open">
					<?php dynamic_sidebar( $sidebar ); ?>
				</div>
				<?php
			endif;
		}

		/**
		 * Returns form fields.
		 *
		 * @return array
		 */
		public function form_fields(): array {
			global $wp_registered_sidebars;

			$sidebars = array(
				array(
					'key'   => '',
					'label' => esc_html__( 'Select filters sidebar', 'redparts-sputnik' ),
				),
			);

			if ( isset( $wp_registered_sidebars ) ) {
				foreach ( $wp_registered_sidebars as $wp_registered_sidebar ) {
					$sidebars[] = array(
						'key'   => $wp_registered_sidebar['id'],
						'label' => $wp_registered_sidebar['name'],
					);
				}
			}

			return array(
				array(
					'key'          => 'title',
					'label'        => esc_html__( 'Title', 'redparts-sputnik' ),
					'type'         => 'text',
					'translatable' => $this->is_elementor_widget(),
				),
				array(
					'key'     => 'sidebar',
					'label'   => esc_html__( 'Filters sidebar', 'redparts-sputnik' ),
					'type'    => 'select',
					'options' => $sidebars,
				),
			);
		}
	}
}
