<?php
if(!function_exists('wcfma_woocommerce_inactive_notice')) {
	function wcfma_woocommerce_inactive_notice() {
		?>
		<div id="message" class="error">
		<p><?php printf( __( '%sWCFM - Analytics is inactive.%s The %sWooCommerce plugin%s must be active for the WCFM - Analytics to work. Please %sinstall & activate WooCommerce%s', WCFMa_TEXT_DOMAIN ), '<strong>', '</strong>', '<a target="_blank" href="http://wordpress.org/extend/plugins/woocommerce/">', '</a>', '<a href="' . admin_url( 'plugin-install.php?tab=search&s=woocommerce' ) . '">', '&nbsp;&raquo;</a>' ); ?></p>
		</div>
		<?php
	}
}

if(!function_exists('wcfma_wcfm_inactive_notice')) {
	function wcfma_wcfm_inactive_notice() {
		?>
		<div id="message" class="error">
		<p><?php printf( __( '%sWCFM - Analytics is inactive.%s The %sWooCommerce Frontend Manager%s must be active for the WCFM - Analytics to work. Please %sinstall & activate WooCommerce Frontend Manager%s', WCFMa_TEXT_DOMAIN ), '<strong>', '</strong>', '<a target="_blank" href="https://wordpress.org/plugins/wc-frontend-manager/">', '</a>', '<a href="' . admin_url( 'plugin-install.php?tab=search&s=wc+frontend+manager' ) . '">', '&nbsp;&raquo;</a>' ); ?></p>
		</div>
		<?php
	}
}

if(!function_exists('get_wcfm_listings_stats_url')) {
	function get_wcfm_listings_stats_url( $listing_id = '' ) {
		global $WCFM;
		$wcfm_page = get_wcfm_page();
		$wcfm_listings_stats_url = wcfm_get_endpoint_url( 'wcfm-listings-stats', '', $wcfm_page );
		if( $listing_id ) $wcfm_listings_stats_url = add_query_arg( 'job_id', $listing_id, $wcfm_listings_stats_url );
		return $wcfm_listings_stats_url;
	}
}

if(!function_exists('get_wcfma_country_state_list')) {
	function get_wcfma_country_state_list() {
		$wcfma_country_state_list = array(
			'BE' => array(
				'label' => 'Belgium',
				'state' => array(
					'BE-VWV' =>	'West Flanders',
					'BE-VAN' =>	'Antwerp',
					'BE-WLX' =>	'Luxembourg',
					'BE-WBR' =>	'Walloon Brabant',
					'BE-VBR' =>	'Flemish Brabant',
					'BE-VOV' =>	'East Flanders',
					'BE-WLG' =>	'Liege',
					'BE-VLI' =>	'Limburg',
					'BE-WHT' =>	'Hainaut',
					'BE-WNA' =>	'Namur',
					'BE-BRU' =>	'Brussels'
				)
			),
			
			'DK' => array(
				'label' => 'Denmark',
				'state' => array(
					'DK-85' =>	'Sjaælland',
					'DK-84' =>	'Hovedstaden',
					'DK-81' =>	'Nordjylland',
					'DK-83' =>	'Syddanmark',
					'DK-82' =>	'Midtjylland',
				)
			),
			
			'RU' => array(
				'label' => 'Russia',
				'state' => array(
					'RU-NC' =>	'North Caucasian Federal District',
					'RU-VO' =>	'Volga Federal District',
					'RU-CE' =>	'Central Federal District',
					'RU-SI' =>	'Siberian Federal District',
					'RU-NW' =>	'Northwestern Federal District',
					'RU-SO' =>	'Southern Federal District',
					'RU-UR' =>	'Ural Federal District',
					'RU-FE' =>	'Far Eastern Federal District',
		
					'RU-PNZ' =>	'Penzenskaya oblast',
					'RU-VLA' =>	'Vladimirskaya oblast',
					'RU-LEN' =>	'Leningradskaya oblast',
					'RU-SAK' =>	'Sakhalinskaya oblast',
					'RU-KYA' =>	'Krasnoyarskiy kray',
					'RU-UD' =>	'Udmurtskaya Respublika',
					'RU-IVA' =>	'Ivanovskaya oblast',
					'RU-LIP' =>	'Lipetskaya oblast',
					'RU-AST' =>	'Astrakhanskaya oblast',
					'RU-CE' =>	'Chechenskaya Respublika',
					'RU-KHA' =>	'Khabarovskiy kray',
					'RU-ORE' =>	'Orenburgskaya oblast',
					'RU-KIR' =>	'Kirovskaya oblast',
					'RU-BA' =>	'Bashkortostan, Respublika', 
					'RU-NGR' =>	'Novgorodskaya oblast',
					'RU-KLU' =>	'Kaluzhskaya oblast',
					'RU-OMS' =>	'Omskaya oblast',
					'RU-SAR' =>	'Saratovskaya oblast',
					'RU-ORL' =>	'Orlovskaya oblast',
					'RU-STA' =>	'Stavropolskiy kray',
					'RU-SE' =>	'Severnaya Osetiya-Alaniya, Respublika',
					'RU-SAM' =>	'Samarskaya oblast',
					'RU-SA' =>	'Sakha, Respublika',
					'RU-SVE' =>	'Sverdlovskaya oblast',
					'RU-KK' =>	'Khakasiya, Respublika',
					'RU-SPE' =>	'Sankt-Peterburg',
					'RU-MOS' =>	'Moskovskaya oblast',
					'RU-BEL' =>	'Belgorodskaya oblast',
					'RU-KHM' =>	'Khanty-Mansiyskiy avtonomnyy okrug',
					'RU-VLG' =>	'Vologodskaya oblast',
					'RU-CHE' =>	'Chelyabinskaya oblast',
					'RU-YAR' =>	'Yaroslavskaya oblast',
					'RU-TUL' =>	'Tulskaya oblast',
					'RU-IRK' =>	'Irkutskaya oblast',
					'RU-NIZ' =>	'Nizhegorodskaya oblast',
					'RU-YAN' =>	'Yamalo-Nenetskiy avtonomnyy okrug',
					'RU-KGD' =>	'Kaliningradskaya oblast',
					'RU-MOW' =>	'Moskva',
					'RU-KAM' =>	'Kamchatskiy kray',
					'RU-BU' =>	'Buryatiya, Respublika',
					'RU-KEM' =>	'Kemerovskaya oblast',
					'RU-CHU' =>	'Chukotskiy avtonomnyy okrug',
					'RU-ULY' =>	'Ulyanovskaya oblast',
					'RU-KGN' =>	'Kurganskaya oblast',
					'RU-KRS' =>	'Kurskaya oblast',
					'RU-KR' =>	'Kareliya, Respublika',
					'RU-ME' =>	'Mariy El Respublika',
					'RU-IN' =>	'Ingushetiya, Respublika',
					'RU-MAG' =>	'Magadanskaya oblast',
					'RU-MO' =>	'Mordoviya, Respublika',
					'RU-TA' =>	'Tatarstan, Respublika',
					'RU-ZAB' =>	'Zabaykalskiy kray',
					'RU-RYA' =>	'Ryazanskaya oblast',
					'RU-TAM' =>	'Tambovskaya oblast',
					'RU-ARK' =>	'Arkhangelskaya oblast',
					'RU-KC' =>	'Karachayevo-Cherkesskaya Respublika',
					'RU-TY' =>	'Tyva, Respublika [Tuva]',
					'RU-MUR' =>	'Murmanskaya oblast',
					'RU-VOR' =>	'Voronezhskaya oblast',
					'RU-PSK' =>	'Pskovskaya oblast',
					'RU-TVE' =>	'Tverskaya oblast',
					'RU-VGG' =>	'Volgogradskaya oblast',
					'RU-KOS' =>	'Kostromskaya oblast',
					'RU-KL' =>	'Kalmykiya, Respublika',
					'RU-TOM' =>	'Tomskaya oblast',
					'RU-KO' =>	'Komi, Respublika',
					'RU-TYU' =>	'Tyumenskaya oblast',
					'RU-DA' =>	'Dagestan, Respublika',
					'RU-NVS' =>	'Novosibirskaya oblast',
					'RU-AD' =>	'Adygeya, Respublika',
					'RU-PER' =>	'Permskiy kray',
					'RU-ROS' =>	'Rostovskaya oblast',
					'RU-PRI' =>	'Primorskiy kray',
					'RU-KB' =>	'Kabardino-Balkarskaya Respublika',
					'RU-AL' =>	'Altay, Respublika',
					'RU-NEN' =>	'Nenetskiy avtonomnyy okrug',
					'RU-ALT' =>	'Altayskiy kray',
					'RU-KDA' =>	'Krasnodarskiy kray',
					'RU-YEV' =>	'Yevreyskaya avtonomnaya oblast',
					'RU-AMU' =>	'Amurskaya oblast',
					'RU-BRY' =>	'Bryanskaya oblast',
					'RU-SMO' =>	'Smolenskaya oblast',
					'RU-CU' =>	'Chuvashskaya Respublika'
				)
			),
			
			'UK' => array(
				'label' => 'United Kingdom',
				'state' => array(
					'UKF' =>	'East Midlands',
					'WLS' =>	'Wales',
					'NIR' =>	'Northern Ireland',
					'UKK' =>	'South West',
					'UKJ' =>	'South East',
					'UKI' =>	'London',
					'UKH' =>	'East',
					'UKG' =>	'West Midlands',
					'SCT' =>	'Scotalnd',
					'UKE' =>	'Yorkshire and the Humber',
					'UKD' =>	'North West',
					'UKC' =>	'North East',
		
					'NIR' =>	'Northern Ireland',
					'SCT' =>	'Scotland',
					'WLS' =>	'Wales',
					'ENG' =>	'England'
				)
			),
			
			'PT' => array(
				'label' => 'Portugal',
				'state' => array(
					'PT-13' =>	'Porto',
					'PT-12' =>	'Portalegre',
					'PT-11' =>	'Lisboa',
					'PT-10' =>	'Leiria',
					'PT-08' =>	'Faro',
					'PT-16' =>	'Viana do Castelo',
					'PT-20' =>	'Azores',
					'PT-14' =>	'Santarém',
					'PT-04' =>	'Bragança',
					'PT-05' =>	'Castelo Branco',
					'PT-06' =>	'Coimbra',
					'PT-07' =>	'Évora',
					'PT-01' =>	'Aveiro',
					'PT-02' =>	'Beja',
					'PT-03' =>	'Braga',
					'PT-09' =>	'Guarda',
					'PT-15' =>	'Setúbal',
					'PT-17' =>	'Vila Real',
					'PT-18' =>	'Viseu',
					'PT-30' =>	'Madeira'
				)
			),
			
			'PL' => array(
				'label' => 'Poland',
				'state' => array(
					'PL-WP' =>	'Greater Poland',
					'PL-SK' =>	'Świętokrzyskie',
					'PL-ZP' =>	'West Pomeranian',
					'PL-SL' =>	'Silesian',
					'PL-PK' =>	'Subcarpathian',
					'PL-MZ' =>	'Masovian',
					'PL-PD' =>	'Podlachian',
					'PL-LB' =>	'Lubusz',
					'PL-LD' =>	'Łódź',
					'PL-KP' =>	'Kuyavian-Pomeranian',
					'PL-LU' =>	'Lublin',
					'PL-OP' =>	'Opole',
					'PL-PM' =>	'Pomeranian',
					'PL-DS' =>	'Lower Silesian',
					'PL-MA' =>	'Lesser Poland',
					'PL-WN' =>	'Warmian-Masurian'
				)
			),
			
			'ZA' => array(
				'label' => 'South Africa',
				'state' => array(
					'ZA-WC' =>	'Western Cape',
					'ZA-FS' =>	'Orange Free State',
					'ZA-EC' =>	'Eastern Cape',
					'ZA-NC' =>	'Northern Cape',
					'ZA-LP' =>	'Limpopo',
					'ZA-MP' =>	'Mpumalanga',
					'ZA-NL' =>	'KwaZulu-Natal',
					'ZA-NW' =>	'North West',
					'ZA-GT' =>	'Gauteng'
		
				)
			),
			
			'IT' => array(
				'label' => 'Italy',
				'state' => array(
					'IT-BA' => 'Bari',
					'IT-BG' =>	'Bergamo',
					'IT-BI' =>	'Biella',
					'IT-BO' =>	'Bologna',
					'IT-BN' =>	'Benevento',
					'IT-BL' =>	'Belluno',
					'IT-BS' =>	'Brescia',
					'IT-BR' =>	'Brindisi',
					'IT-BT' =>	'Barletta-Andria Trani',
					'IT-BZ' =>	'Bozen',
					'IT-RC' =>	'Reggio Calabria', 
					'IT-RA' =>	'Ravenna',
					'IT-RG' =>	'Ragusa',
					'IT-RE' =>	'Reggio Emilia', 
					'IT-RI' =>	'Rieti',
					'IT-RO' =>	'Rovigo',
					'IT-RN' =>	'Rimini',
					'IT-RM' =>	'Roma',
					'IT-AG' =>	'Agrigento',
					'IT-AN' =>	'Ancona',
					'IT-AO' =>	'Aoste',
					'IT-AL' =>	'Alessandria',
					'IT-IS' =>	'Isernia',
					'IT-AV' =>	'Avellino',
					'IT-AT' =>	'Asti',
					'IT-IM' =>	'Imperia',
					'IT-AR' =>	'Arezzo',
					'IT-AP' =>	'Ascoli Piceno', 
					'IT-AQ' =>	'L Aquila', 
					'IT-VE' =>	'Venezia',
					'IT-LC' =>	'Lecco',
					'IT-LE' =>	'Lecce',
					'IT-LI' =>	'Livorno',
					'IT-TP' =>	'Trapani',
					'IT-TS' =>	'Trieste',
					'IT-TR' =>	'Terni',
					'IT-LO' =>	'Lodi',
					'IT-TV' =>	'Treviso',
					'IT-LU' =>	'Lucca',
					'IT-LT' =>	'Latina',
					'IT-TO' =>	'Turin',
					'IT-TN' =>	'Trento',
					'IT-TA' =>	'Taranto',
					'IT-TE' =>	'Teramo',
					'IT-CL' =>	'Caltanissetta',
					'IT-CN' =>	'Cuneo',
					'IT-CO' =>	'Como',
					'IT-CH' =>	'Chieti',
					'IT-CI' =>	'Carbonia-Iglesias',
					'IT-CE' =>	'Caserta',
					'IT-CA' =>	'Cagliari',
					'IT-CB' =>	'Campobasso',
					'IT-CZ' =>	'Catanzaro',
					'IT-CT' =>	'Catania',
					'IT-CR' =>	'Cremona',
					'IT-CS' =>	'Cosenza',
					'IT-SV' =>	'Savona',
					'IT-SP' =>	'La Spezia', 
					'IT-SR' =>	'Siracusa',
					'IT-SS' =>	'Sassari',
					'IT-SO' =>	'Sondrio',
					'IT-SI' =>	'Siena',
					'IT-KR' =>	'Crotene',
					'IT-SA' =>	'Salerno',
					'IT-VR' =>	'Verona',
					'IT-FR' =>	'Frosinone',
					'IT-FG' =>	'Foggia',
					'IT-FE' =>	'Ferrara',
					'IT-FC' =>	'Forlì-Cesena',
					'IT-FM' =>	'Fermo',
					'IT-FI' =>	'Firenze',
					'IT-NO' =>	'Novara',
					'IT-NA' =>	'Napoli',
					'IT-NU' =>	'Nuoro',
					'IT-EN' =>	'Enna',
					'IT-MB' =>	'Monza e Brianza', 
					'IT-MC' =>	'Macerata',
					'IT-ME' =>	'Messina',
					'IT-MI' =>	'Milano',
					'IT-MN' =>	'Mantova',
					'IT-MO' =>	'Modena',
					'IT-MS' =>	'Massa-Carrara',
					'IT-MT' =>	'Matera',
					'IT-UD' =>	'Udine',
					'IT-PU' =>	'Pesaro e Urbino', 
					'IT-PT' =>	'Pistoia',
					'IT-PV' =>	'Pavia',
					'IT-PR' =>	'Parma',
					'IT-PZ' =>	'Potenza',
					'IT-PE' =>	'Pescara',
					'IT-PD' =>	'Padova',
					'IT-PG' =>	'Perugia',
					'IT-PA' =>	'Palermo',
					'IT-PC' =>	'Piacenza',
					'IT-PO' =>	'Prato',
					'IT-PN' =>	'Pordenone',
					'IT-PI' =>	'Pisa',
					'IT-GR' =>	'Grosseto',
					'IT-VC' =>	'Vercelli',
					'IT-VB' =>	'Verbano-Cusio-Ossola',
					'IT-VA' =>	'Varese',
					'IT-VI' =>	'Vicenza',
					'IT-VV' =>	'Vibo Valentia', 
					'IT-VT' =>	'Viterbo',
					'IT-VS' =>	'Medio Campidano', 
					'IT-GE' =>	'Genova',
					'IT-GO' =>	'Gorizia',
					'IT-OG' =>	'Ogliastra',
					'IT-OR' =>	'Oristrano',
					'IT-OT' =>	'Olbia-Tempio',
					'IT-23' =>	'Valle d Aosta',
					'IT-21' =>	'Piemonte',
					'IT-25' =>	'Lombardia',
					'IT-52' =>	'Toscana',
					'IT-36' =>	'Friuli-Venezia Giulia',
					'IT-42' =>	'Liguria',
					'IT-45' =>	'Emilia-Romagna',
					'IT-57' =>	'Marche',
					'IT-32' =>	'Trentino-Alto Adige',
					'IT-55' =>	'Umbria',
					'IT-67' =>	'Molise',
					'IT-34' =>	'Veneto',
					'IT-65' =>	'Abruzzo',
					'IT-62' =>	'Lazio',
					'IT-75' =>	'Apulia',
					'IT-77' =>	'Basilicata',
					'IT-78' =>	'Calabria',
					'IT-82' =>	'Sicily',
					'IT-72' =>	'Campania',
					'IT-88' =>	'Sardegna'
				)
			),
			
			'ES' => array(
				'label' => 'Spain',
				'state' => array(
					'ES-NA' =>	'Navarra',
					'ES-B' =>	'Barcelona',
					'ES-CS' =>	'Castellón',
					'ES-ZA' =>	'Zamora',
					'ES-O' =>	'Asturias',
					'ES-OR' =>	'Orense',
					'ES-M' =>	'Madrid',
					'ES-L' =>	'Lérida',
					'ES-J' =>	'Jaén',
					'ES-H' =>	'Huelva',
					'ES-CU' =>	'Cuenca',
					'ES-T' =>	'Tarragona',
					'ES-C' =>	'La Coruña',
					'ES-AV' =>	'Ávila',
					'ES-A' =>	'Alicante',
					'ES-CR' =>	'Ciudad Real',
					'ES-CO' =>	'Córdoba',
					'ES-VA' =>	'Valladolid',
					'ES-TF' =>	'Santa Cruz de Tenerife',
					'ES-Z' =>	'Zaragoza',
					'ES-MA' =>	'Málaga',
					'ES-AL' =>	'Almería',
					'ES-CE' =>	'Ceuta',
					'ES-PM' =>	'Baleares',
					'ES-VI' =>	'Álava',
					'ES-S' =>	'Cantabria',
					'ES-TE' =>	'Teruel',
					'ES-CC' =>	'Cáceres',
					'ES-P' =>	'Palencia',
					'ES-PO' =>	'Pontevedra',
					'ES-GC' =>	'Las Palmas',
					'ES-GI' =>	'Gerona',
					'ES-TO' =>	'Toledo',
					'ES-MU' =>	'Murcia',
					'ES-GR' =>	'Granada',
					'ES-GU' =>	'Guadalajara',
					'ES-AB' =>	'Albacete',
					'ES-SO' =>	'Soria',
					'ES-ML' =>	'Melilla',
					'ES-LU' =>	'Lugo',
					'ES-SE' =>	'Sevilla',
					'ES-CA' =>	'Cádiz',
					'ES-SG' =>	'Segovia',
					'ES-BU' =>	'Burgos',
					'ES-SA' =>	'Salamanca',
					'ES-V' =>	'Valencia',
					'ES-LE' =>	'León',
					'ES-BI' =>	'Bizkaia',
					'ES-HU' =>	'Huesca',
					'ES-LO' =>	'La Rioja',
					'ES-SS' =>	'Gipuzkoa',
					'ES-BA' =>	'Badajoz',
		
					'FR-C' =>	'Auvergne',
					'FR-B' =>	'Aquitaine',
					'FR-A' =>	'Alsace',
					'FR-G' =>	'Champagne-Ardenne',
					'FR-F' =>	'Centre',
					'FR-E' =>	'Bretagne',
					'FR-D' =>	'Bourgogne',
					'FR-K' =>	'Languedoc-Roussillon',
					'FR-J' =>	'Île-de-France',
					'FR-I' =>	'Franche-Comté',
					'FR-YT' =>	'Mayotte',
					'FR-O' =>	'Nord-Pas-de-Calais',
					'FR-N' =>	'Midi-Pyrénées',
					'FR-M' =>	'Lorraine',
					'FR-L' =>	'Limousin',
					'FR-S' =>	'Picardie',
					'FR-R' =>	'Pays de la Loire',
					'FR-Q' =>	'Haute-Normandie',
					'FR-P' =>	'Basse-Normandie',
					'FR-V' =>	'Rhône-Alpes',
					'FR-U' =>	'Provence-Alpes-Côte-d Azur',
					'FR-T' =>	'Poitou-Charentes',
					'FR-RE' =>	'Réunion',
					'FR-GF' =>	'Guyane française',
					'FR-H' =>	'Corse',
					'FR-MQ' =>	'Martinique',
					'FR-GP' =>	'Guadeloupe'
				)
			),
			
			'FR' => array(
				'label' => 'France',
				'state' => array(
					'FR-28' =>	'Eure-et-Loir',
					'FR-29' =>	'Finistère',
					'FR-22' =>	'Côtes-d Armor',
					'FR-23' =>	'Creuse',
					'FR-21' =>	'Côte-d Or',
					'FR-26' =>	'Drôme',
					'FR-27' =>	'Eure',
					'FR-24' =>	'Dordogne',
					'FR-25' =>	'Doubs',
					'FR-MQ' =>	'Martinique',
					'FR-94' =>	'Val-de-Marne',
					'FR-93' =>	'Seine-Saint-Denis',
					'FR-92' =>	'Hauts-de-Seine',
					'FR-91' =>	'Essonne',
					'FR-90' =>	'Territoire de Belfort',
					'FR-17' =>	'Charente-Maritime',
					'FR-16' =>	'Charente',
					'FR-15' =>	'Cantal',
					'FR-14' =>	'Calvados',
					'FR-13' =>	'Bouches-du-Rhône',
					'FR-12' =>	'Aveyron',
					'FR-11' =>	'Aude',
					'FR-10' =>	'Aube',
					'FR-2B' =>	'Haute-Corse',
					'FR-2A' =>	'Corse-du-Sud',
					'FR-19' =>	'Corrèze',
					'FR-18' =>	'Cher',
					'FR-88' =>	'Vosges',
					'FR-89' =>	'Yonne',
					'FR-80' =>	'Somme',
					'FR-81' =>	'Tarn',
					'FR-82' =>	'Tarn-et-Garonne',
					'FR-83' =>	'Var',
					'FR-84' =>	'Vaucluse',
					'FR-85' =>	'Vendée',
					'FR-86' =>	'Vienne',
					'FR-87' =>	'Haute-Vienne',
					'FR-01' =>	'Ain',
					'FR-02' =>	'Aisne',
					'FR-03' =>	'Allier',
					'FR-04' =>	'Alpes-de-Haute-Provence',
					'FR-05' =>	'Hautes-Alpes',
					'FR-06' =>	'Alpes-Maritimes',
					'FR-07' =>	'Ardèche',
					'FR-08' =>	'Ardennes',
					'FR-09' =>	'Ariège',
					'FR-RE' =>	'La Réunion',
					'FR-75' =>	'Paris',
					'FR-74' =>	'Haute-Savoie',
					'FR-77' =>	'Seien-et-Marne',
					'FR-76' =>	'Seine-Maritime',
					'FR-71' =>	'Saône-et-Loire',
					'FR-70' =>	'Haute-Saône',
					'FR-73' =>	'Savoie',
					'FR-72' =>	'Sarthe',
					'FR-79' =>	'Deux-Sèvres',
					'FR-78' =>	'Yvelines',
					'FR-YT' =>	'Mayotte',
					'FR-66' =>	'Pyrénées-Orientales',
					'FR-67' =>	'Bas-Rhin',
					'FR-64' =>	'Pyrénées-Atlantiques',
					'FR-65' =>	'Hautes-Pyrénées',
					'FR-62' =>	'Pas-de-Calais',
					'FR-63' =>	'Puy-de-Dôme',
					'FR-60' =>	'Oise',
					'FR-61' =>	'Orne',
					'FR-68' =>	'Haute-Rhin',
					'FR-69' =>	'Rhône',
					'FR-53' =>	'Mayenne',
					'FR-52' =>	'Haute-Marne',
					'FR-51' =>	'Marne',
					'FR-50' =>	'Manche',
					'FR-57' =>	'Moselle',
					'FR-56' =>	'Morbihan',
					'FR-55' =>	'Meuse',
					'FR-54' =>	'Meurhe-et-Moselle',
					'FR-59' =>	'Nord',
					'FR-58' =>	'Nièvre',
					'FR-48' =>	'Lozère',
					'FR-49' =>	'Maine-et-Loire',
					'FR-44' =>	'Loire-Atlantique',
					'FR-45' =>	'Loiret',
					'FR-46' =>	'Lot',
					'FR-47' =>	'Lot-et-Garonne',
					'FR-40' =>	'Landes',
					'FR-41' =>	'Loir-et-Cher',
					'FR-42' =>	'Loire',
					'FR-43' =>	'Haute-Loire',
					'FR-95' =>	'Val-d Oise',
					'FR-GF' =>	'Guyane française',
					'FR-GP' =>	'Guadeloupe',
					'FR-39' =>	'Jura',
					'FR-38' =>	'Isère',
					'FR-31' =>	'Haute-Garonne',
					'FR-30' =>	'Gard',
					'FR-33' =>	'Gironde',
					'FR-32' =>	'Gers',
					'FR-35' =>	'Ille-et-Vilaine',
					'FR-34' =>	'Hérault',
					'FR-37' =>	'Indre-et-Loire',
					'FR-36' =>	'Indre'
				)
			),
			
			'NL' => array(
				'label' => 'Netherlands',
				'state' => array(
					'NL-OV' =>	'Overijssel',
					'NL-FR' =>	'Friesland',
					'NL-UT' =>	'Utrecht',
					'NL-GE' =>	'Gelderland',
					'NL-FL' =>	'Flevoland',
					'NL-NH' =>	'Noord-Holland',
					'NL-ZE' =>	'Zeeland',
					'NL-ZH' =>	'Zuid-Holland',
					'NL-GR' =>	'Groningen',
					'NL-DR' =>	'Drenthe',
					'NL-NB' =>	'Noord-Brabant',
					'NL-LI' =>	'Limburg'
				)
			),
			'NO' => array(
				'label' => 'Norway',
				'state' => array(
					'NO-' =>	'Finnmark',
					'NO-01' =>	'Østfold',
					'NO-07' =>	'Vestfold',
					'NO-06' =>	'Buskerud',
					'NO-21' =>	'Svalbard',
					'NO-03' =>	'Oslo',
					'NO-05' =>	'Oppland',
					'NO-10' =>	'Vest-Agder',
					'NO-11' =>	'Rogaland',
					'NO-12' =>	'Hordaland',
					'NO-04' =>	'Hedmark',
					'NO-14' =>	'Sogn og Fjordane',
					'NO-15' =>	'Møre og Romsdal',
					'NO-16' =>	'Sør-Trøndelag',
					'NO-17' =>	'Nord-Trøndelag',
					'NO-18' =>	'Nordland',
					'NO-19' =>	'Troms',
					'NO-08' =>	'Telemark',
					'NO-09' =>	'Aust-Agder',
					'NO-02' =>	'Akershus'
				)
			),
			
			'NZ' => array(
				'label' => 'New Zealand',
				'state' => array(
					'NZ-NSN' =>	'Nelson City',
					'NZ-STL' =>	'Southland',
					'NZ-HKB' =>	'Hawkes Bay',
					'NZ-BOP' =>	'Bay of Plenty',
					'NZ-AUK' =>	'Auckland',
					'NZ-TKI' =>	'Taranaki',
					'NZ-MBH' =>	'Marlborough District',
					'NZ-TAS' =>	'Tasman District',
					'NZ-CIT' =>	'Chatham Islands Territory',
					'NZ-WKO' =>	'Waikato',
					'NZ-WTC' =>	'West Coast',
					'NZ-OTA' =>	'Otago',
					'NZ-' =>	'The Snares',
					'NZ-NTL' =>	'Northland',
					'NZ-MWT' =>	'Manawatu-Wanganui',
					'NZ-WGN' =>	'Wellington',
					'NZ-GIS' =>	'Gisborne District',
					'NZ-CAN' =>	'Canterbury'
				)
			),
			
			'CH' => array(
				'label' => 'Switzerland',
				'state' => array(
					'CH-SO' =>	'Solothurn',
					'CH-LU' =>	'Lucerne',
					'CH-SH' =>	'Schaffhausen',
					'CH-SG' =>	'Sankt Gallen',
					'CH-UR' =>	'Uri',
					'CH-NE' =>	'Neuchâtel',
					'CH-BS' =>	'Basel-Stadt',
					'CH-JU' =>	'Jura',
					'CH-BL' =>	'Basel-Landschaft',
					'CH-SZ' =>	'Schwyz',
					'CH-BE' =>	'Bern',
					'CH-NW' =>	'Nidwalden',
					'CH-ZG' =>	'Zug',
					'CH-FR' =>	'Fribourg',
					'CH-ZH' =>	'Zürich',
					'CH-VS' =>	'Valais',
					'CH-VD' =>	'Vaud',
					'CH-TI' =>	'Ticino',
					'CH-TG' =>	'Thurgau',
					'CH-OW' =>	'Obwalden',
					'CH-AG' =>	'Aargau',
					'CH-GE' =>	'Genève',
					'CH-AI' =>	'Appenzell Innerrhoden',
					'CH-GL' =>	'Glarus',
					'CH-GR' =>	'Graubünden',
					'CH-AR' =>	'Appenzell Ausserrhoden'
		
				)
			),
			'CO' => array(
				'label' => 'Colombia',
				'state' => array(
					'CO-VAC' =>	'Valle del Cauc',
					'CO-BOY' =>	'Bolíva',
					'CO-COR' =>	'Cesa',
					'CO-HUI' =>	'Huil',
					'CO-VAU' =>	'Vaupé',
					'CO-NSA' =>	'Norte de Santande',
					'CO-RIS' =>	'Risarald',
					'CO-VID' =>	'Vichad',
					'CO-BOL' =>	'Bogota',
					'CO-CUN' =>	'Chocó',
					'CO-GUV' =>	'Guaviare',
					'CO-CAU' =>	'Casanare',
					'CO-CAS' =>	'Caquetá',
					'CO-CAQ' =>	'Caldas',
					'CO-CES' =>	'Cauca',
					'CO-SAN' =>	'Santander',
					'CO-ATL' =>	'Atlántico',
					'CO-AMA' =>	'Amazonas',
					'CO-MET' =>	'Meta',
					'CO-MAG' =>	'Magdalena',
					'CO-ARA' =>	'Arauca',
					'CO-GUA' =>	'Guainía',
					'CO-SAP' =>	'San Andrés y Providencia',
					'CO-CAL' =>	'Boyacá',
					'CO-QUI' =>	'Quindío',
					'CO-LAG' =>	'La Guajira',
					'CO-TOL' =>	'Tolima',
					'CO-SUC' =>	'Sucre',
					'CO-PUT' =>	'Putumayo',
					'CO-NAR' =>	'Nariño',
					'CO-CHO' =>	'Córdoba',
					'CO-' =>	'',
					'CO-DC' =>	'Cundinamarca',
					'CO-ANT' =>	'Antioquia'
				)
			),
			'CN' => array(
				'label' => 'China',
				'state' => array(
					'CN-32' =>	'Jiangsu',
					'CN-52' =>	'Guizhou',
					'CN-53' =>	'Yunnan',
					'CN-50' =>	'Chongqing',
					'CN-51' =>	'Sichuan',
					'CN-31' =>	'Shanghai',
					'CN-54' =>	'Xizang',
					'CN-33' =>	'Zhejiang',
					'CN-15' =>	'Inner Mongol',
					'CN-14' =>	'Shanxi',
					'CN-' =>	'Fujian',
					'CN-12' =>	'Tianjin',
					'CN-13' =>	'Hebei',
					'CN-11' =>	'Beijing',
					'CN-34' =>	'Anhui',
					'CN-36' =>	'Jiangxi',
					'CN-37' =>	'Shandong',
					'CN-41' =>	'Henan',
					'CN-43' =>	'Hunan',
					'CN-42' =>	'Hubei',
					'CN-45' =>	'Guangxi',
					'CN-44' =>	'Guangdong',
					'CN-46' =>	'Hainan',
					'CN-65' =>	'Xinjiang',
					'CN-64' =>	'Ningxia',
					'CN-63' =>	'Qinghai',
					'CN-62' =>	'Gansu',
					'CN-61' =>	'Shaanxi',
					'CN-23' =>	'Heilongjiang',
					'CN-22' =>	'Jilin',
					'CN-21' =>	'Liaoning'
				)
			),
			
			'CA' => array(
				'label' => 'Canada',
				'state' => array(
					'CA-NT' =>	'Northwest Territories',
					'CA-NU' =>	'Nunavut',
					'CA-NS' =>	'Nova Scotia',
					'CA-BC' =>	'British Columbia',
					'CA-SK' =>	'Saskatchewan',
					'CA-QC' =>	'Québec',
					'CA-PE' =>	'Prince Edward Island',
					'CA-MB' =>	'Manitoba',
					'CA-YT' =>	'Yukon',
					'CA-NB' =>	'New Brunswick',
					'CA-NL' =>	'Newfoundland and Labrador',
					'CA-ON' =>	'Ontario',
					'CA-AB' =>	'Alberta'
				)
			),
			
			'KR' => array(
				'label' => 'Korea',
				'state' => array(
					'KR-31' =>	'Ulsan',
					'KR-49' =>	'Jeju',
					'KR-48' =>	'South Gyeongsang',
					'KR-45' =>	'North Jeolla',
					'KR-44' =>	'South Chungcheong',
					'KR-47' =>	'North Gyeongsang',
					'KR-46' =>	'South Jeolla',
					'KR-41' =>	'Gyeonggi',
					'KR-43' =>	'North Chungcheong',
					'KR-42' =>	'Gangwon',
					'KR-27' =>	'Daegu',
					'KR-11' =>	'Seoul',
					'KR-50' =>	'Sejong',
					'KR-29' =>	'Gwangju',
					'KR-28' =>	'Incheon',
					'KR-30' =>	'Daejeon',
					'KR-26' =>	'Busan'
				)
			),
			
			'SE' => array(
				'label' => 'Sweden',
				'state' => array(
					'SE-O' =>	'Västra Götaland',
					'SE-N' =>	'Halland',
					'SE-M' =>	'Skåne',
					'SE-K' =>	'Blekinge',
					'SE-I' =>	'Gotland',
					'SE-H' =>	'Kalmar',
					'SE-G' =>	'Kronoberg',
					'SE-F' =>	'Jönköping',
					'SE-E' =>	'Östergötland',
					'SE-D' =>	'Södermanland',
					'SE-C' =>	'Uppsala',
					'SE-Z' =>	'Jämtland',
					'SE-Y' =>	'Västernorrland',
					'SE-X' =>	'Gävleborg',
					'SE-W' =>	'Dalarna',
					'SE-BD' =>	'Norrbotten',
					'SE-T' =>	'Orebro',
					'SE-S' =>	'Värmland',
					'SE-U' =>	'Västmanland',
					'SE-AC' =>	'Västerbotten',
					'SE-AB' =>	'Stockholm',
					'SE-' => ''	
		
				)
			),
			
			'DE' => array(
				'label' => 'Germany',
				'state' => array(
				'DE-BE' =>	'Berlin',
				'DE-ST' =>	'Sachsen-Anhalt',
				'DE-RP' =>	'Rheinland-Pfalz',
				'DE-BB' =>	'Brandenburg',
				'DE-NI' =>	'Niedersachsen',
				'DE-MV' =>	'Mecklenburg-Vorpommern',
				'DE-TH' =>	'Thüringen',
				'DE-BW' =>	'Baden-Württemberg',
				'DE-HH' =>	'Hamburg',
				'DE-SH' =>	'Schleswig-Holstein',
				'DE-NW' =>	'Nordrhein-Westfalen',
				'DE-SN' =>	'Sachsen',
				'DE-HB' =>	'Bremen',
				'DE-SL' =>	'Saarland',
				'DE-BY' =>	'Bayern',
				'DE-HE' =>	'Hessen',
				)
			),
			
			'US' => array(
				'label' => 'United States',
				'state' => array(
					'US-VA' =>	'Virginia',
					'US-PA' =>	'Pennsylvania',
					'US-TN' =>	'Tennessee',
					'US-WV' =>	'West Virginia',
					'US-NV' =>	'Nevada',
					'US-TX' =>	'Texas',
					'US-NH' =>	'New Hampshire',
					'US-NY' =>	'New York',
					'US-HI' =>	'Hawaii',
					'US-VT' =>	'Vermont',
					'US-NM' =>	'New Mexico',
					'US-NC' =>	'North Carolina',
					'US-ND' =>	'North Dakota',
					'US-NE' =>	'Nebraska',
					'US-LA' =>	'Louisiana',
					'US-SD' =>	'South Dakota',
					'US-DC' =>	'District of Columbia',
					'US-DE' =>	'Delaware',
					'US-FL' =>	'Florida',
					'US-CT' =>	'Connecticut',
					'US-WA' =>	'Washington',
					'US-KS' =>	'Kansas',
					'US-WI' =>	'Wisconsin',
					'US-OR' =>	'Oregon',
					'US-KY' =>	'Kentucky',
					'US-ME' =>	'Maine',
					'US-OH' =>	'Ohio',
					'US-OK' =>	'Oklahoma',
					'US-ID' =>	'Idaho',
					'US-WY' =>	'Wyoming',
					'US-UT' =>	'Utah',
					'US-IN' =>	'Indiana',
					'US-IL' =>	'Illinois',
					'US-AK' =>	'Alaska',
					'US-NJ' =>	'New Jersey',
					'US-CO' =>	'Colorado',
					'US-MD' =>	'Maryland',
					'US-MA' =>	'Massachusetts',
					'US-AL' =>	'Alabama',
					'US-MO' =>	'Missouri',
					'US-MN' =>	'Minnesota',
					'US-CA' =>	'California',
					'US-IA' =>	'Iowa',
					'US-MI' =>	'Michigan',
					'US-GA' =>	'Georgia',
					'US-AZ' =>	'Arizona',
					'US-MT' =>	'Montana',
					'US-MS' =>	'Mississippi',
					'US-SC' =>	'South Carolina',
					'US-RI' =>	'Rhode Island',
					'US-AR' =>	'Arkansas'
				)
			),
			
			'TH' => array(
				'label' => 'Thailand',
				'state' => array(
					'TH-57' =>	'Chiang Rai',
					'TH-56' =>	'Phayao',
					'TH-55' =>	'Nan',
					'TH-54' =>	'Phrae',
					'TH-53' =>	'Uttaradit',
					'TH-52' =>	'Lampang',
					'TH-51' =>	'Lamphun',
					'TH-50' =>	'Chiang Mai',
					'TH-93' =>	'Phatthalung',
					'TH-92' =>	'Trang',
					'TH-91' =>	'Satun',
					'TH-90' =>	'Songkhla',
					'TH-96' =>	'Narathiwat',
					'TH-95' =>	'Yala',
					'TH-58' =>	'Mae Hong Son',
					'TH-13' =>	'Pathum Thani',
					'TH-12' =>	'Nonthaburi',
					'TH-11' =>	'Samut Prakan',
					'TH-10' =>	'Bangkok Metropolis',
					'TH-17' =>	'Sing Buri',
					'TH-16' =>	'Lop Buri',
					'TH-15' =>	'Ang Thong',
					'TH-14' =>	'Phra Nakhon Si Ayutthaya',
					'TH-71' =>	'Kanchanaburi',
					'TH-70' =>	'Ratchaburi',
					'TH-19' =>	'Saraburi',
					'TH-72' =>	'Suphan Buri',
					'TH-75' =>	'Samut Songkhram',
					'TH-73' =>	'Nakhon Pathom',
					'TH-77' =>	'Prachuap Khiri Khan',
					'TH-76' =>	'Phetchaburi',
					'TH-18' =>	'Chai Nat',
					'TH-39' =>	'Nong Bua Lam Phu',
					'TH-' =>	'',
					'TH-74' =>	'Samut Sakhon',
					'TH-84' =>	'Surat Thani',
					'TH-85' =>	'Ranong',
					'TH-86' =>	'Chumphon',
					'TH-80' =>	'Nakhon Si Thammarat',
					'TH-81' =>	'Krabi',
					'TH-82' =>	'Phangnga',
					'TH-83' =>	'Phuket',
					'TH-32' =>	'Surin',
					'TH-40' =>	'Khon Kaen',
					'TH-41' =>	'Udon Thani',
					'TH-42' =>	'Loei',
					'TH-43' =>	'Nong Khai',
					'TH-44' =>	'Maha Sarakham',
					'TH-45' =>	'Roi Et',
					'TH-46' =>	'Kalasin',
					'TH-47' =>	'Sakon Nakhon',
					'TH-48' =>	'Nakhon Phanom',
					'TH-49' =>	'Mukdahan',
					'TH-26' =>	'Nakhon Nayok',
					'TH-27' =>	'Sa Kaeo',
					'TH-24' =>	'Chachoengsao',
					'TH-25' =>	'Prachin Buri',
					'TH-22' =>	'Chanthaburi',
					'TH-23' =>	'Trat',
					'TH-20' =>	'Chon Buri',
					'TH-21' =>	'Rayong',
					'TH-62' =>	'Kamphaeng Phet',
					'TH-63' =>	'Tak',
					'TH-60' =>	'Nakhon Sawan',
					'TH-61' =>	'Uthai Thani',
					'TH-66' =>	'Phichit',
					'TH-67' =>	'Phetchabun',
					'TH-64' =>	'Sukhothai',
					'TH-65' =>	'Phitsanulok',
					'TH-35' =>	'Yasothon',
					'TH-34' =>	'Ubon Ratchathani',
					'TH-37' =>	'Amnat Charoen',
					'TH-33' =>	'Si Sa Ket',
					'TH-38' =>	'Bueng Kan',
					'TH-36' =>	'Chaiyaphum',
					'TH-31' =>	'Buri Ram',
					'TH-94' =>	'Pattani',
					'TH-30' =>	'Nakhon Ratchasima'
				)
			),
			
			'VE' => array(
				'label' => 'Venezuela',
				'state' => array(
					'VE-' => '',	
					'VE-L' =>	'Mérida',
					'VE-M' =>	'Miranda',
					'VE-N' =>	'Monagas',
					'VE-O' =>	'Nueva Esparta',
					'VE-H' =>	'Cojedes',
					'VE-I' =>	'Falcón',
					'VE-J' =>	'Guárico',
					'VE-K' =>	'Lara',
					'VE-D' =>	'Aragua',
					'VE-E' =>	'Barinas',
					'VE-F' =>	'Bolívar',
					'VE-G' =>	'Carabobo',
					'VE-A' =>	'Distrito Capital',
					'VE-B' =>	'Anzoátegui',
					'VE-C' =>	'Apure',
					'VE-X' =>	'Vargas',
					'VE-Y' =>	'Delta Amacuro',
					'VE-Z' =>	'Amazonas',
					'VE-T' =>	'Trujillo',
					'VE-U' =>	'Yaracuy',
					'VE-V' =>	'Zulia',
					'VE-W' =>	'Dependencias Federales',
					'VE-P' =>	'Portuguesa',
					'VE-R' =>	'Sucre',
					'VE-S' =>	'Táchira'
				)
			),
			
			'AR' => array(
				'label' => 'Argentina',
				'state' => array(
					'AR-Z' =>	'Santa Cruz',
					'AR-X' =>	'Córdoba',
					'AR-Y' =>	'Jujuy',
					'AR-V' =>	'Tierra del Fuego',
					'AR-W' =>	'Corrientes',
					'AR-T' =>	'Tucumán',
					'AR-U' =>	'Chubut',
					'AR-R' =>	'Río Negro',
					'AR-S' =>	'Santa Fe',
					'AR-P' =>	'Formosa',
					'AR-Q' =>	'Neuquén',
					'AR-N' =>	'Misiones',
					'AR-L' =>	'La Pampa',
					'AR-M' =>	'Mendoza',
					'AR-J' =>	'San Juan',
					'AR-K' =>	'Catamarca',
					'AR-H' =>	'Chaco',
					'AR-F' =>	'La Rioja',
					'AR-G' =>	'Santiago del Estero',
					'AR-D' =>	'San Luis',
					'AR-E' =>	'Entre Ríos',
					'AR-B' =>	'Buenos Aires',
					'AR-C' =>	'Ciudad de Buenos Aires',
					'AR-A' => 'Salta'	
				)
			),
			'AU' => array(
				'label' => 'Australia',
				'state' => array(
					'AU-ACT' =>	'Australian Capital Territory',
					'AU-WA' =>	'Western Australia',
					'AU-TAS' =>	'Tasmania',
					'AU-' =>	'Jervis Bay Territory',
					'AU-VIC' =>	'Victoria',
					'AU-NT' =>	'Northern Territory',
					'AU-QLD' =>	'Queensland',
					'AU-SA' =>	'South Australia'
				)
			),
			'AT' => array(
				'label' => 'Austria',
				'state' => array(
					'AT-8' =>	'Vorarlberg',
					'AT-9' =>	'Wien',
					'AT-4' =>	'Oberösterreich',
					'AT-5' =>	'Salzburg',
					'AT-6' =>	'Steiermark',
					'AT-7' =>	'Tirol',
					'AT-1' =>	'Burgenland',
					'AT-2' =>	'Kärnten',
					'AT-3' =>	'Niederösterreich'
				)
			),
			'IN' => array(
				'label' => 'India',
				'state' => array(
					'IN-BR' =>	'Bihar',
					'IN-PY' =>	'Puducherry',
					'IN-DD' =>	'Daman and Diu',
					'IN-DN' =>	'Dadra and Nagar Haveli',
					'IN-DL' =>	'Delhi',
					'IN-NL' =>	'Nagaland',
					'IN-WB' =>	'West Bengal',
					'IN-HR' =>	'Haryana',
					'IN-HP' =>	'Himachal Pradesh',
					'IN-AS' =>	'Assam',
					'IN-UT' =>	'Uttaranchal',
					'IN-JH' =>	'Jharkhand',
					'IN-JK' =>	'Jammu and Kashmir',
					'IN-UP' =>	'Uttar Pradesh',
					'IN-SK' =>	'Sikkim',
					'IN-MZ' =>	'Mizoram',
					'IN-CT' =>	'Chhattisgarh',
					'IN-CH' =>	'Chandigarh',
					'IN-GA' =>	'Goa',
					'IN-GJ' =>	'Gujarat',
					'IN-RJ' =>	'Rajasthan',
					'IN-MP' =>	'Madhya Pradesh',
					'IN-OR' =>	'Orissa',
					'IN-TN' =>	'Tamil Nadu',
					'IN-AN' =>	'Andaman and Nicobar',
					'IN-AP' =>	'Andhra Pradesh',
					'IN-TR' =>	'Tripura',
					'IN-AR' =>	'Arunachal Pradesh',
					'IN-KA' =>	'Karnataka',
					'IN-PB' =>	'Punjab',
					'IN-ML' =>	'Meghalaya',
					'IN-MN' =>	'Manipur',
					'IN-MH' =>	'Maharashtra',
					'IN-KL' =>	'Kerala'
				)
			)
		
		);

		return apply_filters( 'wcfma_country_state_list', $wcfma_country_state_list );
	}
}

if(!function_exists('get_wcfma_country_list')) {
	function get_wcfma_country_list() {
		$wcfma_country_state_list = get_wcfma_country_state_list();
		$wcfma_country_list = array( 'world' => __( 'World', 'wc-frontend-manager-analytics' ) );
		
		if( !empty( $wcfma_country_state_list ) ) {
			foreach( $wcfma_country_state_list as $country_code => $country_data ) {
				if( isset( $country_data['label'] ) && !empty( $country_data['label'] ) ) {
					if( isset( $country_data['state'] ) && !empty( $country_data['state'] ) ) {
						$wcfma_country_list[$country_code] = __( $country_data['label'], 'wc-frontend-manager-analytics' );
					}
				}
			}
		}
		return apply_filters( 'wcfma_country_list', $wcfma_country_list );
	}
}

if(!function_exists('get_wcfma_state_list_country')) {
	function get_wcfma_state_list_country( $country = '' ) {
		$wcfma_country_state_list = get_wcfma_country_state_list();
		$wcfma_state_list = array();
		if( !$country ) return $wcfma_state_list;
		
		if( !empty( $wcfma_country_state_list ) ) {
			foreach( $wcfma_country_state_list as $country_code => $country_data ) {
				if( $country_code == $country ) {
					if( isset( $country_data['state'] ) && !empty( $country_data['state'] ) ) {
						$wcfma_state_list = $country_data['state'];
					}
				}
			}
		}
		return apply_filters( 'wcfma_state_list', $wcfma_state_list, $country );
	}
}

if(!function_exists('get_wcfma_map_name_list_country')) {
	function get_wcfma_map_name_list_country() {
	  return apply_filters( 'get_wcfma_map_name_list', array(
	  																											 'us' => 'us_aea',
	  																											 'uk' => 'uk_countries_mill',
	  																											 'ca' => 'ca_lcc'
																													)
																													);
	}
}
?>