function calculateAspectRatioFit(srcWidth, srcHeight, maxWidth, maxHeight) {
    var ratio = [maxWidth / srcWidth, maxHeight / srcHeight];
    ratio = Math.min(ratio[0], ratio[1]);
    var width = srcWidth*ratio;
    var height = srcHeight*ratio;
    jQuery(".CmSchPicture").css({width: width, height: height});
}

var scrollFix = function(e){
    if(e.keyCode == 38 || e.keyCode == 40 || e.type == 'mousewheel'){
        return false;
    }
    jQuery(this).scrollTop(position);

};
jQuery(document).ready(function(jQuery) {


     //Product Prices block (Webservices AJAX updated)
    var ProdListBlocks;
    var WsPpNum;
    function WebServiceListBlocks(){
        ProdListBlocks = [];
        WsPpNum=0;
        jQuery('body .rightBlock, body .CmListPrTab_c').each(function(){
            if(typeof jQuery(this).data('artnum')!== 'undefined' && typeof jQuery(this).data('brand')!== 'undefined'){
                if(jQuery(this).data('artnum')!='' && jQuery(this).data('brand')!=''){
                    ProdListBlocks.push(this);
                }
            }
        });
        return ProdListBlocks;
    }
    WebServiceListBlocks();

    if(ProdListBlocks.length>0){
        WsNextProdPrices();
    }
    
    function WsNextProdPrices(){
        var ePrlb = ProdListBlocks[WsPpNum];
        if(ePrlb){
            jQuery(ePrlb).find('.CmWsLoadBar').show();
            var Dir = jQuery(ePrlb).data('dir');
            var ArtNum = jQuery(ePrlb).data('artnum');
            var Brand = jQuery(ePrlb).data('brand');
            // console.log(Dir+'/ '+ArtNum+'/ '+Brand);
//            var pData = 'CarModAjaxProductPrices=Y&SearchWS=Y&ArtNum='+ArtNum+'&Brand='+Brand+'&Sets=List';
//            ReqFetch('/'+Dir+'/', pData)
//                .then(result => {
//                    jQuery(ePrlb).html(result);
//                    WsPpNum++;
//                    WsNextProdPrices();
//                });
            jQuery.ajax({url:'/'+Dir+'/', type:'POST', dataType:'html', data:{CarModAjaxProductPrices:'Y', SearchWS:'Y', ArtNum:ArtNum, Brand:Brand, Sets:'List'}})
               .done(function(Result){
                    //Check for WS Errors for admin
                    var aResult = Result.split('|CmWsErrors|');
                    if(aResult.length>1){
                        jQuery('.fxCont').html(aResult[1]).css('text-align','left');
                        jQuery('.fxOverlay').css('display', 'flex');
                    }else{
                        //Update Prices block
//                        console.log(Result);
                        jQuery(ePrlb).html(Result);
                        WsPpNum++;
                        WsNextProdPrices(); //Next search (if block exists)
                    }
                }).fail(function (jqXHR, textStatus, errorThrown) {
                    jQuery(ePrlb).html(jqXHR.responseText+' ['+textStatus+'] '+errorThrown);
                    WsPpNum++;
                    WsNextProdPrices();
                });
        }
    }

    
        // FILTERS
    jQuery("#CmAjaxBox").on("click",'.CmFilterCheck', function () {
        jQuery(this).find('.check_b').toggleClass('check_back');
        LoadingToggle('CmContent', jQuery('#CmAjaxBox').offset().top-20);
        var oData = {};
        oData['CarModAjax']='Y';
        var prid = jQuery(this).data('prid');
        var crcod = jQuery(this).data('crcod');
        var bcode = jQuery(this).data('bcode');
        if(prid){
            oData['ByProductID']=prid;
        }else if(crcod){
            oData['ByCriteriaCode']=crcod;
        }else if(bcode){
            oData['ByBrandCode']=bcode;
        }
		jQuery('.CmTumButn').each(function(){
			if(jQuery(this).hasClass('CmTumPushed')){
				oData['Only']=jQuery(this).data('tumb');
			}
        });
		jQuery.post(window.location.href, oData, function(Result){
            jQuery("#CmAjaxBox").html(Result);
            if(jQuery(window).width() <= 992) {
                jQuery('.left_fil').css('right', '315px');
            }
            LoadingToggle();
            WebServiceListBlocks();
            WsNextProdPrices();
        });
    });


    //OE, Analog switch
    jQuery('#CmAjaxBox').on('click', '.CmTumButn', function(e){
		if(!jQuery(this).hasClass('CmTumPushed')){
			e.preventDefault();
			jQuery('.CmTumButn').each(function(){
				jQuery(this).removeClass('CmTumPushed');
			});
			jQuery(this).addClass('CmTumPushed');
			var titPosHrf = jQuery(this).attr('href');
			LoadingToggle('CmContent', jQuery('#CmAjaxBox').offset().top-20);
			jQuery.ajax({url:titPosHrf, type:'POST', dataType:'html', data:{CarModAjax:'Y'}})
				.done(function(Result){
					jQuery("#CmAjaxBox").html(Result);
					if(jQuery(window).width() <= 992) {
						jQuery('.left_fil').css('right', '315px');
					}
					LoadingToggle();
					WebServiceListBlocks();
					WsNextProdPrices();
				});
		}
    });

    // Select Products SubSection
    jQuery("#CmAjaxBox").on("click",".PickSection", function(e){
        LoadingToggle('CmContent',1);
        window.history.pushState('object or string', 'Title', jQuery(this).attr('href'));
        e.preventDefault();
        var Code = jQuery(this).data('code');
        var pickHeight = jQuery(this).height();
        jQuery(this).parents('.cm_FsBlock').find('.FilterSection').css('border-top-width') == pickHeight / 2;
        jQuery(this).parents('.cm_FsBlock').find('.FilterSection').css('border-bottom-width') == pickHeight / 2;
        jQuery.post(window.location.href, {CarModAjax:'Y', PickSection:Code}, function(Result){
            jQuery("#CmAjaxBox").html(Result);
            if(jQuery(window).width() <= 992) {
                jQuery('.left_fil').css('right', '315px');
            }
            LoadingToggle('CmContent',1);
            WebServiceListBlocks();
            WsNextProdPrices();
        });
    });
    jQuery("#CmAjaxBox").on("click",".PickSection span", function(e){
        e.stopPropagation();
            e.preventDefault();
        jQuery(this).toggleClass("DownActive");
        jQuery(this).parent().parent().next().slideToggle(400);
    });

    // SORT BY PRODUCT_LIST
    jQuery("#CmAjaxBox ").on("click", ".sort_bl", function(e){
        e.stopPropagation();
        jQuery('.hide_bl').toggleClass('hiBlbor');
        jQuery('.show_bl').toggleClass('shBlbor');
        jQuery('.hide_bl').toggle();
    });
    jQuery("#CmAjaxBox ").on("click", ".sort_list", function(e){
        e.stopPropagation();
        jQuery('.hide_bl').toggleClass('hiBlbor');
        jQuery('.show_bl').toggleClass('shBlbor');
        jQuery('.hide_bl').hide();
        LoadingToggle('CmContent', jQuery('#CmAjaxBox').offset().top-20);
        jQuery.post(window.location.href, {CarModAjax:'Y', SortBy:jQuery(this).data('sort') }, function(Result){
            jQuery("#CmAjaxBox").html(Result);
            LoadingToggle('CmContent');
            WebServiceListBlocks();
            WsNextProdPrices();
        });
    });
    jQuery("#CmAjaxBox").on("mouseleave", ".hide_bl", function (){
        jQuery(this).hide();
    });
    jQuery('.CmSortBlockClose').on('click',function (e){
        jQuery(".hide_bl").hide();
    });


    // VIEW SWITCH PRODUCT_LIST
    jQuery("#CmAjaxBox").on("click",".cm_viewAct", function(e){
        var uri = jQuery(this).data('urix');
        LoadingToggle('CmContent', jQuery('#CmAjaxBox').offset().top-20);
        var view = jQuery(this).data('view');
        if(view && view!=''){
            jQuery.post(uri, {CarModAjax:'Y', ActivateTab:view}, function(Result){
                jQuery("#CmAjaxBox").html(Result);
                LoadingToggle();
                WebServiceListBlocks();
                WsNextProdPrices();
            });
        }
    });

    // SELECT SETUP SIDE
    // front, rear
    jQuery('#CmAjaxBox').on('click', '.CmSelectCarSide', function(e){
        e.preventDefault();
        jQuery('.CmFrRr').each(function(){
            jQuery(this).find('.CmCarSide').css('fill','#909090');
            jQuery(this).find('.CmCarSideTxt').css('color','#909090');
            jQuery(this).removeClass('CmSelSideTogg');
            jQuery(this).addClass('CmSelectCarSide');
        });
        jQuery(this).find('.CmCarSide').css('fill','#f93a3a');
        jQuery(this).find('.CmCarSideTxt').css('color','#f93a3a');
        jQuery(this).removeClass('CmSelectCarSide');
        jQuery(this).addClass('CmSelSideTogg');
        var titPosHrf = jQuery(this).attr('href');
        LoadingToggle('CmContent', jQuery('#CmAjaxBox').offset().top-20);
        jQuery.ajax({url:titPosHrf, type:'POST', dataType:'html', data:{CarModAjax:'Y'}})
            .done(function(Result){
                jQuery("#CmAjaxBox").html(Result);
                if(jQuery(window).width() <= 992) {
                    jQuery('.left_fil').css('right', '315px');
                }
                LoadingToggle();
                WebServiceListBlocks();
                WsNextProdPrices();
            });
    });
    //left, right
    jQuery('#CmAjaxBox').on('click', '.CmSelectBVSide', function(e){
        e.preventDefault();
        jQuery('.CmLfRt').each(function(){
            jQuery(this).find('.CmBackView').css('fill','#909090');
            jQuery(this).find('.CmBVTxt').css('color','#909090');
            jQuery(this).removeClass('CmSelBVTogg');
            jQuery(this).addClass('CmSelectBVSide');
        });
        jQuery(this).find('.CmBackView').css('fill','#f93a3a');
        jQuery(this).find('.CmBVTxt').css('color','#f93a3a');
        jQuery(this).removeClass('CmSelectBVSide');
        jQuery(this).addClass('CmSelBVTogg');
        var titPosHrf = jQuery(this).attr('href');
        LoadingToggle('CmContent', jQuery('#CmAjaxBox').offset().top-20);
        jQuery.ajax({url:titPosHrf, type:'POST', dataType:'html', data:{CarModAjax:'Y'}})
            .done(function(Result){
                jQuery("#CmAjaxBox").html(Result);
                LoadingToggle();
                WebServiceListBlocks();
                WsNextProdPrices();
            });
    });


    /* Admin Tips for Publick side */
    jQuery("#CmContent").on("mouseover", ".CmTitShow", function(){
        var title = jQuery(this).attr('title');
        if(title){
            jQuery(this).data('tipText', title).removeAttr('title');
            jQuery('<p class="CmTipBox"></p>').html(title).appendTo('body').show(); //alert('+'+title);
        }else{return false;}
    });
    jQuery("#CmContent").on("mouseleave", ".CmTitShow", function(){
        jQuery(this).attr('title', jQuery(this).data('tipText'));
        jQuery('.CmTipBox').remove();
    });
    jQuery("#CmContent").on("mousemove", ".CmTitShow", function(e){
        var mousex = e.pageX + 16; //Get X coordinates
        var mousey = e.pageY + 7; //Get Y coordinates
        jQuery('.CmTipBox').css({ top:mousey, left:mousex });
    });


    /* ====== SCHEMES ==== =============================================== */
    /* show more toggle */
    function ShemeHover() {
        let elBox;
        jQuery(".CmSchemaBox").hover(function(){
            elBox = jQuery(this),
            curHeight = elBox.height(),
            autoHeight = elBox.css('height', 'auto').height();
            elBox.height(curHeight).stop(true, true).animate({height: autoHeight}, 200, "linear");
        },function(){
            elBox.animate({height: '82px'}, 200, "linear");
        })   
    }
    const schCount = jQuery('.CmSchemaBox').data('schcount');
    if(schCount > 5){
        ShemeHover();
        jQuery(document).ajaxComplete(function () {
            ShemeHover();
        });
    }

    jQuery("body").on("click", '.CmSchema', function (e){
        var SchPicID = jQuery(this).data('picid'),
        Lng = jQuery(this).data('lng');
        jQuery(this).find('.CmSchLoadWrap').show().css('display','flex');
        jQuery.ajax({url:window.location.href, type:'POST', dataType:'html', data:{SchPicID:SchPicID, Lng:Lng}})
        .done(function(Result){
            jQuery('.fxOverlay').css('display', 'flex');
            jQuery('.CmLoadWrap').css('display', 'flex');
            jQuery('.fxCont').height(window.innerHeight-100);
            jQuery('.fxCont').width(1180);
            jQuery('.fxCont').html('<div class="fxClose"></div>'+Result);
            jQuery('.CmLoadWrap').css('display', 'flex');
            var maxWidth = jQuery('.CmSchemeBlockWrap').width(),
            maxHeight = jQuery('.CmSchemeBlockWrap').height(),
            srcHeight = jQuery('.CmSchemeGridWrap').data('height'),
            srcWidth = jQuery('.CmSchemeGridWrap').data('width');
            calculateAspectRatioFit(srcWidth, srcHeight, maxWidth, maxHeight);
            jQuery('.CmLoadWrap').hide();
            jQuery('.CmSchLoadWrap').hide();
        });
    });
     //MORE PRICES
    jQuery("#CmAjaxBox, .blockProdPrice").on('click', '.CmMorePrices', function(){
        jQuery(this).find('.morePricestab').slideDown(200);
    });

    //CLOSE MORE PRICE
    jQuery('#CmAjaxBox, .blockProdPrice').on('click','.CmMorePriceBlClose', function(e){
        e.stopPropagation();
        jQuery('.morePricestab').slideUp(200);
        jQuery('.CmMoreHidePr').show();
    });
    jQuery(document).mousedown(function (e){ // событие клика по веб-документу
        var div = jQuery(".morePricestab"); // тут указываем ID элемента
        if (!div.is(e.target) && div.has(e.target).length === 0) {
            jQuery('.morePricestab').slideUp(200);
        }
    });

    //SHOW MORE PRICE IN HIDE BLOCK
    jQuery("#CmAjaxBox, .blockProdPrice").on('click', '.CmMoreHidePr', function(){
        jQuery('.CmWrapBlMorePrice ').removeClass('CmWrapBlHeight');
        jQuery(this).hide();
    });

   // PRICE QUANTITY
    jQuery("#CmAjaxBox, .blockProdPrice").on("click", ".cm_countButM", function () {
        min_quant = jQuery(this).siblings('.cm_countRes').data('minimalqnt');
        var input = jQuery(this).parent().find('.cm_countRes');
        if(min_quant){
            var count= parseInt(input.val()) - min_quant;
            count = count <= 0 ? min_quant : count;
        }else{
            var count= parseInt(input.val()) - 1;
        }
        count = count <= 0 ? 1 : count;
        input.val(count);
        input.change();
        return false;
    });
    jQuery("#CmAjaxBox, .blockProdPrice").on("click", ".cm_countButP", function () {
        var min_quant = jQuery(this).siblings('.cm_countRes').data('minimalqnt');
        var maxaval = jQuery(this).parent().find('.cm_countRes').data('maxaval');
        var input = jQuery(this).parent().find('.cm_countRes');
        if(min_quant){
            var count= parseInt(input.val()) + min_quant;
        }else{
            var count= parseInt(input.val()) + 1;
        }
        count = count > maxaval ? maxaval : count;
        input.val(count);
        input.change();
        return false;
    });
    jQuery("#CmAjaxBox, .blockProdPrice").on("keyup", '.cm_countRes', function () {
        checkSymb(this);
    });
    function checkSymb(input){
        var value = input.value;
        var maxav = jQuery(input).data('maxaval');
        var rep = /[-\.;":'a-zA-Zа-яА-Я]/;
        if (rep.test(value)){
            value = value.replace(rep, '');
            input.value = value;
        }
        if(value>maxav){
            value = value.replace(value, maxav);
            input.value = value;
        }
        if(value==0){
            value = 1;
            input.value = value;
        }
        return value;
    }

    // SLIDER FILTER
    const brandCount = document.querySelector('.CmBrandFiltWrap');
    if (brandCount !== null) {
        function BrandFilterSl () {
            let position = 0;
            const slidesToShow = 8;
            const slidesToScroll = 1;
            const container = document.querySelector('.CmBrFiltCont');
            const track = document.querySelector('.CmBrandSlTrack');
            const btnPrev = document.querySelector('.CmBrSlPrev');
            const btnNext = document.querySelector('.CmBrSlNext');
            const items = document.querySelectorAll('.CmBrandSlideCheck');
            const itemCount = items.length;
            const itemWidth = container.clientWidth / slidesToShow + 16;
            const movePosition = slidesToScroll * itemWidth

            items.forEach((item) => {
                item.style.minWidth = `${itemWidth - 15}px`;
            });

            btnNext.addEventListener('click', () => {
                const itemLeft = itemCount - (Math.abs(position) + slidesToShow * itemWidth) / itemWidth;
                position -= itemLeft >= slidesToScroll ? movePosition : itemLeft * itemWidth;
                SetPosition();
                CheckBtns();
            });
            btnPrev.addEventListener('click', () => {
                const itemLeft = Math.abs(position) / itemWidth;
                position += itemLeft >= slidesToScroll ? movePosition : itemLeft * itemWidth;
                SetPosition();
                CheckBtns();
            });
        
            const SetPosition = () => {
                track.style.transform = `translateX(${position}px)`;
            };
        
            const CheckBtns = () => {
                btnPrev.disabled = position === 0;
                btnNext.disabled = position <= - (itemCount - slidesToShow) * itemWidth;
            };

            // let slider = document.querySelector('.CmBrandFiltWrap'),
            // sliderList = slider.querySelector('.CmBrFiltCont'),
            // sliderTrack = slider.querySelector('.CmBrandSlTrack'),
            // slides = slider.querySelectorAll('.CmBrandSlideCheck'),
            // btnPrev = document.querySelector('.CmBrSlPrev'),
            // btnNext = document.querySelector('.CmBrSlNext'),
            // // prev = arrows.children[0],
            // // next = arrows.children[1],
            // slideWidth = slides[0].offsetWidth,
            // slideIndex = 0,
            // posInit = 0,
            // posX1 = 0,
            // posX2 = 0,
            // posY1 = 0,
            // posY2 = 0,
            // posFinal = 0,
            // isSwipe = false,
            // isScroll = false,
            // allowSwipe = true,
            // transition = true,
            // nextTrf = 0,
            // prevTrf = 0,
            // lastTrf = --slides.length * slideWidth,
            // posThreshold = slides[0].offsetWidth * 0.35,
            // trfRegExp = /([-0-9.]+(?=px))/,
            // swipeStartTime,
            // swipeEndTime,
            // getEvent = function() {
            //     return (event.type.search('touch') !== -1) ? event.touches[0] : event;
            // },
            // slide = function() {
            //     if (transition) {
            //     sliderTrack.style.transition = 'transform .5s';
            //     }
            //     sliderTrack.style.transform = `translate3d(-${slideIndex * slideWidth}px, 0px, 0px)`;

            //     btnPrev.classList.toggle('disabled', slideIndex === 0);
            //     btnNext.classList.toggle('disabled', slideIndex === --slides.length);
            // },
            // swipeStart = function() {
            //     let evt = getEvent();

            //     if (allowSwipe) {

            //     swipeStartTime = Date.now();
                
            //     transition = true;

            //     nextTrf = (slideIndex + 1) * -slideWidth;
            //     prevTrf = (slideIndex - 1) * -slideWidth;

            //     posInit = posX1 = evt.clientX;
            //     posY1 = evt.clientY;

            //     sliderTrack.style.transition = '';

            //     document.addEventListener('touchmove', swipeAction);
            //     document.addEventListener('mousemove', swipeAction);
            //     document.addEventListener('touchend', swipeEnd);
            //     document.addEventListener('mouseup', swipeEnd);

            //     sliderList.classList.remove('grab');
            //     sliderList.classList.add('grabbing');
            //     }
            // },
            // swipeAction = function() {

            //     let evt = getEvent(),
            //     style = sliderTrack.style.transform,
            //     transform = +style.match(trfRegExp)[0];

            //     posX2 = posX1 - evt.clientX;
            //     posX1 = evt.clientX;

            //     posY2 = posY1 - evt.clientY;
            //     posY1 = evt.clientY;

            //     if (!isSwipe && !isScroll) {
            //     let posY = Math.abs(posY2);
            //     if (posY > 7 || posX2 === 0) {
            //         isScroll = true;
            //         allowSwipe = false;
            //     } else if (posY < 7) {
            //         isSwipe = true;
            //     }
            //     }

            //     if (isSwipe) {
            //     if (slideIndex === 0) {
            //         if (posInit < posX1) {
            //         setTransform(transform, 0);
            //         return;
            //         } else {
            //         allowSwipe = true;
            //         }
            //     }

            //     // запрет ухода вправо на последнем слайде
            //     if (slideIndex === --slides.length) {
            //         if (posInit > posX1) {
            //         setTransform(transform, lastTrf);
            //         return;
            //         } else {
            //         allowSwipe = true;
            //         }
            //     }

            //     if (posInit > posX1 && transform < nextTrf || posInit < posX1 && transform > prevTrf) {
            //         reachEdge();
            //         return;
            //     }

            //     sliderTrack.style.transform = `translate3d(${transform - posX2}px, 0px, 0px)`;
            //     }

            // },
            // swipeEnd = function() {
            //     posFinal = posInit - posX1;

            //     isScroll = false;
            //     isSwipe = false;

            //     document.removeEventListener('touchmove', swipeAction);
            //     document.removeEventListener('mousemove', swipeAction);
            //     document.removeEventListener('touchend', swipeEnd);
            //     document.removeEventListener('mouseup', swipeEnd);

            //     sliderList.classList.add('grab');
            //     sliderList.classList.remove('grabbing');

            //     if (allowSwipe) {
            //     swipeEndTime = Date.now();
            //     if (Math.abs(posFinal) > posThreshold || swipeEndTime - swipeStartTime < 300) {
            //         if (posInit < posX1) {
            //         slideIndex--;
            //         } else if (posInit > posX1) {
            //         slideIndex++;
            //         }
            //     }

            //     if (posInit !== posX1) {
            //         allowSwipe = false;
            //         slide();
            //     } else {
            //         allowSwipe = true;
            //     }

            //     } else {
            //     allowSwipe = true;
            //     }

            // },
            // setTransform = function(transform, comapreTransform) {
            //     if (transform >= comapreTransform) {
            //     if (transform > comapreTransform) {
            //         sliderTrack.style.transform = `translate3d(${comapreTransform}px, 0px, 0px)`;
            //     }
            //     }
            //     allowSwipe = false;
            // },
            // reachEdge = function() {
            //     transition = false;
            //     swipeEnd();
            //     allowSwipe = true;
            // };

            // sliderTrack.style.transform = 'translate3d(0px, 0px, 0px)';
            // sliderList.classList.add('grab');

            // sliderTrack.addEventListener('transitionend', () => allowSwipe = true);
            // slider.addEventListener('touchstart', swipeStart);
            // slider.addEventListener('mousedown', swipeStart);

            // btnPrev.addEventListener('click', function() {
            //     slideIndex--;
            //     slide();
            // });
            // btnNext.addEventListener('click', function() {
            //     slideIndex++;
            //     slide();
            // });

            // let viewport = document.querySelector(".CmBrFiltCont").offsetWidth;
            // // console.log(viewport);
            // let btnNext = document.querySelector(".CmBrSlNext");
            // let btnPrev = document.querySelector(".CmBrSlPrev");
            // let slider = document.querySelector("div.CmBrandSlTrack");
            // const brandCount = document.querySelector('.CmBrandFiltWrap').dataset.brcount / 7;
            // const slidesToShow = 7;
            // const container = document.querySelector('.CmBrFiltCont');
            // const items = document.querySelectorAll('.CmBrandSlideCheck');
            // const itemWidth = container.clientWidth / slidesToShow + 15;
            // console.log(brandCount);
            // let viewSlide = 0;

            // items.forEach((item) => {
            // 	item.style.minWidth = `${itemWidth}px`;
            // });

            // btnNext.addEventListener("click", function () {
            //     if (viewSlide < brandCount) {
            //         viewSlide++;
            //     } else {
            //         viewSlide = 0;
            //     }
            //     slider.style.left = - viewSlide * viewport / brandCount - 15 + "px";

            // });

            // btnPrev.addEventListener("click", function () {
            //     if (viewSlide > 0) {
            //         viewSlide--;
            //     } else {
            //         viewSlide = brandCount;
            //     }
            //     slider.style.left = - viewSlide * viewport + "px";
            // });

        }

        BrandFilterSl ();

        jQuery(document).ajaxComplete(function () {
            BrandFilterSl ();
        });
        // END SLIDER


        
        jQuery("#CmAjaxBox").on("click",'.CmBrandSlideCheck', function () {
            let elem = jQuery(this);
            LoadingToggle('CmContent', jQuery('#CmAjaxBox').offset().top-20);
            var oData = {};
            oData['CarModAjax']='Y';
            var bcode = jQuery(this).data('bcode');
            if(bcode){
                oData['ByBrandCode']=bcode;
            }
            jQuery.post(window.location.href, oData, function(Result){
                jQuery("#CmAjaxBox").html(Result);
                elem.toggleClass('CmActive');
                LoadingToggle();
                WebServiceListBlocks();
                WsNextProdPrices();
            });
        });
    }
});

// Modal window close
    var doc = jQuery(document);
    jQuery(document).mousedown(function (e){ // событие клика по веб-документу
        var div = jQuery(".fxCont"); // тут указываем ID элемента
        if (!div.is(e.target) // если клик был не по нашему блоку
        && div.has(e.target).length === 0) { // и не по его дочерним элементам
            jQuery('.fxOverlay').hide(); // скрываем его
            jQuery('.fxCont').html('').css({width:'unset', height:'unset'});
            doc.unbind('scroll keydown mousewheel', scrollFix);
        }
    });
    jQuery('body').on('click', '.fxClose', function(){
        jQuery('.fxOverlay').hide();
        jQuery('.fxCont').html('');//.css({width:'unset', height:'unset'});
        doc.unbind('scroll keydown mousewheel', scrollFix);
    });

// LOADING overlay
function LoadingToggle(IdContentBox, ScrollPx){
    IdContentBox=IdContentBox||'CmContent';
    ScrollPx=ScrollPx||0;
    if(jQuery("#Loading").css('display') !== 'none'){
        jQuery("#Loading").hide();
    }else{
        var Cont = jQuery("#"+IdContentBox);
        var CTop = Cont.position().top;
        if(ScrollPx==-1){ScrollPx=CTop;}
        var CLeft = Cont.position().left; //alert('Top:'+CTop+'; Left:'+CLeft); // .offset()
        if(ScrollPx>0){
            jQuery('html, body').animate({ scrollTop:ScrollPx }, 500);
        }
        var CWidth = Cont.outerWidth();
        if(!jQuery.isNumeric(CWidth)){CWidth = Cont.width() + (parseInt(Cont.css('padding-left')) + parseInt(Cont.css('padding-right')) );}
        var CHeight = Cont.outerHeight();
        if(!jQuery.isNumeric(CHeight)){CHeight = Cont.height() + (parseInt(Cont.css('padding-top')) + parseInt(Cont.css('padding-bottom')) );}
        if(IdContentBox!='CmContent'){ //Для элементов внитри контента CarMod
            var PadT = parseInt(jQuery("#CmContent").css('padding-top'));
            var PadR = parseInt(jQuery("#CmContent").css('padding-right'));
            var PadB = parseInt(jQuery("#CmContent").css('padding-bottom'));
            var PadL = parseInt( jQuery("#CmContent").css('padding-left'));
            jQuery("#Loading").css({top:CTop-PadT, left:CLeft-PadL});
            jQuery("#Loading").width(CWidth+PadL+PadR).height(CHeight+PadT+PadB).show();
        }else{ // Для #CmContent

            jQuery("#Loading").width(CWidth).height(CHeight).show();
        }
    }
}

// SHOW & HIDE MORE NOT HIDE PRICE
jQuery('body').on('click', '.CmShowMorePrice', function(){
    jQuery(this).prev('.CmTablePriceWrap').find('.CmTablePriceValueRow_2').show();
    var hide = jQuery(this).data('hide');
    jQuery(this).html(hide).addClass('CmHideMorePrice').removeClass('CmShowMorePrice');
});
jQuery('body').on('click', '.CmHideMorePrice', function(){
    jQuery(this).prev('.CmTablePriceWrap').find('.CmTablePriceValueRow_2').hide();
    var show = jQuery(this).data('show');
    jQuery(this).html(show).addClass('CmShowMorePrice').removeClass('CmHideMorePrice');

});


// SHOW MORE OE NUMBERS
 jQuery('body').on('click', '.CmShowHidOeNum', function(){
    jQuery('.CmHiddenOeNum').each(function(){
        jQuery(this).hide().parents('.CmOeNumsTd').find('.CmHideOeNum').hide();
        jQuery(this).parents('.CmOeNumsTd').find('.CmShowHidOeNum').show();
    });
    jQuery(this).hide();
    jQuery(this).siblings('.CmOeNumWrap').find('.CmHiddenOeNum').show();
    jQuery(this).siblings('.CmHideOeNum').show().css('align-self','flex-end');
    if((jQuery(this).parent().siblings('.CmOeBrName').data('check')=='Y' && jQuery(this).siblings('.CmOeNumWrap').find('.CmHiddenOeNum').length>2) || jQuery(this).siblings('.CmOeNumWrap').find('.CmHiddenOeNum').length>6){
        jQuery('.CmOeBlockInside').removeClass('CmOeNumHeightToHide');
        jQuery('.CmHideOe').show();
        jQuery('.CmShowOe').hide();
    }
});
jQuery('body').on('click', '.CmHideOeNum', function(){
    jQuery(this).siblings('.CmOeNumWrap').find('.CmHiddenOeNum').hide();
    jQuery(this).hide();
    jQuery(this).siblings('.CmShowHidOeNum').show();
});

//REDIRECT FROM PRODUCT_LIST
jQuery('body').on('click','.CmLookAnalogHook',function(){
    jQuery('.tabOeNum').addClass('activeSecTab CmColorBr CmColorBg');
    jQuery('.tabPartUse').removeClass('activeSecTab CmColorBr CmColorBg');
    jQuery('.centBlockInfo').addClass('CmAddClassFlex');
    jQuery('.cmSuitBlock').hide();
    jQuery('.tabOeNum').find('.cmSvgImg').css('fill','#ffffff');
    jQuery('.tabPartUse').find('.cmSvgImg').css('fill','#808080');
});

// TABS ON PRODUCT PAGE
jQuery(document).ready(function( jQuery ) {

    const urlPage = jQuery('.wrapBlTabsMenu').data('url'),
    cmDir = jQuery('.CmModelSuitBlock').data('cmdir'),
    aCarModels = new Array();
     //Open brand models function
    function OpenBrandModels(fxPlace='') {
        jQuery('body '+fxPlace).on('click', '.CmLogoBrandImg', function(){
            jQuery('.CmModifListBlock').html('');
            jQuery('.CmSelectModelTxt, .CmSelectModTitl').show();
            const brName = jQuery(this).data('brname');
            const hasClick = jQuery(this).attr("clicked");
            jQuery(fxPlace+' .CmSelectBrandTxt').hide();
            if (hasClick === "N") {
                jQuery(fxPlace+' .CmModelModif').html('');
                jQuery.each(aCarModels[brName], function(key, val) {
                    jQuery(fxPlace+' .CmModelModif').append(`<div class="CmModeItem CmColorBgLh" data-code="${key}" clicked="N">${val}</div>`);
                });   
            }
            jQuery(fxPlace+' .CmLogoBrandImg').each(function(){
                jQuery(this).attr("clicked", "N").removeClass('CmBordForAct CmColorBr CmColorBgL CmColorOu');
            });
            jQuery(this).attr("clicked", "Y").addClass('CmBordForAct CmColorBr CmColorBgL CmColorOu');
        });
    }

    //Get models request
    function AjaxModelRequest(urlP, fxPlace='', modDir=''){
        jQuery.ajax({url:urlP, type:'POST', dataType:'html', data:{GetModels:'Y'}})
        .done(function(Res){
            aResJson = JSON.parse(Res);
            if(aResJson!==null){
                if(aResJson[0]!=='None'){
                    jQuery(fxPlace+' .CmModBlockInner').show().css('display','flex');
                    jQuery.each(aResJson, function(key, val) {
                        aCarModels[key] = val['MODELS'];
                        jQuery(fxPlace+' .CmBrandNameBl').append(`<div class="CmLogoBrandImg CmTitShow" style="background-image:url(/${modDir}/media/brands/${val['CODE']}.png)" data-brname="${key}" clicked="N" title="${key}"></div>`);
                    });
                    const modCount = Object.keys(aCarModels).length;
                    if(modCount == 1){
                        OpenBrandModels();
                        AjaxModifRequest(urlPage);
                        jQuery('.CmLogoBrandImg').addClass('CmBordForAct CmColorBr CmColorBgL CmColorOu').trigger('click');
                        jQuery('.CmModeItem:first-child').trigger('click');
                    }
                }else{
                    jQuery(fxPlace+' .CmNotFoundInfo').css('display','flex');
                }
            }else{
                jQuery(fxPlace+' .CmNotFoundInfo').css('display','flex');
            }
            jQuery(fxPlace+' .CmModelWaitLoad').hide();
        });
    }

    //Request model after load page
    if(jQuery('.wrapBlTabsMenu').data('avail')==='N'){
        AjaxModelRequest(urlPage, '', cmDir);
        //Open brand models function call
        OpenBrandModels();
        jQuery('.tabPartUse').attr("clicked", "Y");
        //Open model modify
        AjaxModifRequest(urlPage);
    }

    //Get modifications
    function AjaxModifRequest(urlP, fxPlace='') {
        jQuery('body '+fxPlace).on('click','.CmModeItem',function(){
            jQuery(fxPlace+' .CmSelectModelTxt').hide();
            var modCode = jQuery(this).data('code');
            jQuery(fxPlace+' .CmModeItem').each(function(){
                jQuery(this).removeClass('CmColorBgL');
            });
            jQuery(this).addClass('CmColorBgL');
            const hasClick = jQuery(this).attr("clicked");
            if (hasClick === "N") {
                jQuery(fxPlace+' .CmSelectModTitl').hide();
                jQuery(fxPlace+' .CmModifListOverf').css({alignItems:'center'});
                jQuery(fxPlace+' .CmModifListBlock').html('');
                jQuery(fxPlace+' .CmModifListBlock').append('<div class="CmSmLoading"><div class="CmColorBg"></div><div class="CmColorBg"></div><div class="CmColorBg"></div><div class="CmColorBg"></div></div>');
                jQuery.ajax({url:urlP, type:'POST', dataType:'html', data:{GetVhApp:modCode}})
                    .done(function(Res){
                    const aJRes = JSON.parse(Res);
                    jQuery.each(aJRes, function(key, val) {
                        jQuery(fxPlace+' .CmModifListOverf').css({alignItems:'flex-start'});
                        jQuery(fxPlace+' .CmModifListBlock').append(`<div class="CmTypesList CmColorBgLh">${val}</div>`).css('width', '100%');
                    });
                    jQuery(fxPlace+' .CmSmLoading').css('display','none');
                });
            }
            jQuery(fxPlace+' .CmModeItem').each(function(){
                jQuery(this).attr("clicked", "N");
            });
            jQuery(this).attr("clicked", "Y");
        });
    }

    jQuery('body').on('click', '.tabPartUse', function(){
        let hasClick = jQuery(this).attr("clicked"),
        cmDir = jQuery('.CmModelSuitBlock').data('cmdir');
        if(hasClick === "N"){
            jQuery('.cmBlockInfo').append('<div class="CmModelWaitLoad"><div class="CmColorBg"></div><div class="CmColorBg"></div><div class="CmColorBg"></div><div class="CmColorBg"></div></div>');
            AjaxModelRequest(urlPage, '', cmDir);
        }
        jQuery('.tabPartUse').attr("clicked", "Y");

        //Open brand models function call
        OpenBrandModels();

        //Open model modify
        AjaxModifRequest(urlPage);
    });
    
    
    jQuery('body').on('click', '.CmtabSelBut', function(){
        jQuery('.CmtabSelBut').removeClass('activeSecTab c_boxShad CmColorTx');
        jQuery('.CmtabSelBut').find('.cmSvgImg').removeClass('CmColorFi');
        jQuery(this).addClass('activeSecTab CmColorTx');
        jQuery(this).find('.cmSvgImg').addClass('CmColorFi');
        if(jQuery(this).data('change')==='OeNum'){
            jQuery(this).addClass('CmTabShadRight');
        }else if(jQuery(this).data('change')==='Suite'){
            jQuery(this).addClass('CmTabShadLeft');
        }
        if(jQuery(this).data('change')==='OeNum'){
           jQuery('.centBlockInfo').css({height: 'auto', opacity: 1});
            jQuery('.cmSuitBlock').css({height: 0, opacity: 0});
        }
        if(jQuery(this).data('change')==='Suite'){
            jQuery('.centBlockInfo').css({height: 0, opacity: 0});
            jQuery('.cmSuitBlock').css({height: 'auto', opacity: 1});
        }
        if(jQuery(this).data('change')==='ProdInfo'){
            jQuery('.centBlockInfo').css({height: 0, opacity: 0});
            jQuery('.cmSuitBlock').css({height: 0, opacity: 0});
        }
    });

    //Request from view_list
    jQuery("#CmAjaxBox").on("click", '.ProductInfoOe', function (e){
        e.preventDefault();
        var thisEl = jQuery(this);
        var furl = jQuery(this).data('furl');
        jQuery('.fxOverlay').css('display', 'flex');
        jQuery('.fxCont').html('<div class="CmSchLoadWrap" style="display:flex; top:0; left:0;"><div class="CmSchLoading"><div class="CmColorBg"></div><div class="CmColorBg"></div><div class="CmColorBg"></div><div class="CmColorBg"></div><div class="CmColorBg"></div><div class="CmColorBg"></div><div class="CmColorBg"></div><div class="CmColorBg"></div><div class="CmColorBg"></div><div class="CmColorBg"></div><div class="CmColorBg"></div><div class="CmColorBg"></div></div></div>');
        jQuery.ajax({url:furl, type:'POST', dataType:'html', data:{ProdPrice:'Y', CarModAjaxOENumbers:'Y', IncludeFuncs:'Yes', ArtNum:jQuery(this).parent().data('artnum'), Brand:jQuery(this).parent().data('brand'), Tab:jQuery(this).data('tab'), HideStat:'Y', OENumbers:'Y'}})
            .done(function(Result){
                jQuery('.fxCont').html('<div class="fxClose"></div>'+Result);
                jQuery('.fxCont .centBlockInfo').css({height: 'auto', opacity: 1});
                jQuery('.fxCont .cmSuitBlock').css({height: 0, opacity: 0});
            });
        });
    jQuery("#CmAjaxBox").on("click", '.ProductInfoSuit', function (e){
        e.preventDefault();
        let thisEl = jQuery(this);
        const furl = jQuery(this).data('furl'),
        cmDir = jQuery(this).data('moduledir');
        jQuery('.fxOverlay').css('display', 'flex');
        jQuery('.fxCont').html('<div class="CmSchLoadWrap" style="display:flex; top:0; left:0;"><div class="CmSchLoading"><div class="CmColorBg"></div><div class="CmColorBg"></div><div class="CmColorBg"></div><div class="CmColorBg"></div><div class="CmColorBg"></div><div class="CmColorBg"></div><div class="CmColorBg"></div><div class="CmColorBg"></div><div class="CmColorBg"></div><div class="CmColorBg"></div><div class="CmColorBg"></div><div class="CmColorBg"></div></div></div>');
        jQuery.ajax({url:furl, type:'POST', dataType:'html', data:{ProdPrice:'Y', CarModAjaxSuitVehicle:'Y', IncludeFuncs:'Yes', ArtNum:jQuery(this).parent().data('artnum'), Brand:jQuery(this).parent().data('brand'), Tab:jQuery(this).data('tab'), HideStat:'Y', ProdVehicle:'Y'}})
            .done(function(Result){
                jQuery('.fxCont').html('<div class="fxClose"></div>'+Result);
                AjaxModelRequest(furl, '.fxCont', cmDir);
                OpenBrandModels('.fxCont');
                AjaxModifRequest(furl, '.fxCont');
            });
        });
    //APPLIED TO MODEL
    //More brand models
    // jQuery('body').on('click', '.CmBrandNameBl', function(){
    //     jQuery('.CmSelectModelTxt').show();
    //     var bn = jQuery(this).data('brandname');
    //     jQuery('.CmBrandNameBl').each(function(){
    //         jQuery(this).removeClass('');
    //     });
    //     jQuery(this).addClass('CmColorBr CmColorBgL CmBordForAct CmColorOu');
    //     jQuery('.CmModelList').hide();
    //     jQuery('.CmTypesList').hide();
    //     jQuery('.CmModelList').each(function(){
    //         var mc = jQuery(this).data('modname');
    //         if(bn == mc){
    //             jQuery(this).show();
    //         }
    //     });
    //     jQuery('.CmSelectModTitl').show();
    // });
    // jQuery('.CmBrandNameBl:first-child').click();

    


    //MORE ANALOGS
    jQuery('body').on('click','.CmShowA',function(){
       jQuery('.CmAnalogBlockInside').removeClass('CmBlockHeightToHIde');
       jQuery('.CmHideA').show();
       jQuery('.CmHideTextBlock').hide();
       jQuery(this).hide();
    });
    jQuery('body').on('click','.CmHideA',function(){
        jQuery('.CmAnalogBlockInside').addClass('CmBlockHeightToHIde');
        jQuery('.CmShowA, .CmHideTextBlock').show();
        jQuery(this).hide();

    });

    //MORE VEHICLES
    jQuery('body').on('click','.CmShowV',function(){
       jQuery('.CmVehicBlockWrap').removeClass('CmVehicleHeightBl');
       jQuery('.CmHideV').show();
       jQuery('.CmHideTextVehicBlock').hide();
       jQuery(this).hide();
    });
    jQuery('body').on('click','.CmHideV',function(){
        jQuery('.CmVehicBlockWrap').addClass('CmVehicleHeightBl');
        jQuery('.CmShowV, .CmHideTextVehicBlock').show();
        jQuery(this).hide();
        jQuery(window).scrollTop(300);
    });

    //MORE OE NUMBERS
    jQuery('body').on('click','.CmShowOe',function(){
       jQuery('.CmOeBlockInside').removeClass('CmOeNumHeightToHide');
       jQuery('.CmHideOe').show();
       jQuery(this).hide();
    });
    jQuery('body').on('click','.CmHideOe',function(){
        jQuery('.CmOeBlockInside').addClass('CmOeNumHeightToHide');
        jQuery('.CmShowOe, .CmShowHidOeNum').show();
        jQuery('.CmHiddenOeNum, .CmHideOeNum').hide();
        jQuery(this).hide();
        jQuery(window).scrollTop(500);
    });
    
    //Hover on price block
    jQuery('body').on('mouseenter', '.CmPriceProd', function(){
        var hintTxtA = jQuery(this).data('txta');
        var hintTxtD = jQuery(this).data('txtd');
        var hintBlockA = '<div class="CmShowHintBl CmAvalHintBl">'+hintTxtA+'</div>';
        var hintBlockD = '<div class="CmShowHintBl CmDelivHintBl">'+hintTxtD+'</div>';
        jQuery(this).find('.avalTd').append(hintBlockA);
        jQuery(this).find('.delivTd').append(hintBlockD);
        setTimeout(() => 
        jQuery('.CmShowHintBl').addClass('CmShowHintPopup'),
        jQuery('.CmAvalImgTextPage').css('border-radius', '0px 0px 0px 3px'),
        jQuery('.delivTd ').css('border-radius', '0px 0px 3px 0px'));
    });
    jQuery('body').on('mouseleave', '.CmPriceProd', function(){
        setTimeout(() => jQuery(this).find('.CmShowHintBl').removeClass('CmShowHintPopup'));
        setTimeout(() => jQuery(this).find('.CmShowHintBl').remove(), 200);
        jQuery('.CmAvalImgTextPage').css('border-radius', '3px 0px 0px 3px');
        jQuery('.delivTd ').css('border-radius', '0px 3px 3px 0px');
    });
    
});

// Fetch request
async function ReqFetch(url, data) {
    try{
        const response = await fetch(url, {
            method: 'POST',
            body: data,
            headers: new Headers({
                'Content-Type': 'application/x-www-form-urlencoded'
            })
        });
        const resData = await response.text();
        return resData;
    } catch(error){
        console.log(error);
    }
    // return fetch(url, {
        // method: 'POST',
        // body: data,
        // headers: new Headers({
        //     'Content-Type': 'application/x-www-form-urlencoded'
        // })
    // })
    // .then(response => response.text()) // возвращаем промис
}

//ASK PRICE AND MAIL ORDER POPUP BLOCK
function ToCartMailOrder(elem, addFolder, e){
    var Brand = jQuery(elem).data('brand'),
    Article = jQuery(elem).data('artnum'),
    ModuleDir = jQuery(elem).data('moduledir'),
    DataLang = jQuery(elem).data('lang'),
    Link = jQuery(elem).data('link');
    pData = 'Brand='+Brand+'&Article='+Article+'&Lang='+DataLang+'&ModDir='+ModuleDir+'&Link='+Link;
    e.preventDefault();
    jQuery('.fxOverlay').css('display', 'flex');
    jQuery('.fxCont').html('<div id="tempSaver"></div><div class="CmSchLoadWrap" style="display:flex; margin:auto;"><div class="CmSchLoading"><div class="CmColorBg"></div><div class="CmColorBg"></div><div class="CmColorBg"></div><div class="CmColorBg"></div><div class="CmColorBg"></div><div class="CmColorBg"></div><div class="CmColorBg"></div><div class="CmColorBg"></div><div class="CmColorBg"></div><div class="CmColorBg"></div><div class="CmColorBg"></div><div class="CmColorBg"></div></div></div>');

    ReqFetch('/'+ModuleDir+'/add/'+addFolder+'/controller.php', pData)
        .then(result => jQuery('.fxCont').html('<div class="fxClose"></div>'+result));

    // DON'T DELETE

    // jQuery.post('/'+ModuleDir+'/add/'+addFolder+'/controller.php', {Brand:Brand, Article:Article, Lang:DataLang, ModDir:ModuleDir, Link:Link}, function(Result){
    //     jQuery('.fxCont').find('#tempSaver').html(Result);
    //     setTimeout(() => {
    //         jQuery('.fxCont').html('<div class="fxClose"></div>'+Result);
    //     }, 300);
    //     jQuery('.fxCont').find('#tempSaver').html('');
    // });
}
jQuery(document).ready(function(jQuery) {
    jQuery("#CmAjaxBox, .CmPriceProd, .blockProdPrice").on("click", '.ListAskPrice', function (e){
        var elem = jQuery(this);
        ToCartMailOrder(elem, 'askprice', e);
    });
    jQuery("#CmAjaxBox, .CmPriceProd").on("click", '.CmMailOrder', function (e){
        var elem = jQuery(this);
        ToCartMailOrder(elem, 'mail_order', e);
    });
});


    