<?if(!isset($aPrices)){die('Restricted: WS');} //Direct include protection
/* 
-> INCOMING variables:
$aWs - incoming Webservice Settings array
$ArtNum - incoming Article for search
$AKey - incoming Article (short view) for search
$Brand - incoming Brand for search (will not be determined if the search by Article, because on that step Brand is not selected)
$LangCode - Website selected Language code ("en","ru","ro"..) 
$GetCross - 1/0 

<- OUTGOING, required:
$aPrices - Prices array with fields: ArtNum, Brand, Name, Price, Currency, Available, Delivery, Stock, Options array()
(Required fields: Price, ArtNum, Brand)
*/ 

if(extension_loaded('soap')){
	class EmxCustomer{
        public $UserName;
        public $Password;
        public $SubCustomerId;
        public $CustomerId;
    }
	$EmxCustomer = new EmxCustomer();
    $EmxCustomer->UserName = $aWs['LOGIN'];
    $EmxCustomer->Password = $aWs['PASSW'];
	$EmxCustomer->SubCustomerId = 0;
	$EmxCustomer->CustomerId = 0;
	$SClient = new SoapClient("http://emexonline.com:3000/MaximaWS/service.wsdl", array('encoding'=>'utf-8','connection_timeout'=>120));
	if($aWs['GET_CROSSES']){$ShowSubsts=true;}else{$ShowSubsts=false;}
	
	try{
		$oCRes = $SClient->SearchPart(array("Customer"=>$EmxCustomer,"DetailNum"=>$ArtNum,"ShowSubsts"=>$ShowSubsts));
		//$oCRes = $SClient->SearchPartEx(array("Customer"=>$EmxCustomer,"DetailNum"=>$ArtNum,"MakeLogo"=>$Brand,"ShowSubsts"=>$ShowSubsts,"PriceLogo"=>'',"DestinationLogo"=>''));
	}catch(Exception $e){
		echo $e->getMessage();
	}

	$aCRes = $oCRes->SearchPartResult->FindByNumber;
	if(isset($aCRes) AND is_array($aCRes)){
		foreach($aCRes as $o){
			if($o->PercentSupped>0){$Chance_delivery=intval($o->PercentSupped);}
			if($o->WeightGr>0){$Weight_gr=intval($o->WeightGr);}
			$aPrices[] = Array(
				'ArtNum' => (string)$o->DetailNum,
				'Brand' => (string)$o->MakeName,
				'Name' => Array('ru'=>(string)$o->PartNameRus, 'en'=>(string)$o->PartNameEng),
				'Price' => floatval($o->Price),
				'Available' => intval($o->Available),
				'Stock' => (string)$o->PriceLogo,
				'Delivery' => intval($o->Delivery),
				//'Currency' => $a['Currency'],
				'Options' => Array(
					'Weight_gr' => $Weight_gr,
					'Chance_delivery' => $Chance_delivery
				)
			);
		}
		$WithCrosses=true; // В ответе могут быть кроссы
	}

}else{echo 'PHP extension "Soap" is not loaded';}

//echo "<pre>"; print_r($aPrices); echo "</pre>"; die();

/*
Documentation:
https://emexdwc.ae/Instructions.aspx?page=web_services

Result array sample: 
stdClass Object
(
    [SearchPartResult] => stdClass Object
        (
            [FindByNumber] => Array
                (
                    [0] => stdClass Object
                        (
                            [Available] => -1
                            [bitOldNum] => 
                            [PercentSupped] => 78
                            [PriceId] => 854
                            [Region] => 
                            [Delivery] => 18
                            [Make] => .И
                            [DetailNum] => OC90
                            [PriceLogo] => ATRA
                            [Price] => 5.13
                            [PartNameRus] => ФИЛЬТР МАСЛЯНЫЙ
                            [PartNameEng] => OIL FILTER
                            [WeightGr] => 324
                            [MakeName] => Mahle / Knecht
                            [Packing] => 1
                            [bitECO] => 
                            [bitWeightMeasured] => 1
                            [VolumeAdd] => 0
                            [GuaranteedDay] => 30
                        )
		...
		
*/
?>