<?if(!isset($aPrices)){die('Restricted: WS');} //Direct include protection
/* 
-> INCOMING variables:
$aWs - incoming Webservice Settings array
$ArtNum - incoming Article for search
$AKey - incoming Article (short view) for search
$Brand - incoming Brand for search (will not be determined if the search by Article, because on that step Brand is not selected)
$LangCode - Website selected Language code ("en","ru","ro"..) 
$GetCross - 1/0 

<- OUTGOING, required:
$aPrices - Prices array with fields: ArtNum, Brand, Name, Price, Currency, Available, Delivery, Stock, Options array()
(Required fields: Price, ArtNum, Brand)
*/ 

if(extension_loaded('curl')){
	if($Brand!=''){
		$Brand = BrandAlias_TehnoMir($Brand);
		$BrandID = IdByBrand($Brand);
		if($BrandID<=0){
			echo 'Brand ID not found: <b>'.$Brand.'</b> '.$ArtNum.'<br>';
			return;
		} //Не запрашивать, так как Бренд не найден
	}

	$URL = "https://tehnomir.com.ua/ws/xml.php?act=GetPriceWithCrosses&usr_login=".$aWs['LOGIN']."&usr_passwd=".$aWs['PASSW']."&PartNumber=".$ArtNum."&Currency=".$aWs['CURRENCY'];
	//$URL = "http://tehnomir.com.ua/ws/xml.php?act=GetSuppliers&usr_login=".$aWs['LOGIN']."&usr_passwd=".$aWs['PASSW']; // Запрос стран складов
	if($BrandID>0){$URL.="&BrandId=".$BrandID;}
	$URL = str_replace(' ','%20',$URL);
	$ch = curl_init($URL);
	curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($ch, CURLOPT_FOLLOWLOCATION, true);
    curl_setopt($ch, CURLOPT_AUTOREFERER, true);
	
	$Res = curl_exec($ch); curl_close($ch);
/* 	Запрос стран складов
	if($xRes = @simplexml_load_string($Res)){
		$jRes = json_encode($xRes);
		$aWsRes = json_decode($jRes,TRUE);
	}
	foreach($aWsRes['Suppliers']['Supplier'] as $aSup){
		echo "'".$aSup['Code']."' => '".$aSup['Region']."',<br>";
	} */
	if($Res!=''){
		if($xRes = @simplexml_load_string($Res)){
			$jRes = json_encode($xRes);
			$aWsRes = json_decode($jRes,TRUE);
			
			//echo "<pre>"; print_r($aWsRes); echo "</pre>"; //die();
			/* foreach($aWsRes['Producers']['Producer'] as $a){
				echo "		'".SingleKey_x($a['Name'])."' => ".$a['Id'].",
	";
			}
			die(); */
			
			$aWsPrices = Array();
			if(isset($aWsRes['Prices']['Price'])){
				$aWsPrices = $aWsRes['Prices']['Price']; 
				if(isset($aWsPrices['PartId'])){
					$aTmp = $aWsPrices; $aWsPrices = Array();
					$aWsPrices[] = $aTmp; //Если в ответе только одна запись
				}
			}
			//echo "<pre>"; print_r($aWsPrices); echo "</pre>"; //die();
			
			if(count($aWsPrices)>0){
				foreach($aWsPrices as $a){
					if($a['DamagedFlag']=='Y'){$Damaged=1;}else{$Damaged=0;}
					if($a['UsedFlag']=='Y'){$Used=1;}else{$Used=0;}
					if($a['OriginalFlag']=='Y'){$Original=1;}else{$Original=0;}
					if($a['RestoredFlag']=='Y'){$Restored=1;}else{$Restored=0;}
					if($a['ReturnFlag']!='Y'){$Return=1;}else{$Return=0;}
					if($a['Quantity']>99){$a['Quantity']='99+';}
					$aPrices[] = Array(
						'ArtNum' => $a['PartNumber'],
						'Brand' => BrandAlias_TehnoMir($a['Brand'],true), //for Search by Article only
						'Name' => Array('ru'=>$a['PartDescriptionRus']),
						'Price' => $a['Price'],
						'Available' => $a['Quantity'],
						'Stock' => CountrySTOCK_TehnoMir($a['PriceLogo']),
						'Delivery' => $a['DeliveryDays'],
						'Currency' => $a['Currency'],
						'Options' => Array(
							'Weight_kg' => round($a['Weight'],2),
							'Damaged' => $Damaged,
							'Used' => $Used,
							'Restored' => $Restored,
							'No_return' => $Return,
							'Chance_delivery' => intval($a['DeliveryPercent']),
						)
					);
				}
				$WithCrosses=true; // В ответе могут быть кроссы
			}
			
		}else{
			echo '<a href="'.$URL.'" target="_blank">Test link</a><br>';
			echo strip_tags(trim($Res),'<br><p><address><hr>');
		}
	}else{
		echo '<a href="'.$URL.'" target="_blank">Test link</a><br>';
		echo 'Empty response';
	}
}else{echo 'PHP extension "curl" is not loaded';}

//echo "<pre>"; print_r($aPrices); echo "</pre>"; die();

/*
Documentation:
https://tehnomir.com.ua/ws/

Result array sample: 
[Prices] => Array(
	[Price] => Array(
		[0] => Array(
			[PartId] => 31960930
			[BrandId] => 101
			[Brand] => FEBI
			[PartNumber] => 28194
			[PartNumberShort] => 28194
			[PartDescriptionRus] => Смазочные материалы
			[Price] => 1281.9
			[Currency] => UAH
			[Quantity] => 3
			[QuantityType] => EQUAL
			[PriceLogo] => OMKH
			[Weight] => 5.6
			[PriceDescrShort] => Array()
			[PriceDescrLong] => Array()
			[DeliveryType] => LOCAL
			[DeliveryDays] => 2
			[DeliveryDate] => 2019-04-09 13:00:00
			[DeliveryPercent] => 85.4451
			[PriceChangeDate] => 2019-04-06 11:16:15
			[DamagedFlag] => N
			[UsedFlag] => N
			[OriginalFlag] => Y
			[OldPartNumberFlag] => N
			[ReturnFlag] => Y
			[PriceFinalFlag] => Y
			[Group] => 0
			[GroupDescr] => Array()
			)
		...
		
*/

function BrandAlias_TehnoMir($Brand,$Back=false){
	$aWsB = Array(
	//	"CATALOG" => "TEHNOMIR",
		"HC-Cargo" => "CARGO",
		"FEBI BILSTEIN" => "FEBI",
		"ST-TEMPLIN" => "TEMPLIN",
		"4Cars" => "4CAR",
		"DT Spare Parts" => "DIESELTECHNIK",
		"DIESELTECHNIC" => "DIESELTECHNIK",
		"KLAXCAR FRANCE" => "KLAXCAR",
		"MAHLE ORIGINAL" => "MAHLE",
		"KYB" => "KAYABA",
		"TOPRAN" => "HANSPRIES",
		"Tecneco Filters" => "TECNECO",
	);
	foreach($aWsB as $From=>$To){
		if($Back){if($Brand==$To){$Brand = $From; break;}}else{if($Brand==$From){$Brand = $To; break;}}
	}
	return $Brand;
}

function CountrySTOCK_TehnoMir($Stock_x){
	$aSTOCK = Array(
		'STOK' => 'Украина',
		'STOR' => 'Украина',
		'AEWC' => 'ОАЭ',
		'AESF' => 'ОАЭ',
		'XZOL' => 'ОАЭ',
		'AEJF' => 'Япония',
		'CGXL' => 'Япония',
		'XIDI' => 'ОАЭ',
		'AENF' => 'Япония',
		'RRPL' => 'Япония',
		'AERF' => 'ОАЭ',
		'AERC' => 'ОАЭ',
		'AEIS' => 'ОАЭ',
		'DIEN' => 'ОАЭ',
		'AEIT' => 'ОАЭ',
		'OPDV' => 'ОАЭ',
		'NBOT' => 'ОАЭ',
		'UZIZ' => 'ОАЭ',
		'AEST' => 'ОАЭ',
		'JFZP' => 'ОАЭ',
		'PXUI' => 'ОАЭ',
		'RKBV' => 'Южная Корея',
		'QSNU' => 'ОАЭ',
		'XHEH' => 'ОАЭ',
		'KDRO' => 'ОАЭ',
		'DICG' => 'ОАЭ',
		'WCTP' => 'США',
		'MZEQ' => 'США',
		'ZQTR' => 'США',
		'CHGB' => 'США',
		'UYTO' => 'США',
		'UKNY' => 'США',
		'BSIM' => 'США',
		'ITJD' => 'США',
		'WKNJ' => 'США',
		'AHCI' => 'США',
		'ZEPQ' => 'США',
		'NVMA' => 'США',
		'WJPC' => 'США',
		'LYUN' => 'США',
		'KPFU' => 'США',
		'LRBI' => 'США',
		'GSZE' => 'США',
		'OIMJ' => 'США',
		'PRXH' => 'США',
		'VJOZ' => 'США',
		'OSWQ' => 'США',
		'ZUIB' => 'США',
		'WSGE' => 'США',
		'IKVR' => 'США',
		'PNJS' => 'США',
		'ADUB' => 'США',
		'ZETW' => 'США',
		'SRUW' => 'США',
		'DEJY' => 'США',
		'RCIX' => 'США',
		'SFVN' => 'США',
		'JERT' => 'США',
		'YOXO' => 'США',
		'LTAZ' => 'США',
		'KJHG' => 'США',
		'SYHP' => 'США',
		'MQXP' => 'США',
		'WXDM' => 'США',
		'PAXD' => 'США',
		'GBUJ' => 'США',
		'XHUU' => 'США',
		'BFSW' => 'США',
		'WWHY' => 'США',
		'PYHZ' => 'США',
		'MIPT' => 'США',
		'WOPX' => 'США',
		'TNQN' => 'США',
		'JSXV' => 'США',
		'ODWA' => 'США',
		'WYPX' => 'США',
		'XDEC' => 'США',
		'TNRZ' => 'США',
		'YELN' => 'США',
		'USAM' => 'США',
		'YQNL' => 'США',
		'YXRD' => 'США',
		'IPIH' => 'США',
		'ZYLJ' => 'США',
		'IIVL' => 'США',
		'TQNS' => 'США',
		'SJWO' => 'США',
		'ATUK' => 'Украина',
		'ATOD' => 'Украина',
		'FEBS' => 'Украина',
		'FEBK' => 'Украина',
		'FEBO' => 'Украина',
		'KILO' => 'Украина',
		'LASA' => 'Украина',
		'HUND' => 'Украина',
		'METR' => 'Украина',
		'KLOD' => 'Украина',
		'LAND' => 'Украина',
		'LANS' => 'Украина',
		'DHGJ' => 'Россия',
		'EVRU' => 'Россия',
		'HWRU' => 'Россия',
		'SPOT' => 'Украина',
		'LIOD' => 'Украина',
		'LIUA' => 'Украина',
		'IUSS' => 'Украина',
		'AMNR' => 'Украина',
		'SPKI' => 'Украина',
		'SPKY' => 'Украина',
		'SPML' => 'Украина',
		'SPMM' => 'Германия',
		'SPMR' => 'Украина',
		'SPMS' => 'Украина',
		'SPMZ' => 'Array',
		'SPOD' => 'Украина',
		'SPVS' => 'Украина',
		'STFR' => 'Украина',
		'OBSP' => 'Украина',
		'ODPL' => 'Украина',
		'AGUU' => 'Украина',
		'AZPL' => 'Украина',
		'EZXF' => 'Польша',
		'KSVO' => 'Украина',
		'LRUQ' => 'Россия',
		'KRUN' => 'Украина',
		'LGVW' => 'Украина',
		'OMKY' => 'Украина',
		'OMKH' => 'Украина',
		'ALVG' => 'Украина',
		'SUBO' => 'Украина',
		'STOD' => 'Украина',
		'GMUS' => 'Украина',
		'BEKO' => 'Украина',
		'BEOD' => 'Украина',
		'TSOD' => 'Украина',
		'AGRN' => 'Украина',
		'SAUA' => 'Украина',
		'RALU' => 'Украина',
		'OMKI' => 'Украина',
		'AKUA' => 'Украина',
		'TWOD' => 'Украина',
		'JJLZ' => 'Россия',
		'LVPS' => 'Украина',
		'JPSV' => 'Украина',
		'KRXA' => 'Украина',
		'KRXB' => 'Украина',
		'XAOA' => 'Украина',
		'PDVD' => 'Украина',
		'CZCL' => 'Украина',
		'MMKA' => 'Украина',
		'VRAV' => 'Украина',
		'KGTL' => 'Украина',
		'ADKP' => 'Украина',
		'RKAA' => 'Украина',
		'IMSU' => 'Украина',
		'SCVO' => 'Украина',
		'SPKP' => 'Украина',
		'DNGA' => 'Украина',
		'MFHS' => 'Украина',
		'DNGB' => 'Украина',
		'BURJ' => 'Украина',
		'REPI' => 'Украина',
		'SPRH' => 'Украина',
		'KZFC' => 'Венгрия',
		'ODJD' => 'Украина',
		'PPOH' => 'Украина',
		'NAPL' => 'Польша',
		'PRHS' => 'Польша',
		'TXEO' => 'Украина',
		'PXLG' => 'Украина',
		'SLSK' => 'Украина',
		'DLCE' => 'Украина',
		'DLOD' => 'Украина',
		'ZTNK' => 'Украина',
		'EVDU' => 'Украина',
		'EVDY' => 'Украина',
		'AILJ' => 'Украина',
		'GROD' => 'Украина',
		'GRUK' => 'Украина',
		'SADS' => 'Украина',
		'SGVO' => 'Украина',
		'DGRK' => 'Украина',
		'SASH' => 'Украина',
		'DOCW' => 'Польша',
		'KNQV' => 'Польша',
		'RICF' => 'Польша',
		'RPAP' => 'Польша',
		'RPBR' => 'Польша',
		'RPFF' => 'Польша',
		'RPIT' => 'Польша',
		'RPMG' => 'Польша',
		'RPMP' => 'Польша',
		'RPNL' => 'Польша',
		'RPNT' => 'Польша',
		'RPZT' => 'Польша',
		'TDOD' => 'Польша',
		'YFOV' => 'Польша',
		'RPAD' => 'Польша',
		'AVNS' => 'Украина',
		'CFKH' => 'Украина',
		'TXDP' => 'Украина',
		'CQPZ' => 'Украина',
		'KNBR' => 'Украина',
		'NGVA' => 'Украина',
		'PZDV' => 'Украина',
		'TVIW' => 'Украина',
		'UKMS' => 'Украина',
		'BMIU' => 'Украина',
		'DRVD' => 'Украина',
		'FPPG' => 'Украина',
		'CRDK' => 'Украина',
		'GLSK' => 'Украина',
		'TJVS' => 'Украина',
		'AOTY' => 'Украина',
		'AOFO' => 'Украина',
		'AOLX' => 'Украина',
		'AOTA' => 'Украина',
		'VINK' => 'Украина',
		'ODKP' => 'Украина',
		'SIMD' => 'Украина',
		'PUDK' => 'Польша',
		'FOKS' => 'Украина',
		'HNDE' => 'Бельгия',
		'NAVY' => 'Украина',
		'GEDA' => 'Польша',
		'PRKH' => 'Польша',
		'CVRD' => 'Украина',
		'POVR' => 'Украина',
		'KAPK' => 'Украина',
		'SKAN' => 'Украина',
		'DNFB' => 'Украина',
		'AKPS' => 'Украина',
		'SGVD' => 'Украина',
		'PAVN' => 'Польша',
		'VRAN' => 'Украина',
		'HBIN' => 'Украина',
		'HBIU' => 'Украина',
		'PSPN' => 'Украина',
		'ADSN' => 'Украина',
		'KASN' => 'Украина',
		'KDPN' => 'Украина',
		'HRZS' => 'Украина',
		'ZTRN' => 'Украина',
		'YYRM' => 'Украина',
		'PNUN' => 'Украина',
		'KYXN' => 'ОАЭ',
		'ZAQG' => 'ОАЭ',
		'YQUB' => 'Украина',
		'ITRX' => 'Украина',
		'BJJK' => 'Украина',
		'GPGG' => 'Украина',
		'IZLK' => 'Украина',
		'AZYN' => 'США',
		'DEMR' => 'США',
		'EBFX' => 'США',
		'EWWH' => 'США',
		'GNUA' => 'США',
		'LCEF' => 'США',
		'RBPF' => 'США',
		'THOI' => 'США',
		'VAHD' => 'США',
		'ZBDH' => 'США',
		'ZCEJ' => 'США',
		'XGSM' => 'Украина',
		'CHTS' => 'Украина',
		'BVQH' => 'Украина',
		'MVGL' => 'Украина',
		'PRZW' => 'Украина',
		'PXPP' => 'Украина',
		'MUFN' => 'Украина',
		'SZLI' => 'Украина',
		'NHMR' => 'Украина',
		'GGJS' => 'Украина',
		'TASY' => 'Польша',
		'PTRP' => 'Польша',
		'REGU' => 'Польша',
		'FATV' => 'Польша',
		'HDAK' => 'Украина',
		'TITN' => 'Украина',
		'GNIB' => 'Украина',
		'EJOI' => 'Украина',
		'DRSS' => 'Украина',
		'HYVU' => 'Украина',
		'LLQX' => 'Украина',
		'SYZH' => 'Украина',
		'KOAD' => 'Польша',
		'WHMQ' => 'Польша',
		'WJJL' => 'Польша',
		'XJOK' => 'Польша',
		'YXIO' => 'Польша',
		'NPWX' => 'Россия',
		'OHQD' => 'Украина',
		'ZIUY' => 'Украина',
		'DRKC' => 'Украина',
		'GBKI' => 'Украина',
		'PJUA' => 'Украина',
		'SRSE' => 'Украина',
		'AJIA' => 'Южная Корея',
		'GRQG' => 'Южная Корея',
		'KCQY' => 'Южная Корея',
		'BPIX' => 'Украина',
		'ATNV' => 'Украина',
		'HDPR' => 'Украина',
		'CCVU' => 'Украина',
		'HGOG' => 'Украина',
		'ILOL' => 'Украина',
		'JCKF' => 'Украина',
		'XHCE' => 'ОАЭ',
		'NYCH' => 'ОАЭ',
		'APLZ' => 'ОАЭ',
		'ZTRR' => 'ОАЭ',
		'OJTS' => 'ОАЭ',
		'RNYE' => 'ОАЭ',
		'RXCF' => 'ОАЭ',
		'IGPI' => 'ОАЭ',
		'AZCA' => 'ОАЭ',
		'IOXA' => 'ОАЭ',
		'MLDD' => 'ОАЭ',
		'CCRU' => 'ОАЭ',
		'UXWS' => 'ОАЭ',
		'UEBK' => 'ОАЭ',
		'XHQP' => 'ОАЭ',
		'IPIB' => 'ОАЭ',
		'BBTX' => 'ОАЭ',
		'DXKB' => 'ОАЭ',
		'OKIH' => 'Украина',
		'GEYN' => 'ОАЭ',
		'XDWV' => 'Украина',
		'BXXC' => 'ОАЭ',
		'HGTG' => 'ОАЭ',
		'RDIE' => 'ОАЭ',
		'WWSB' => 'ОАЭ',
		'YCKT' => 'ОАЭ',
		'QVWG' => 'Украина',
		'ZWNH' => 'Германия',
		'NIIT' => 'Украина',
		'JYGP' => 'Украина',
		'XCLQ' => 'Украина',
		'XJGB' => 'Украина',
		'LNIY' => 'Украина',
		'CHBH' => 'Польша',
		'EBCV' => 'Германия',
		'MUXT' => 'Украина',
		'SYYG' => 'Польша',
		'CIJX' => 'Украина',
		'XKNA' => 'ОАЭ',
		'CVCV' => 'ОАЭ',
		'KPWE' => 'ОАЭ',
		'GZGU' => 'Украина',
		'SRUR' => 'Украина',
		'JJGM' => 'ОАЭ',
		'SZQN' => 'ОАЭ',
		'BCOC' => 'ОАЭ',
		'NCOG' => 'Украина',
		'WQAB' => 'Россия',
		'MXWV' => 'Украина',
		'HBOG' => 'Украина',
		'SDHV' => 'Украина',
		'XJTF' => 'ОАЭ',
		'REWZ' => 'Украина',
		'KEYE' => 'ОАЭ',
		'QZYV' => 'Япония',
		'YPCQ' => 'Япония',
		'DDSH' => 'Украина',
		'ODFD' => 'Украина',
		'VHXK' => 'Таиланд',
		'YPWE' => 'Южная Корея',
		'BALK' => 'Южная Корея',
		'LNKR' => 'Южная Корея',
		'QHWV' => 'Япония',
		'XNKW' => 'Украина',
		'IXNB' => 'Украина',
		'TBQD' => 'ОАЭ',
		'EDNL' => 'Украина',
		'WVTH' => 'Украина',
		'BZQS' => 'Россия',
		'FFOA' => 'Россия',
		'FJYK' => 'Россия',
		'KDLL' => 'Украина',
		'ODFQ' => 'Украина',
		'CSHN' => 'Южная Корея',
		'MAYB' => 'ОАЭ',
		'WRCI' => 'ОАЭ',
		'EISF' => 'ОАЭ',
		'DVER' => 'Украина',
		'YCVW' => 'Украина',
		'KNLE' => 'Украина',
		'UFAW' => 'Украина',
		'UTUF' => 'Украина',
		'EFDC' => 'Украина',
		'WKPW' => 'Тайвань',
		'BKWT' => 'ОАЭ',
		'YRWR' => 'ОАЭ',
		'USVF' => 'ОАЭ',
		'VWGZ' => 'Украина',
		'LOSJ' => 'Украина',
		'EWGF' => 'Украина',
		'ONGP' => 'Украина',
		'AHLR' => 'Украина',
		'FKLM' => 'Украина',
		'YGZT' => 'Украина',
		'ZBAK' => 'Украина',
		'RUNF' => 'Украина',
		'USEH' => 'Украина',
		'JSIS' => 'Польша',
		'ZVLU' => 'Польша',
		'SMDQ' => 'Украина',
		'ZMOU' => 'Оман',
		'CBCE' => 'Украина',
		'XFOR' => 'Япония',
		'WOYI' => 'ОАЭ',
		'YCYU' => 'ОАЭ',
		'VHPU' => 'Южная Корея',
		'UFDM' => 'Украина',
		'IRLW' => 'Украина',
		'JPSI' => 'Германия',
		'OCHK' => 'Германия',
		'VMGZ' => 'Германия',
		'YOVU' => 'Германия',
		'ZVBG' => 'Германия',
		'OKYH' => 'Украина',
		'JWGA' => 'ОАЭ',
		'HVXI' => 'Украина',
		'ZCLH' => 'Германия',
		'LYLG' => 'Украина',
		'KBSZ' => 'Украина',
		'AEHQ' => 'Украина',
		'SAJF' => 'ОАЭ',
		'CTAA' => 'Украина',
		'EOZS' => 'Германия',
		'KLHE' => 'Германия',
		'PSRD' => 'Германия',
		'RJBZ' => 'Германия',
		'SGFS' => 'Германия',
		'XATS' => 'Германия',
		'YOQD' => 'Германия',
		'LIKA' => 'Сингапур',
		'MJTI' => 'Сингапур',
		'CRQF' => 'Великобритания',
		'RBXM' => 'Украина',
		'LYWD' => 'Украина',
		'ABLL' => 'Германия',
		'CNUZ' => 'Германия',
		'CQMV' => 'Германия',
		'FVHD' => 'Германия',
		'GVKO' => 'Германия',
		'HQYP' => 'Германия',
		'KVXE' => 'Германия',
		'NGCP' => 'Германия',
		'PQBV' => 'Германия',
		'PTIV' => 'Германия',
		'QHEX' => 'Германия',
		'RUFI' => 'Германия',
		'SUQM' => 'Германия',
		'UBRE' => 'Германия',
		'WMLU' => 'Германия',
		'WPNO' => 'Германия',
		'XNKD' => 'Германия',
		'CIMP' => 'Украина',
		'TEYT' => 'Украина',
		'TWCO' => 'Украина',
		'QIRP' => 'ОАЭ',
		'FKPD' => 'Тайвань',
		'NGFG' => 'Япония',
		'LDZY' => 'Украина',
		'ARTO' => 'Германия',
		'DKRP' => 'Германия',
		'HYYE' => 'Германия',
		'KTSW' => 'Германия',
		'LRAR' => 'Германия',
		'WQRO' => 'Германия',
		'MVHO' => 'ОАЭ',
		'HCTW' => 'ОАЭ',
		'KQUJ' => 'Украина',
		'MAPK' => 'ОАЭ',
		'WPRA' => 'ОАЭ',
		'WEWE' => 'Украина',
		'AOIP' => 'Украина',
		'UGVA' => 'Украина',
		'WGIG' => 'Украина',
		'JFSW' => 'Украина',
		'GQSK' => 'Украина',
		'YXSM' => 'США',
		'YMWA' => 'Украина',
		'LUST' => 'Украина',
		'GLEY' => 'Япония',
		'JVHC' => 'Тайвань',
		'NAJU' => 'Турция',
		'VPKC' => 'Южная Корея',
		'XCGJ' => 'Южная Корея',
	);

	if(array_key_exists($Stock_x,$aSTOCK)){
		$StocRes = $Stock_x.' '.$aSTOCK[$Stock_x];
	}else{
		$StocRes = $Stock_x;
	}
	return $StocRes;
}

function IdByBrand($Brand){
	$BKey = SingleKey_x($Brand);
	$IdByBrand = Array(
		'SPIDAN' => 1,
		'HELLA' => 2,
		'ATE' => 3,
		'MANNFILTER' => 4,
		'PIERBURG' => 5,
		'LUK' => 6,
		'EBERSPACHER' => 7,
		'LEISTRITZ' => 8,
		'REINZ' => 9,
		'ELRING' => 10,
		'BERU' => 11,
		'PAGID' => 12,
		'WALKER' => 13,
		'BOGE' => 14,
		'NGK' => 15,
		'BILSTEIN' => 16,
		'HK' => 17,
		'KONI' => 18,
		'SWF' => 19,
		'LUCAS' => 20,
		'VALEO' => 21,
		'WABCO' => 22,
		'RUVILLE' => 23,
		'EXIDE' => 24,
		'HJS' => 25,
		'VARTA' => 26,
		'HOPPECKE' => 27,
		'OPTILUX' => 28,
		'ERNST' => 29,
		'BOSCH' => 30,
		'CONTITECH' => 31,
		'SACHS' => 32,
		'GATES' => 33,
		'KNECHT' => 34,
		'LEMFORDER' => 35,
		'VANWEZEL' => 36,
		'MONROE' => 37,
		'PURFLUX' => 38,
		'TEXTAR' => 39,
		'MAHLE' => 40,
		'BOSAL' => 41,
		'DAYCO' => 42,
		'CHAMPION' => 43,
		'PUROLATOR' => 44,
		'TEROSON' => 45,
		'SONNENSCHEIN' => 46,
		'BREMI' => 47,
		'JURID' => 48,
		'BENDIX' => 49,
		'SKF' => 50,
		'WESTFALIA' => 51,
		'BEHR' => 52,
		'ORIS' => 53,
		'FTE' => 54,
		'NIPPARTS' => 55,
		'LOEBRO' => 56,
		'QUINTONHAZELL' => 57,
		'EKG' => 58,
		'FRAM' => 59,
		'GOETZE' => 60,
		'CENTRO' => 61,
		'FERODO' => 62,
		'CHAMP' => 63,
		'OPTIBELT' => 64,
		'BREMBO' => 65,
		'DENSO' => 66,
		'OSRAM' => 67,
		'SCHMID' => 68,
		'TESH' => 69,
		'GERI' => 70,
		'GABRIEL' => 71,
		'HBAUTOELEKTRIK' => 72,
		'MINTEX' => 73,
		'LOCTITE' => 74,
		'PHILIPS' => 75,
		'PEX' => 76,
		'BORGBECK' => 77,
		'KLOKKERHOLM' => 78,
		'WAHLER' => 79,
		'DASIS' => 80,
		'HENGSTFILTER' => 81,
		'NOR' => 82,
		'SIEMENSVDO' => 83,
		'TTV' => 84,
		'KAYABA' => 85,
		'ZIMMERMANN' => 86,
		'FRIESEN' => 87,
		'GLASER' => 88,
		'DELPHI' => 89,
		'FARCOM' => 90,
		'TECNOCAR' => 91,
		'FIAAM' => 92,
		'SCHLIECKMANN' => 93,
		'METZGER' => 94,
		'MAGNETIMARELLI' => 95,
		'ALKO' => 96,
		'WAECO' => 97,
		'HOFMEISTERMEINCKE' => 98,
		'COPARTS' => 99,
		'ROULUNDS' => 100,
		'FEBI' => 101,
		'UBD' => 102,
		'NORMTECHNIK' => 103,
		'ZFLENKSYSTEME' => 104,
		'BEHRSERVICE' => 105,
		'AIRMATIC' => 106,
		'ISKRA' => 107,
		'TRISCAN' => 108,
		'BUGATTIAUTORICAMBI' => 109,
		'SNR' => 110,
		'KUHLERPAPE' => 111,
		'EIBACH' => 112,
		'PAYEN' => 113,
		'BUDWEGCALIPER' => 114,
		'ULO' => 115,
		'SEIMA' => 116,
		'LRT' => 117,
		'HJSLEISTRITZ' => 118,
		'DELCOREMY' => 119,
		'AURADIA' => 120,
		'METELLI' => 121,
		'OBERLANDMANGOLD' => 122,
		'NISSENS' => 123,
		'KACO' => 124,
		'DOYEN' => 125,
		'STABILUS' => 126,
		'NK' => 127,
		'BU' => 128,
		'OPTIMAL' => 129,
		'KF' => 130,
		'LNP' => 131,
		'DELPHIDIESEL' => 132,
		'MAPCO' => 133,
		'MOOG' => 134,
		'SIDEM' => 135,
		'DANA' => 136,
		'HANSA' => 137,
		'4SEASONS' => 138,
		'SANDEN' => 139,
		'VISTEON' => 140,
		'SERCKMARSTON' => 141,
		'NRF' => 142,
		'FRIGAIR' => 143,
		'EAIGROUP' => 144,
		'DOPPSTADT' => 145,
		'JOHNS' => 146,
		'AJUSA' => 147,
		'CORTECO' => 148,
		'AE' => 149,
		'SOFIMA' => 150,
		'BERGA' => 151,
		'MEYLE' => 152,
		'NWB' => 153,
		'AMCFILTERS' => 154,
		'KBP' => 155,
		'JWP' => 156,
		'BRINK' => 157,
		'GARRETT' => 158,
		'SCHWITZER' => 159,
		'IHI' => 160,
		'HOLSET' => 161,
		'KUNEWALDE' => 162,
		'DELTAAUTOTECHNIK' => 163,
		'GCK' => 164,
		'ROADHOUSE' => 165,
		'REMSA' => 166,
		'HARNISCHFEGER' => 167,
		'URW' => 168,
		'PBRSOGEFI' => 169,
		'NAMERICAPARTSDIST' => 170,
		'BCDCORONAC' => 171,
		'CLEANFILTER' => 172,
		'ALCOFILTERS' => 173,
		'WESSELSMULLER' => 174,
		'OMG' => 175,
		'IRISBUS' => 176,
		'MOTOMETER' => 177,
		'YUASA' => 178,
		'NAKATA' => 179,
		'ALKAR' => 180,
		'ALCOZYPERN' => 181,
		'BALDWIN' => 182,
		'COOPERS' => 183,
		'CROSLAND' => 184,
		'LAUTRETTE' => 185,
		'LUCASCAV' => 186,
		'POWERPART' => 187,
		'TEHO' => 188,
		'THERMOKING' => 189,
		'TJFILTERS' => 190,
		'WIX' => 191,
		'WOODGATE' => 192,
		'JAPANPARTS' => 193,
		'BUGIAD' => 194,
		'ICER' => 195,
		'HOLGERCRISTIANSEN' => 196,
		'CONTROL4' => 197,
		'FIFFT' => 198,
		'VAICO' => 199,
		'PRIMBALL' => 200,
		'MICRONAIR' => 201,
		'TWINTEC' => 202,
		'SLANZI' => 203,
		'VM' => 204,
		'WAUKESHA' => 205,
		'MOPARPARTS' => 206,
		'AIRTEX' => 207,
		'YALETOWNE' => 208,
		'MOTEURSBAUDOUINSA' => 209,
		'COMPAIR' => 210,
		'LOMBARDINI' => 211,
		'ZEUNASTARKER' => 212,
		'MULTIPART' => 213,
		'SAGINAW' => 214,
		'UNISIAJECS' => 215,
		'HOBOURNAUTOMOTIVE' => 216,
		'GLO' => 217,
		'HDK' => 218,
		'NKN' => 219,
		'AYATS' => 220,
		'AECHERLI' => 221,
		'MAYBACH' => 222,
		'PORSCHEDIESEL' => 223,
		'SAMRO' => 224,
		'HYMER' => 225,
		'IMT' => 226,
		'NORMAG' => 227,
		'BKS' => 228,
		'AKTIVFISCHER' => 229,
		'MEVOSA' => 230,
		'WOLGA' => 231,
		'ALFREDZIEGLER' => 232,
		'WEWELER' => 233,
		'WAHL' => 234,
		'VOGELE' => 235,
		'URSUS' => 236,
		'FARYMANNDIESEL' => 237,
		'PUTZMEISTER' => 238,
		'ALOISHIEBLECO' => 239,
		'HURTH' => 240,
		'KRAUSSMAFFEIAG' => 241,
		'KRIEGERFAHRZEUGBAU' => 242,
		'MAURI' => 243,
		'MOTMUNCHENSENDLING' => 244,
		'PAUS' => 245,
		'KILEN' => 246,
		'BAUER' => 247,
		'HEPU' => 248,
		'MANDO' => 249,
		'ALCOFILTER' => 250,
		'RAMEDER' => 251,
		'HP' => 252,
		'LESJOFORS' => 253,
		'FILTRON' => 254,
		'GK' => 255,
		'EDR' => 256,
		'ACERBI' => 257,
		'ACTM' => 258,
		'AUTODROMO' => 259,
		'BERTOLETTI' => 260,
		'BLUEBIRD' => 261,
		'BOLGAN' => 262,
		'CRANECARRIERCOMPANY' => 263,
		'DINA' => 264,
		'EOSCOACH' => 265,
		'FLXIBLECORPORATION' => 266,
		'FLOOR' => 267,
		'FORETRAVELMOTORHOME' => 268,
		'GENERALTRAILERS' => 269,
		'GIGANT' => 270,
		'GILLIG' => 271,
		'HENDRICKSON' => 272,
		'KAISER' => 273,
		'KRONE' => 274,
		'LANGENDORF' => 275,
		'LEGRASINDUSTRIES' => 276,
		'LEVEQUESREMORQUES' => 277,
		'MAGYAR' => 278,
		'MERITOR' => 279,
		'MIELE' => 280,
		'MISTRALL' => 281,
		'MCI' => 282,
		'NAVISTAR' => 283,
		'SCHMITZCARGOBULL' => 284,
		'NOVABUS' => 285,
		'RIDEWELLSUSPENSIONS' => 286,
		'ROLFO' => 287,
		'NEWAY' => 288,
		'VIBERTISPA' => 289,
		'STAS' => 290,
		'ZORZI' => 291,
		'TEREX' => 292,
		'CHEREAU' => 293,
		'ASHOKLEYLAND' => 294,
		'ASKAM' => 295,
		'BMC' => 296,
		'JELCZ' => 297,
		'MAZ' => 298,
		'GTEAFTERMARKET' => 299,
		'ERICHJAEGER' => 302,
		'MARWAL' => 303,
		'CVPSH' => 304,
		'SPAHNGLUHLAMPEN' => 305,
		'IWISKETTEN' => 306,
		'KICAUTOMOTIVE' => 307,
		'PETERSENNEPETAL' => 308,
		'HAVAMINTERPIECES' => 309,
		'DEUTZ' => 310,
		'SCHLUTTERTURBOLADER' => 311,
		'VEMO' => 312,
		'BPPOLSKASPZOO' => 313,
		'LOEFLERKUN' => 314,
		'MANNDATI' => 315,
		'AKEMI' => 316,
		'ALCAR' => 317,
		'GKN' => 318,
		'MONTBLANK' => 319,
		'OTTINGER' => 320,
		'SWF1' => 321,
		'LUCASKETNER' => 322,
		'VALEOAUTOG' => 323,
		'VARTADATI' => 324,
		'DYBBROE' => 325,
		'BOSCH1' => 326,
		'GATESKETNER' => 327,
		'PENNASOL' => 328,
		'SKFFALKENBERG' => 329,
		'PHILIPS1' => 330,
		'BOGE1' => 331,
		'BREMIDATI' => 332,
		'BEHRTHERMTRDATI' => 333,
		'HERTHBUSS' => 334,
		'QUINTONHAZELLDATI' => 335,
		'DELCOREMIDATI' => 336,
		'SICHERHEITS' => 337,
		'DELPHIDATI' => 338,
		'BEHRDATI' => 339,
		'SNRDATI' => 340,
		'NISSENSDATI' => 341,
		'DELPHIDIESELDATI' => 342,
		'SIDEMDATI' => 343,
		'BRINKDATI' => 344,
		'ICERDATI' => 345,
		'GATESDATI' => 346,
		'OSRAMDATI' => 347,
		'MAPCODATI' => 348,
		'CHAMPIONDATI' => 349,
		'ECODATI' => 350,
		'BUDWEGDATI' => 351,
		'DENSOKETNER' => 352,
		'SKFKETNER' => 353,
		'CHAMPIONKETNER' => 354,
		'DELPHIKETNER' => 355,
		'DELCOREMYKETNER' => 356,
		'DELPHIDIESELKETNER' => 357,
		'TRWKETNER' => 358,
		'PHILIPSKETNER' => 359,
		'BOSI' => 361,
		'MARELLI' => 362,
		'BANNER' => 363,
		'DETA' => 364,
		'CHAMPIONBULOW' => 365,
		'JOSAM' => 366,
		'OMP' => 367,
		'HIFLO' => 368,
		'DID' => 369,
		'DEFA' => 370,
		'BOUGI' => 371,
		'ROCKY' => 372,
		'HDK' => 373,
		'CEI' => 374,
		'TSK' => 375,
		'VDO' => 376,
		'TP' => 377,
		'TRIDON' => 378,
		'BUDWEG' => 379,
		'ORIONEKETNER' => 382,
		'FILTRAK' => 385,
		'HELSAAUTOMOTIVE' => 386,
		'EUROFILTER' => 387,
		'ALFILTER' => 388,
		'FILTREC' => 389,
		'GEROIL' => 390,
		'UNICOFILTER' => 391,
		'MPFILTRI' => 392,
		'FRAD' => 393,
		'KANGNAM' => 394,
		'FILMAR' => 395,
		'ARMAFILT' => 396,
		'DONITFILTER' => 397,
		'GUDFILTERS' => 398,
		'KOLBENSCHMIDT' => 399,
		'RACOR' => 400,
		'DRIDYNAS' => 401,
		'ROULUND' => 402,
		'THULE' => 403,
		'DRISTAAS' => 404,
		'INTERMOTOR' => 405,
		'INTEROLD' => 406,
		'INCAR' => 407,
		'VIC' => 408,
		'ALBARET' => 409,
		'ALLISONTRANSMISSION' => 410,
		'ATHEY' => 411,
		'BENATI' => 412,
		'BOLINDERMUNKTELL' => 413,
		'FIATAGRI' => 414,
		'FOMOCO' => 415,
		'JUNGHEINRICH' => 416,
		'KONVEKTA' => 417,
		'LETOURNEAU' => 418,
		'MANITOU' => 419,
		'LISTERPETTER' => 420,
		'RENK' => 421,
		'SEPAR' => 422,
		'VOITH' => 423,
		'WIRA' => 424,
		'WДRTSILД' => 425,
		'NATIONAL' => 426,
		'BATTAGLINO' => 429,
		'BREDAMENARINIBUS' => 430,
		'ZEXEL' => 431,
		'BIA' => 432,
		'TRABOSA' => 433,
		'GPC' => 434,
		'LANZ' => 435,
		'GMB' => 436,
		'NPW' => 437,
		'PARAUT' => 438,
		'EPS' => 439,
		'KW' => 440,
		'ZAFFO' => 441,
		'ABS' => 442,
		'BIVORT' => 443,
		'MTS' => 444,
		'BBT' => 445,
		'AVONTYRES' => 446,
		'COOPERTIRES' => 447,
		'BARUM' => 448,
		'CONTINENTAL' => 449,
		'GENERALTIRE' => 450,
		'GISLAVED' => 451,
		'VIKING' => 452,
		'SEMPERIT' => 453,
		'UNIROYAL' => 454,
		'BFGOODRICHTIRES' => 455,
		'BRIDGESTONE' => 456,
		'DEBICA' => 457,
		'DUNLOP' => 458,
		'FALKEN' => 459,
		'FIRESTONE' => 460,
		'FULDA' => 461,
		'HANKOOK' => 462,
		'KINGSTIRE' => 463,
		'KUMHOTIRES' => 464,
		'MARANGONITYRE' => 465,
		'MARSHALTIRES' => 466,
		'MATADOR' => 467,
		'MEFO' => 468,
		'METZELER' => 469,
		'MICHELIN' => 470,
		'MITAS' => 471,
		'NOKIANTYRES' => 472,
		'PNEUMANT' => 473,
		'STUNNER' => 474,
		'TOYOTIRES' => 475,
		'VREDESTEIN' => 476,
		'YOKOHAMA' => 477,
		'KOIVUNEN' => 478,
		'ALLMAKES' => 479,
		'LPR' => 480,
		'OCAP' => 481,
		'TRUSTING' => 482,
		'KCP' => 483,
		'KAVO' => 484,
		'GLYCO' => 485,
		'WEIDEMANN' => 486,
		'KAMAZ' => 487,
		'CASTROL' => 488,
		'BIRTH' => 489,
		'TRUCKTEC' => 490,
		'REMKAFLEX' => 491,
		'STEYRMOTORS' => 492,
		'SIDAT' => 493,
		'INTERNATIONAL' => 494,
		'CEF' => 495,
		'BOUGICORD' => 496,
		'GAT' => 497,
		'TUDOR' => 498,
		'BINDER' => 499,
		'CFGOMMA' => 500,
		'AEBI' => 501,
		'ALFAROMEO' => 502,
		'AUTOUNION' => 503,
		'AUDI' => 504,
		'AUSTIN' => 505,
		'AUWДRTER' => 506,
		'AWD' => 507,
		'BARREIROS' => 508,
		'BEDFORD' => 509,
		'BERLIET' => 510,
		'BMW' => 511,
		'BUESSING' => 512,
		'CHRYSLER' => 513,
		'CITROEN' => 514,
		'COMMER' => 515,
		'DAF' => 516,
		'DAIHATSU' => 517,
		'DAIMLER' => 518,
		'DEUTSCHEKOCKUM' => 519,
		'DKW' => 520,
		'DODGE' => 521,
		'DROEGMOELLER' => 522,
		'FENWICK' => 523,
		'FIAT' => 524,
		'FORD' => 525,
		'FRUEHAUF' => 526,
		'GMC' => 527,
		'GOTTWALD' => 528,
		'HANOMAG' => 529,
		'HANOMAGHENSCHEL' => 530,
		'HANOMAGRHEINSTAHL' => 531,
		'HENSCHEL' => 532,
		'HONDA' => 533,
		'HOTCHKISSBRAND' => 534,
		'IKARUS' => 535,
		'INNOCENTI' => 536,
		'INTERHARV' => 537,
		'ISUZU' => 538,
		'IVECO' => 539,
		'JAGUAR' => 540,
		'KДLBLE' => 541,
		'KДSSBOHRER' => 542,
		'KHD' => 543,
		'KRUPP' => 544,
		'LADA' => 545,
		'LANCIA' => 546,
		'LEYLAND' => 547,
		'LIAZ' => 548,
		'MACK' => 549,
		'MAGIRUSDEUTZ' => 550,
		'MAN' => 551,
		'MAZDA' => 552,
		'MERCEDESBENZ' => 553,
		'MG' => 554,
		'MITSUBISHI' => 555,
		'MORRIS' => 556,
		'MULTICAR' => 557,
		'NISSAN' => 558,
		'NSU' => 559,
		'OM' => 560,
		'OPEL' => 561,
		'ORLANDI' => 562,
		'PEUGEOT' => 563,
		'YORK' => 564,
		'PORSCHE' => 565,
		'RENAULT' => 566,
		'ROOTES' => 567,
		'ROVER' => 568,
		'SAAB' => 569,
		'SAURER' => 570,
		'SAVIEM' => 571,
		'SCANIA' => 572,
		'SEAT' => 573,
		'SIMCA' => 574,
		'SKODA' => 575,
		'SUBARU' => 576,
		'SUZUKI' => 577,
		'TALBOT' => 578,
		'TOYOTA' => 579,
		'TRIUMPH' => 580,
		'UNICSIMCA' => 581,
		'VANHOOL' => 582,
		'VAUXHALL' => 583,
		'VEBFZWERKE' => 584,
		'VETTER' => 585,
		'VOLVO' => 586,
		'VW' => 587,
		'WHITEMOTOR' => 588,
		'ZASTAVA' => 589,
		'OAF' => 590,
		'AEC' => 591,
		'AGRALE' => 592,
		'ALBION' => 593,
		'ALCATEL' => 594,
		'ASTRA' => 595,
		'AVIA' => 596,
		'AVIAMISA' => 597,
		'BARKAS' => 598,
		'BERNA' => 599,
		'BORGWARD' => 600,
		'BOVA' => 601,
		'CHEVROLET' => 602,
		'DACIA' => 603,
		'DENNIS' => 604,
		'DGOF' => 605,
		'EBRO' => 606,
		'ERF' => 607,
		'FAMSA' => 608,
		'FAUN' => 609,
		'FEDERALMOGUL' => 610,
		'FREIGHTLINER' => 611,
		'GAZ' => 612,
		'GUYMOTORS' => 613,
		'HEULIEZ' => 614,
		'HINO' => 615,
		'IME' => 616,
		'KAROSA' => 617,
		'KARRIER' => 618,
		'KENWORTH' => 619,
		'LEYLANDDAF' => 620,
		'LEYLANDFREIGHTROVE' => 621,
		'LORRAINEPLAXTON' => 622,
		'MARMON' => 623,
		'MEILI' => 624,
		'MERCURY' => 625,
		'NEOPLAN' => 626,
		'OTOMARSAN' => 627,
		'PADANE' => 628,
		'ENASA' => 629,
		'PETERBILT' => 630,
		'POLMO' => 631,
		'RELIANCE' => 632,
		'SAETA' => 633,
		'SALEV' => 634,
		'SANTANA' => 635,
		'SAVA' => 636,
		'SEDDONDIESEL' => 637,
		'SISU' => 638,
		'SSANGYONG' => 639,
		'STEYR' => 640,
		'TAM' => 641,
		'TATATELCO' => 642,
		'TATRA' => 643,
		'TROUILLET' => 644,
		'PIAGGIO' => 645,
		'WESTERNSTAR' => 646,
		'HYUNDAI' => 647,
		'KIA' => 648,
		'DAEWOO' => 649,
		'WARTBURG' => 650,
		'TRABANT' => 651,
		'AUSTINMG' => 652,
		'ROVERAUSTIN' => 653,
		'ROVERTRIUMPHAUSTIN' => 654,
		'ROVTRIUJAGUAUSTIN' => 655,
		'ROVTRIJAGAUSMG' => 656,
		'VAG' => 657,
		'FIATLANCIA' => 658,
		'ALFAFIATLANCIA' => 659,
		'HAGENBATTERIE' => 660,
		'KNORRBREMSE' => 661,
		'GRAU' => 662,
		'BERG' => 663,
		'DAHL' => 664,
		'UFI' => 665,
		'AC' => 666,
		'FLEETGUARD' => 667,
		'DONALDSON' => 668,
		'GOODYEAR' => 669,
		'HUTCHINSON' => 670,
		'KLEBER' => 671,
		'MOPROD' => 672,
		'MOTORCRAFT' => 673,
		'PIRELLI' => 674,
		'TEIKIN' => 675,
		'UNIPART' => 676,
		'BLAUPUNKT' => 677,
		'CARELLO' => 678,
		'DELCOREMY' => 679,
		'DUCELLIER' => 680,
		'EWOTEC' => 681,
		'FEMSA' => 682,
		'FREIENSTEIN' => 683,
		'GAISBACH' => 684,
		'HAGUS' => 685,
		'HAPPICH' => 686,
		'HUECO' => 687,
		'JAEGER' => 688,
		'JOURNEE' => 689,
		'MEKRA' => 690,
		'MERIT' => 691,
		'MESSMER' => 692,
		'MOTEMTRONIC' => 693,
		'MOTOROLA' => 694,
		'NOTEK' => 695,
		'PARISRHONE' => 696,
		'PUDENZ' => 697,
		'SCHIER' => 698,
		'SEVMARCHAL' => 699,
		'SISPA' => 700,
		'STRIBEL' => 701,
		'TUNGSRAM' => 702,
		'PHOENIX' => 703,
		'WEGU' => 704,
		'WEHRLES' => 705,
		'WEHRLEJ' => 706,
		'AGRIA' => 707,
		'BOMAG' => 708,
		'CASEIH' => 709,
		'FIBRON' => 710,
		'FRITZMEIER' => 711,
		'HATZ' => 712,
		'HHF' => 713,
		'HOLDER' => 714,
		'HERCULES' => 715,
		'HITACHI' => 716,
		'MASSEYFERGUSON' => 717,
		'MWM' => 718,
		'NATO' => 719,
		'OK' => 720,
		'POCLAIN' => 721,
		'SAME' => 722,
		'SOLO' => 723,
		'STEINBOCK' => 724,
		'VOTEX' => 725,
		'ZUENDAPP' => 726,
		'LIEBHERR' => 727,
		'AP' => 728,
		'AKG' => 729,
		'ASPERA' => 730,
		'BAHCO' => 731,
		'BRUGGEMANNSTELLA' => 732,
		'DAIICHI' => 733,
		'MTU' => 734,
		'NEWERA' => 735,
		'OMC' => 736,
		'RENNINGTON' => 737,
		'ROTAX' => 738,
		'RENAULTTRUCKS' => 739,
		'STELLA' => 740,
		'WEBASTO' => 741,
		'WERTHENBACH' => 743,
		'AUGROS' => 744,
		'FERRARI' => 745,
		'LAMBORGHINI' => 746,
		'KARMANN' => 747,
		'ROLLSROYCE' => 748,
		'HOTWIRES' => 749,
		'EYQUEM' => 750,
		'AMG' => 751,
		'ALFMEIER' => 752,
		'ASEA' => 753,
		'BARLUK' => 754,
		'CARBUREIBAR' => 755,
		'CORONZ' => 756,
		'COSWORTH' => 757,
		'CUMMINS' => 758,
		'FARYMAN' => 759,
		'KAUTEX' => 760,
		'KEIHIN' => 761,
		'KYOSAN' => 762,
		'MOTOKOV' => 763,
		'MOTORJIKOV' => 764,
		'PERKINS' => 765,
		'PIERBURGFRANCE' => 766,
		'ROCHESTER' => 767,
		'SIEMENS' => 768,
		'SOFABEX' => 769,
		'VOLVOPENTA' => 770,
		'WEBER' => 771,
		'ZENITH' => 772,
		'PM' => 773,
		'DODUCO' => 774,
		'DOWAL' => 775,
		'FACET' => 776,
		'HUCO' => 777,
		'SANKEI' => 778,
		'PAL' => 779,
		'PVL' => 780,
		'ANSA' => 781,
		'AROSI' => 782,
		'AIRREFINER' => 783,
		'KAYSERFILTER' => 784,
		'CAV' => 785,
		'MAFERSA' => 786,
		'ALBERT' => 787,
		'BLAU' => 788,
		'CLAAS' => 789,
		'DEUTZFAHR' => 790,
		'FENDT' => 791,
		'GENERALMOTORS' => 792,
		'JOHNDEERE' => 793,
		'KREIDLER' => 794,
		'MAICO' => 795,
		'AMERICANMOTORSFORD' => 796,
		'BRIGGSSTRATTON' => 797,
		'DAVIDBROWN' => 798,
		'EFEL' => 799,
		'ELMOT' => 800,
		'FER' => 801,
		'SAP' => 802,
		'MITSUBA' => 803,
		'MONARK' => 804,
		'NIKKO' => 805,
		'PRESTOLITE' => 806,
		'ROMANIAMAN' => 807,
		'UNITEDTECHNOLOGIES' => 808,
		'MASERATI' => 809,
		'ROBUR' => 810,
		'RELIANT' => 811,
		'PONTIAC' => 812,
		'FSO' => 813,
		'FORDUSA' => 814,
		'LANDRANGERO' => 815,
		'PROTON' => 816,
		'PERLINI' => 817,
		'SICCA' => 818,
		'TEMOT' => 819,
		'HENGSTENBERG' => 820,
		'ELECTROSTART' => 821,
		'KATEK' => 822,
		'IHL' => 823,
		'BUGATTI' => 824,
		'DOLZ' => 825,
		'FIRMATEC' => 826,
		'GEBA' => 827,
		'GRAF' => 828,
		'KRULL' => 829,
		'KWP' => 830,
		'SALERI' => 831,
		'TSUNION' => 832,
		'TRW' => 833,
		'AUTOBIANCHI' => 834,
		'BLMC' => 835,
		'HOLDEN' => 836,
		'LOTUS' => 837,
		'MORGAN' => 838,
		'CITROENPEUGEOT' => 839,
		'VWSEAT' => 840,
		'DATSUN' => 841,
		'OTOSAN' => 842,
		'VOLGA' => 843,
		'ALPINE' => 844,
		'GLAS' => 845,
		'MOSKVICH' => 846,
		'TRIPLEFIVE' => 847,
		'BENTLEY' => 848,
		'BUICK' => 849,
		'BUNDESWEHR' => 850,
		'CACCIAMAII' => 851,
		'CADILLAC' => 852,
		'CLARK' => 853,
		'DAMAG' => 854,
		'DENOUDSTENBUSSEN' => 855,
		'DUEWAG' => 856,
		'EAGLE' => 857,
		'EHRENREICH' => 858,
		'ESM' => 859,
		'EVOBUS' => 860,
		'EWK' => 861,
		'FODENTRUCKS' => 862,
		'FRIMATEC' => 863,
		'GEO' => 864,
		'GINAF' => 865,
		'GOLDHOFER' => 866,
		'GROVE' => 867,
		'ALFREDHEYD' => 868,
		'JCBLANDPOWER' => 869,
		'JONCKHEERE' => 870,
		'KOEGELFAHRZEUGWERKE' => 871,
		'LANZMARTI' => 872,
		'LANDTECHSCHOENEBECK' => 873,
		'LEXUS' => 874,
		'MCW' => 875,
		'MDW' => 876,
		'MEGA' => 877,
		'MENARINI' => 878,
		'MOWAG' => 879,
		'NOOTEBOOM' => 880,
		'OPTARE' => 881,
		'PLYMOUTH' => 882,
		'PREMIER' => 883,
		'PREVOST' => 884,
		'RABAUNGARN' => 885,
		'RENDERS' => 886,
		'ROCKWELL' => 887,
		'SAF' => 888,
		'SHANGHAI' => 889,
		'SPIERINGSKRANEN' => 890,
		'STILL' => 891,
		'TERBERG' => 892,
		'TVR' => 893,
		'VME' => 894,
		'ZF' => 895,
		'VWPORSCHE' => 896,
		'BERKHOF' => 897,
		'ALPINA' => 898,
		'BACHMANN' => 899,
		'FRIWEG' => 900,
		'GFP' => 901,
		'HILLMANN' => 902,
		'KUHNEKOPPUKAUSCH' => 903,
		'NEDCAR' => 904,
		'REMPLOYLTD' => 905,
		'SEMEX' => 906,
		'ASIAMOTORS' => 907,
		'PUMA' => 908,
		'ASTONMARTIN' => 909,
		'JEEP' => 910,
		'IWLUDWIGSFELDE' => 911,
		'ARDENAISSEDESSIEUX' => 912,
		'BPW' => 913,
		'CALABRESE' => 914,
		'CARDI' => 915,
		'CARRIMORE' => 916,
		'CASTARA' => 917,
		'CAZENAVE' => 918,
		'CODER' => 919,
		'COLAERT' => 920,
		'DORSEY' => 921,
		'EATON' => 922,
		'GOTHAER' => 923,
		'HAHN' => 924,
		'KNOTT' => 925,
		'LAG' => 926,
		'LECINENA' => 927,
		'LECITRAILER' => 928,
		'LOHR' => 929,
		'MOL' => 930,
		'MULLERMITTELTAL' => 931,
		'PERROT' => 932,
		'TRAILOR' => 933,
		'WARSTEIN' => 934,
		'WESTFIELD' => 935,
		'MARUTI' => 936,
		'HAKO' => 937,
		'GUTBROD' => 938,
		'ABG' => 939,
		'AHLMANN' => 940,
		'AKERMANVERKSTADAB' => 941,
		'ALLISCHALMERS' => 942,
		'ARMAX' => 943,
		'ATLASWEYHAUSEN' => 944,
		'ATLAS' => 945,
		'AUSTINWESTERN' => 946,
		'AVELINGBARFORD' => 947,
		'BALKANCAR' => 948,
		'BANTAM' => 949,
		'BARBERGREENE' => 950,
		'BARFORDOFBELTON' => 951,
		'BAYCITYSHOVELS' => 952,
		'BENFORD' => 953,
		'BENFRA' => 954,
		'BERTOLINI' => 955,
		'BLAWKNOX' => 956,
		'BOHNUKAEHLER' => 957,
		'BRAYCONSTRUCTION' => 958,
		'BRITISHCRANEAEXCA' => 959,
		'BRITISHHOISTACRA' => 960,
		'BROOMANDWADE' => 961,
		'BUCRUSERIE' => 962,
		'CAFL' => 963,
		'CALSA' => 964,
		'CATERPILLAR' => 965,
		'CLEVELAND' => 966,
		'COLES' => 967,
		'CONSOLIDATEDPNEUMAT' => 968,
		'DECAUVILLE' => 969,
		'DRESSER' => 970,
		'DYNAPAC' => 971,
		'EDER' => 972,
		'ELECTRAMOLINS' => 973,
		'EUCLID' => 974,
		'FIATALLIS' => 975,
		'FIATHITACHI' => 976,
		'FLOTTMANNWERKE' => 977,
		'FORDNEWHOLLAND' => 978,
		'FUCHS' => 979,
		'GALION' => 980,
		'GARWOOD' => 981,
		'GMEINDER' => 982,
		'GRADALL' => 983,
		'GROUPESINDUSTRIES' => 984,
		'HAMM' => 985,
		'HATRA' => 986,
		'HENLEY' => 987,
		'HOES' => 988,
		'HOLMAN' => 989,
		'HYMAC' => 990,
		'HYDROVANE' => 991,
		'HYSTER' => 992,
		'INGERSOLLRAND' => 993,
		'IRMERUELZE' => 994,
		'ITMATRATTORI' => 995,
		'JCBBAMFORD' => 996,
		'JONESCRANES' => 997,
		'JENBACHERWERKE' => 998,
		'KAELBLE' => 999,
		'KAELBLEGMEINDER' => 1000,
		'KIMCO' => 1001,
		'KOCKUM' => 1002,
		'KOMATSU' => 1003,
		'KRAMER' => 1004,
		'KUBOTA' => 1005,
		'LANCERBOSS' => 1006,
		'LANDINI' => 1007,
		'LAURAK' => 1008,
		'LOKOMO' => 1009,
		'LOSENHAUSEN' => 1010,
		'TRACKMARSALL' => 1011,
		'MASSEYFERGHANOMAG' => 1012,
		'MASSEYHARRIS' => 1013,
		'MELROE' => 1014,
		'MENCKUHAMBROCK' => 1015,
		'MENGELE' => 1016,
		'MIAG' => 1017,
		'MICHIGAN' => 1018,
		'PINGON' => 1019,
		'PINGUELY' => 1020,
		'PRIESTMANBROTHERS' => 1021,
		'RANSOMESRAPIER' => 1022,
		'RICHIER' => 1023,
		'RUHRINTRANS' => 1024,
		'RUTHEMEYER' => 1025,
		'SAMUR' => 1026,
		'SCHAEFF' => 1027,
		'SCHEID' => 1028,
		'SCHOPF' => 1029,
		'SENNEBOGEN' => 1030,
		'SHAWJOSHUA' => 1031,
		'SHAWNEEPOOLE' => 1032,
		'SHELVOKEADREWRY' => 1033,
		'SHORTBROTHERS' => 1034,
		'SOYLAND' => 1035,
		'SULLAIR' => 1036,
		'TIMBERJACK' => 1037,
		'TOSELLI' => 1038,
		'TOWMOTORCORP' => 1039,
		'TRACMA' => 1040,
		'VALMET' => 1041,
		'WAYNE' => 1042,
		'WEATHERHILL' => 1043,
		'WELDINGINDUSTRIES' => 1044,
		'WESERHUETTE' => 1045,
		'WESTERBEKE' => 1046,
		'WHITE' => 1047,
		'WHITLOCKBROTHERS' => 1048,
		'YAMAHA' => 1049,
		'ZETTELMEYER' => 1050,
		'CESAB' => 1051,
		'FIATOMCARELLIELEV' => 1052,
		'GUELDNER' => 1053,
		'HUNTER' => 1054,
		'IRION' => 1055,
		'LABRUGEOISE' => 1056,
		'LINDE' => 1057,
		'MAQUINARIAINDUSTRIA' => 1058,
		'MATBRO' => 1059,
		'TANSINI' => 1060,
		'AGCO' => 1061,
		'AGRIFULL' => 1062,
		'AMAT' => 1063,
		'ARBOS' => 1064,
		'ASMOTOR' => 1065,
		'AVCONEWIDEA' => 1066,
		'BAUTZ' => 1067,
		'BCS' => 1068,
		'BOBARD' => 1069,
		'BOURGION' => 1070,
		'BRAUD' => 1071,
		'BROYT' => 1072,
		'BUEHRER' => 1073,
		'BUKH' => 1074,
		'BUNGARTZUPESCHKE' => 1075,
		'CARRARO' => 1076,
		'CBT' => 1077,
		'CLAYSON' => 1078,
		'COCKSHUTT' => 1079,
		'COUNTYCOMMERCIAL' => 1080,
		'COVENTRYCLIMAX' => 1081,
		'DECHENTREITERLELY' => 1082,
		'DEXHEIMER' => 1083,
		'DRONNINGBORG' => 1084,
		'EICHER' => 1085,
		'EIMCO' => 1086,
		'EPPLEBUXBAUM' => 1087,
		'FAHR' => 1088,
		'FLYMO' => 1089,
		'GLOUCESTER' => 1090,
		'GOLDONI' => 1091,
		'GRAEFSTIFT' => 1092,
		'GRIFFETICENDIE' => 1093,
		'HARVALTRUCK' => 1094,
		'HESTONCORPORATION' => 1095,
		'HUERLIMANN' => 1096,
		'HYDRAULICMACHINERY' => 1097,
		'IFA' => 1098,
		'INDUSTRIJAMOTORA' => 1099,
		'INTERNTRACTORCO' => 1100,
		'IRUS' => 1101,
		'KOEDELUBOEHMGMBH' => 1102,
		'LABOURIER' => 1103,
		'LANDONI' => 1104,
		'LANSINGBAGNALL' => 1105,
		'LAVERDA' => 1106,
		'LMV' => 1107,
		'LOISEAU' => 1108,
		'LONG' => 1109,
		'MANOX' => 1110,
		'MAXION' => 1111,
		'SPERRYNEWHOLLAND' => 1112,
		'OLIVER' => 1113,
		'POTTINGER' => 1114,
		'RANSOMESSIMMSJEFFR' => 1115,
		'REFORMWERKE' => 1116,
		'RICHARD' => 1117,
		'RIVIERRECASALIS' => 1118,
		'ROSENLEW' => 1119,
		'RUBERYOWEN' => 1120,
		'RUSTONBUCYRUS' => 1121,
		'SABATIER' => 1122,
		'SAINTCHAMOND' => 1123,
		'SCHANZLIN' => 1124,
		'SCHILTER' => 1125,
		'SCHLUTER' => 1126,
		'SCHMIEDAG' => 1127,
		'SLC' => 1128,
		'SOMECA' => 1129,
		'STOTHERTAPITT' => 1130,
		'TEMATERRA' => 1131,
		'TORPEDO' => 1132,
		'UZINATRACTORUL' => 1133,
		'VALPADANA' => 1134,
		'VENDEUVRE' => 1135,
		'WARCHALOWSKI' => 1136,
		'WESTERASMASKINER' => 1137,
		'YANMAR' => 1138,
		'ZETOR' => 1139,
		'STIHL' => 1140,
		'BOMBARDIER' => 1141,
		'KAWASAKI' => 1142,
		'NEWFLYER' => 1143,
		'TIELBURGER' => 1144,
		'KALMARIRON' => 1145,
		'PACCAR' => 1146,
		'PACTON' => 1147,
		'PAILTON' => 1148,
		'SMART' => 1149,
		'ZAZ' => 1150,
		'OLDSMOBILE' => 1151,
		'LINCOLN' => 1152,
		'STAHLGRUBER' => 1153,
		'TIPTOP' => 1154,
		'SWAG' => 1156,
		'BRADI' => 1157,
		'MAHINDRA' => 1158,
		'AVF' => 1159,
		'ELECTROPRECISI' => 1160,
		'ELPROM' => 1161,
		'INTERNHARVESTER' => 1162,
		'ARO' => 1163,
		'LDVINTERNATIONAL' => 1164,
		'VTE' => 1165,
		'ASMET' => 1166,
		'CISAM' => 1167,
		'DESCAM' => 1168,
		'ECIA' => 1169,
		'FENNO' => 1170,
		'FONOS' => 1171,
		'IMASAF' => 1172,
		'ROMAX' => 1173,
		'ROSI' => 1174,
		'TECHNOMAG' => 1175,
		'TESTAG' => 1176,
		'TIMAX' => 1177,
		'USN' => 1178,
		'VANHECK' => 1179,
		'ZARA' => 1180,
		'CIA' => 1181,
		'CROMADORA' => 1182,
		'ESTEE' => 1183,
		'HAVAM' => 1184,
		'MIVV' => 1185,
		'PEDOL' => 1186,
		'ECHLININTERNATIONAL' => 1187,
		'TAMCOINC' => 1188,
		'NTKNGKGROUP' => 1189,
		'AIXAM' => 1190,
		'ALBANY' => 1191,
		'APAL' => 1192,
		'BERTONE' => 1193,
		'BITTER' => 1194,
		'BRISTOL' => 1195,
		'CALLAWAY' => 1196,
		'CARBODIES' => 1197,
		'CATERHAM' => 1198,
		'CHECKER' => 1199,
		'COLEMANMILNE' => 1200,
		'DALLAS' => 1201,
		'DELOREAN' => 1202,
		'DETOMASO' => 1203,
		'FORDAUSTRALIA' => 1204,
		'SATURN' => 1205,
		'GINETTA' => 1206,
		'HINDUSTAN' => 1207,
		'HOBBYCAR' => 1208,
		'AUTHI' => 1209,
		'DINGLER' => 1210,
		'ENVEMO' => 1211,
		'GILBERN' => 1212,
		'ACURA' => 1213,
		'HUMMER' => 1214,
		'INDIGO' => 1215,
		'IRMSCHER' => 1216,
		'ISDERA' => 1217,
		'ISH' => 1218,
		'JENSEN' => 1219,
		'LIGHTCARCOMPANY' => 1220,
		'LIGIER' => 1221,
		'LISTER' => 1222,
		'LUAZ' => 1223,
		'MARCOS' => 1224,
		'MARLIN' => 1225,
		'MCLAREN' => 1226,
		'MEBEA' => 1227,
		'METROCAB' => 1228,
		'MIDDLEBRIDGE' => 1229,
		'MINELLI' => 1230,
		'MINI' => 1231,
		'NAYLOR' => 1232,
		'MITSUBISHILONSDALE' => 1233,
		'INFINITI' => 1234,
		'OLTCIT' => 1235,
		'ONAN' => 1236,
		'OSCA' => 1237,
		'PANOZ' => 1238,
		'PANTHER' => 1239,
		'PAYKAN' => 1240,
		'PERODUA' => 1241,
		'RANGER' => 1242,
		'RAPID' => 1243,
		'RAYTONFISSORE' => 1244,
		'BOND' => 1245,
		'AUSTINHEALEY' => 1246,
		'RILEY' => 1247,
		'STERLING' => 1248,
		'WOLSELEY' => 1249,
		'RTI' => 1250,
		'SAFRAR' => 1251,
		'SAN' => 1252,
		'SAO' => 1253,
		'SBARRO' => 1254,
		'SHELBY' => 1255,
		'SIPANI' => 1256,
		'SPECTRE' => 1257,
		'STANDARD' => 1258,
		'TOFAS' => 1259,
		'TRIDENT' => 1260,
		'UAZ' => 1261,
		'UMM' => 1262,
		'VECTOR' => 1263,
		'VENTURI' => 1264,
		'VIASA' => 1265,
		'WIESMANN' => 1266,
		'YULON' => 1267,
		'PUCH' => 1268,
		'BRECO' => 1269,
		'DUKER' => 1270,
		'JAPCAR' => 1271,
		'OBTECAS' => 1272,
		'PIM' => 1273,
		'SEBRO' => 1274,
		'WURTH' => 1275,
		'BREMSUKUPPLTEILE' => 1276,
		'AKEBONO' => 1277,
		'FMSIVERBAND' => 1278,
		'CUSTOMISEDPRODUCTS' => 1279,
		'SAE' => 1280,
		'INTERBRAKE' => 1281,
		'PETERS' => 1282,
		'BARMAG' => 1283,
		'FIPARTS' => 1284,
		'ORION' => 1285,
		'VERNET' => 1286,
		'YALE' => 1287,
		'IHC' => 1288,
		'LANDROVER' => 1292,
		'ALLINQUANT' => 1293,
		'AMORTEX' => 1294,
		'ARALMEX' => 1295,
		'ARMSTRONG' => 1296,
		'ASCO' => 1297,
		'BELDESAN' => 1298,
		'CENTRALAUTOMOTIVEP' => 1299,
		'CODISA' => 1300,
		'COFAP' => 1301,
		'CORAM' => 1302,
		'DAIKIN' => 1303,
		'DECARBON' => 1304,
		'DURA' => 1305,
		'EUROQUIP' => 1306,
		'FAG' => 1307,
		'FUJICHEMCOOP' => 1308,
		'FRAYMON' => 1309,
		'GEMO' => 1310,
		'HARTHA' => 1311,
		'HOLZHДUSER' => 1312,
		'INA' => 1313,
		'KOYO' => 1314,
		'KUMA' => 1315,
		'LAYCOCK' => 1316,
		'LIPMESA' => 1317,
		'BREDALORETT' => 1318,
		'NACHI' => 1319,
		'NSK' => 1320,
		'NTN' => 1321,
		'REPCO' => 1322,
		'SEOJINDAIKINCORP' => 1323,
		'SIA' => 1324,
		'SIRMOURSUDBURGIND' => 1325,
		'SV' => 1326,
		'TOKICO' => 1327,
		'VEGAZGMBH' => 1329,
		'BRAKEPARTSINC' => 1330,
		'EIS' => 1331,
		'IPI' => 1332,
		'KELSEYHAYES' => 1333,
		'KONGSBERG' => 1334,
		'RAYBESTOS' => 1335,
		'SBK' => 1336,
		'WILLYS' => 1337,
		'WAGNERLOCKHEED' => 1338,
		'KAYSER' => 1339,
		'SBS' => 1340,
		'HPZEBRA' => 1341,
		'OJDQUICKBRAKE' => 1342,
		'SAGEM' => 1344,
		'DUPLICOLOR' => 1345,
		'MOTIP' => 1346,
		'PRESTO' => 1347,
		'TYC' => 1348,
		'ZFGETRIEBE' => 1349,
		'ORDONEZ' => 1350,
		'NRFMAROC' => 1351,
		'CTR' => 1352,
		'ARD' => 1353,
		'JALAIR' => 1354,
		'MONTANA' => 1355,
		'NAVARRA' => 1356,
		'NURAL' => 1357,
		'MECAFILTER' => 1358,
		'IDROMEC' => 1359,
		'DURITE' => 1360,
		'MENBERS' => 1361,
		'LP' => 1362,
		'ABS' => 1363,
		'ROULUNDSBRAKING' => 1364,
		'SCTGERMANY' => 1365,
		'ELSTOCK' => 1366,
		'TRICO' => 1367,
		'ECO' => 1368,
		'ORIONE' => 1369,
		'EOLO' => 1370,
		'FLASHAIR' => 1371,
		'FLENNOR' => 1372,
		'ELWISROYAL' => 1373,
		'IPSA' => 1374,
		'DBA' => 1375,
		'PBR' => 1376,
		'SEIKEN' => 1377,
		'BANDO' => 1378,
		'APRILIA' => 1379,
		'ARGO' => 1380,
		'ARMSTRONGSIDDELEY' => 1381,
		'ASAS' => 1382,
		'ASHIKA' => 1383,
		'ATP' => 1384,
		'AUTOTECH' => 1385,
		'BECKARNLEY' => 1386,
		'BENELLI' => 1387,
		'BIGFILTER' => 1388,
		'MITSUBOSHI' => 1389,
		'YEC' => 3001,
		'PRINCESS' => 3002,
		'FISSORE' => 3003,
		'PEGASO' => 3004,
		'NUOVAINNOCENTI' => 3005,
		'LEYLANDINNOCENTI' => 3006,
		'JEEPVIASA' => 3007,
		'MIURA' => 3008,
		'MATRA' => 3009,
		'GURGEL' => 3010,
		'YUELOONG' => 3011,
		'TRESER' => 3012,
		'MINTYE' => 3013,
		'AWS' => 3015,
		'DETROITDIESEL' => 3106,
		'NPR' => 3136,
		'SMB' => 3173,
		'CAMELLIA' => 3564,
		'REMY' => 3675,
		'SETRA' => 3679,
		'ALLIEDSIGNAL' => 3680,
		'ASSO' => 3681,
		'ASVA' => 3682,
		'AVA' => 3683,
		'BLUEPRINT' => 3684,
		'CTC' => 3685,
		'DELLO' => 3686,
		'AUDIVW' => 10000,
		'TOYOTAFORKLIFT' => 10001,
		'CLIFFORD' => 10002,
		'DEPO' => 10003,
		'SASIC' => 10004,
		'ABACUS' => 10005,
		'EMBO' => 10006,
		'ADRIAUTO' => 10007,
		'CARGO' => 10008,
		'FM' => 10009,
		'ITALCARDANO' => 10010,
		'SHELL' => 10011,
		'SIFFERT' => 10012,
		'SIL' => 10013,
		'SIMBO' => 10014,
		'COOLEX' => 10015,
		'SNRA' => 10016,
		'SPARCO' => 10017,
		'SPARK' => 10018,
		'SPRINGS' => 10019,
		'STANADYNE' => 10020,
		'SUDRAD' => 10021,
		'SUPERSPRINT' => 10022,
		'SUPLEX' => 10023,
		'TARABUSI' => 10024,
		'TC' => 10025,
		'TECHNICOLL' => 10026,
		'TECNOSIR' => 10027,
		'TEMPRA' => 10028,
		'TES' => 10029,
		'TEXACO' => 10030,
		'TIMKEN' => 10031,
		'TMT' => 10032,
		'TOMCO' => 10033,
		'UNIOR' => 10034,
		'SCHOTTLE' => 10035,
		'VALVOLINE' => 10036,
		'VENTURASPRINGS' => 10037,
		'EIK' => 10038,
		'VK' => 10039,
		'WESEM' => 10040,
		'WUZETEM' => 10041,
		'YAZDA' => 10042,
		'ZEN' => 10043,
		'ZMOS' => 10044,
		'JUMAG' => 10045,
		'MOTGUM' => 10046,
		'MOTIVE' => 10047,
		'MP' => 10048,
		'MVI' => 10049,
		'ALMAN' => 10050,
		'OPTIMIT' => 10051,
		'ORAN' => 10052,
		'ORING' => 10053,
		'ORLEN' => 10054,
		'OSVAT' => 10055,
		'PC' => 10056,
		'PERMABOND' => 10057,
		'PHIRA' => 10058,
		'PJ' => 10059,
		'POLAUTO' => 10060,
		'POLKORK' => 10061,
		'POWERTECH' => 10062,
		'POZGUM' => 10063,
		'R2A' => 10064,
		'RAFINERAGDACSKA' => 10065,
		'MORPACK' => 10066,
		'RAVENOL' => 10067,
		'RECO' => 10068,
		'RESMA' => 10069,
		'MAXICAR' => 10070,
		'RINGFEDER' => 10071,
		'ROCKINGER' => 10072,
		'RUD' => 10073,
		'RULSNR' => 10074,
		'SHOSES' => 10075,
		'SAGA' => 10076,
		'SAMCO' => 10077,
		'HS' => 10078,
		'HYE' => 10079,
		'ICS' => 10080,
		'IMAP' => 10081,
		'IMPERGOM' => 10082,
		'ISAM' => 10083,
		'IWIS' => 10084,
		'JAB' => 10085,
		'NDC' => 10086,
		'JOST' => 10087,
		'KN' => 10088,
		'KME' => 10089,
		'KOMETAL' => 10090,
		'LEART' => 10091,
		'KS' => 10092,
		'CEDREGSA' => 10093,
		'GOMET' => 10094,
		'EUROHESPERIA' => 10095,
		'FISCHERPLATH' => 10096,
		'KSW' => 10097,
		'KUKKO' => 10098,
		'LEMA' => 10099,
		'LINDOGOBE' => 10100,
		'LIPE' => 10101,
		'LIZARTE' => 10102,
		'LOCKHEED' => 10103,
		'LONGHO' => 10104,
		'MARCO' => 10105,
		'MEATDORIA' => 10106,
		'MEILLOR' => 10107,
		'METALINCAR' => 10108,
		'METALGOM' => 10109,
		'MIRAGLIO' => 10110,
		'MOBIL' => 10111,
		'MOBILETRON' => 10112,
		'CIFAM' => 10113,
		'CMR' => 10114,
		'CORCOS' => 10115,
		'GLOUGHWOOD' => 10116,
		'COVIND' => 10117,
		'CRC' => 10118,
		'CROMODORA' => 10119,
		'CURTYPAYEN' => 10120,
		'DINEX' => 10121,
		'ELF' => 10122,
		'ELTEK' => 10123,
		'ENZET' => 10124,
		'ERA' => 10125,
		'EUROPARTS' => 10126,
		'EURORICAMBI' => 10127,
		'EUROSTAMP' => 10128,
		'EVR' => 10129,
		'FALGA' => 10130,
		'FLOSSER' => 10131,
		'FRECCIA' => 10132,
		'FZBH' => 10133,
		'GF' => 10134,
		'GR' => 10135,
		'HALDEX' => 10136,
		'HANS' => 10137,
		'HANSPRIES' => 10138,
		'HAZET' => 10139,
		'ABFILTER' => 10140,
		'ABA' => 10141,
		'AISIN' => 10142,
		'AJUST' => 10143,
		'ARAL' => 10144,
		'ARREGUI' => 10145,
		'ARTO' => 10146,
		'ASPOCK' => 10147,
		'AUTOLINKA' => 10148,
		'AUTOFREN' => 10149,
		'BCD' => 10150,
		'BETA' => 10151,
		'BH' => 10152,
		'BORYSZEW' => 10153,
		'BRECHMANN' => 10154,
		'CEI' => 10155,
		'CAPAT' => 10156,
		'CARTECHNIK' => 10157,
		'PINDUR' => 10158,
		'HART' => 10159,
		'COFLE' => 10160,
		'DRAPER' => 10161,
		'AMBER' => 10162,
		'TOTAL' => 10163,
		'PARADOWSCY' => 10164,
		'PROKOM' => 10165,
		'ARMETALL' => 10166,
		'MOTOSBIS' => 10167,
		'LUBERFINER' => 10168,
		'AMA' => 10169,
		'MATOSKA' => 10170,
		'CROSS' => 10171,
		'AMBIPUR' => 10172,
		'SENTECH' => 10173,
		'HERZOG' => 10174,
		'SMILE' => 10175,
		'TNT' => 10176,
		'ADLER' => 10177,
		'GME' => 10178,
		'ARTEB' => 10179,
		'MIKODA' => 10180,
		'SKR' => 10181,
		'TOMPAR' => 10182,
		'RALLY' => 10183,
		'COSPEL' => 10184,
		'COSIBO' => 10185,
		'OXFORD' => 10186,
		'POLGUM' => 10187,
		'AGV' => 10188,
		'ARROW' => 10189,
		'STATOIL' => 10190,
		'TECNECO' => 10191,
		'FRAP' => 10192,
		'TECHJOI' => 10193,
		'BOSCHELEKTRONARZКDZIA' => 10194,
		'PADRE' => 10195,
		'PRASCO' => 10196,
		'UNICAR' => 10197,
		'UNITROL' => 10198,
		'HELICOIL' => 10199,
		'LEITENBERGEN' => 10200,
		'POLMEBLE' => 10201,
		'RODAC' => 10202,
		'ITALCOM' => 10203,
		'ASMETNORMALIA' => 10204,
		'AUTODATA' => 10205,
		'EUROPA' => 10206,
		'SAKA' => 10207,
		'SEJN' => 10208,
		'WORTH' => 10209,
		'MIERNIK' => 10210,
		'OMA' => 10211,
		'KUUNIA' => 10212,
		'KLANN' => 10213,
		'WKRKTAKI' => 10214,
		'PROLINE' => 10215,
		'POHRLUX' => 10216,
		'TIMPOL' => 10217,
		'IZNS' => 10218,
		'AKM' => 10219,
		'ROMIX' => 10220,
		'RIAL' => 10221,
		'VAZLTDA' => 10222,
		'LITTELFUSE' => 10223,
		'WOLF' => 10224,
		'KATA' => 10225,
		'TECHNIKA' => 10226,
		'AUTOTRANS' => 10227,
		'LIQUIMOLY' => 10228,
		'STEINHOF' => 10229,
		'KRYSTAN' => 10230,
		'SHELLADVANCE' => 10231,
		'FASTSERVICE' => 10232,
		'CASTROLMOTO' => 10233,
		'MMI' => 10234,
		'SONOPAN' => 10235,
		'TESLA' => 10236,
		'MAXCOM' => 10237,
		'DRESTER' => 10238,
		'AMERICANTOOL' => 10239,
		'BEISSBARTH' => 10240,
		'WP' => 10241,
		'EUROCAMS' => 10242,
		'ATHENASPA' => 10243,
		'GUTMANN' => 10244,
		'WARN' => 10245,
		'TEN' => 10246,
		'CROMACSNC' => 10247,
		'PREMIERSUPPLY' => 10248,
		'DD' => 10249,
		'GUARNITAUTO' => 10250,
		'SYKESPICKAVANT' => 10251,
		'RAASM' => 10252,
		'TOPDRIVE' => 10253,
		'GALERIAJESTEM' => 10254,
		'VDOKIENZLE' => 10255,
		'NABOR' => 10256,
		'AKUSAN' => 10257,
		'ATEX' => 10258,
		'NIKMAR' => 10259,
		'SOLTECH' => 10260,
		'RYWAL' => 10261,
		'RAUFOSS' => 10262,
		'LEMMERZ' => 10263,
		'DIGITALTECHNOLOGY' => 10264,
		'IZOFOL' => 10265,
		'MIDLANDCALIPER' => 10266,
		'RIVET' => 10267,
		'FREEMANAUTOMOTIVE' => 10268,
		'KOREAOEM' => 10269,
		'KEGEL' => 10300,
		'TEDGUM' => 10301,
		'ARTECH' => 10302,
		'FUDICKAR' => 10303,
		'VERA' => 10304,
		'WIKPOL' => 10305,
		'HILDEBRAND' => 10306,
		'FLORIMEX' => 10307,
		'JOPE' => 10308,
		'KANRA' => 10309,
		'MOTOMAX' => 10310,
		'PJYCIENNIK' => 10311,
		'4MAX' => 10312,
		'HIPOL' => 10313,
		'ROR' => 10314,
		'COMPLEX' => 10315,
		'GMAK' => 10316,
		'SUER' => 10317,
		'GUEST' => 10318,
		'PLASTMAL' => 10319,
		'ASTE' => 10320,
		'ONEAL' => 10321,
		'SALTUS' => 10322,
		'PPTUNINGSRO' => 10323,
		'IRB' => 10324,
		'NADELLA' => 10325,
		'CESARELANDISRL' => 10326,
		'OBEZ' => 10327,
		'AMTRA' => 10328,
		'TIPTOPOL' => 10329,
		'UTIKA' => 10330,
		'GIORGIONANNINISRL' => 10331,
		'BERTOCCO' => 10332,
		'BAT' => 10333,
		'UNITAL' => 10334,
		'ERLLTD' => 10335,
		'CENTRUM' => 10336,
		'WRP' => 10337,
		'W2BOOTS' => 10338,
		'GREDDY' => 10339,
		'KARCHER' => 10340,
		'ADLERSPA' => 10341,
		'RECTUS' => 10342,
		'CARGOLIFT' => 10343,
		'TEJAS' => 10344,
		'ZMP' => 10345,
		'AST' => 10346,
		'DKBICA' => 10347,
		'HYVA' => 10348,
		'MONDIAL' => 10349,
		'GILLERT' => 10350,
		'MOTOPOL' => 10351,
		'DAYTON' => 10352,
		'ALUTEAM' => 10353,
		'ZELMOT' => 10354,
		'BEAM' => 10355,
		'FLYRACING' => 10356,
		'ZMH' => 10357,
		'EXEDY' => 10358,
		'FL' => 10359,
		'VANSTAR' => 10360,
		'SRL' => 10361,
		'KABELTECHNIK' => 10362,
		'IB' => 10363,
		'PIRELLISPORT' => 10364,
		'GUMEX' => 10365,
		'PIRELLIOPONY' => 10366,
		'ROBINAIR' => 10367,
		'WESTFAL' => 10368,
		'VIPP' => 10369,
		'TELWIN' => 10370,
		'GOODRICH' => 10371,
		'KORMORAN' => 10372,
		'TECNOTEST' => 10373,
		'PPG' => 10374,
		'LOGICO' => 10375,
		'KKK' => 10376,
		'SLIFT' => 10377,
		'POROLET' => 10378,
		'ASTROMAL' => 10379,
		'CAORLE' => 10380,
		'SPIN' => 10381,
		'DUNLOPOPONY' => 10382,
		'JPGROUP' => 10383,
		'MAD' => 10384,
		'HESTAL' => 10385,
		'RAYTEK' => 10386,
		'KLEBEROPONY' => 10387,
		'PLACIMET' => 10388,
		'SYMETRIX' => 10389,
		'HOFMANN' => 10390,
		'EINHELL' => 10391,
		'ARI' => 10392,
		'PLASTMET' => 10393,
		'ASDESIGN' => 10394,
		'SABELT' => 10395,
		'ACERBIS' => 10396,
		'ALPINESTARS' => 10397,
		'LINDEGAZ' => 10398,
		'BORBET' => 10399,
		'RONAL' => 10400,
		'CW' => 10401,
		'ALUTEC' => 10402,
		'AZEV' => 10403,
		'MABOR' => 10404,
		'PARKTRONIK' => 10405,
		'ARTEC' => 10406,
		'OZ' => 10407,
		'MSW' => 10408,
		'BATERIEPRZEMISJOVE' => 10409,
		'GIANETTY' => 10410,
		'RAD' => 10411,
		'ATS' => 10412,
		'EXLUSIVELINE' => 10413,
		'POMMIER' => 10414,
		'SERWO' => 10415,
		'FILTROMEX' => 10416,
		'NEDERMAN' => 10417,
		'ECSINTERNATIONAL' => 10418,
		'SUPERSPROX' => 10419,
		'MEGASET' => 10420,
		'KOREK' => 10421,
		'OEUSA' => 10422,
		'AUTOMEX' => 10423,
		'NUSBAUM' => 10424,
		'UNIMETAL' => 10425,
		'BLOCKY' => 10426,
		'CEMB' => 10427,
		'MOTORSCAN' => 10428,
		'SJOWIK' => 10429,
		'PARKER' => 10430,
		'HERZ' => 10431,
		'ELEKTROMET' => 10432,
		'GRUPADEKOR' => 10433,
		'KLIMAWENT' => 10434,
		'DELMET' => 10435,
		'SIMBOLZ' => 10436,
		'HEKA' => 10437,
		'CARMATE' => 10438,
		'PARYS' => 10439,
		'DEF' => 10440,
		'WYDAWNICTVOAUTO' => 10441,
		'AUTOGAZ' => 10442,
		'HAULER' => 10443,
		'WS' => 10444,
		'KNIPEX' => 10445,
		'ECOTECHNICS' => 10446,
		'SATA' => 10447,
		'JONNES' => 10448,
		'MOTUL' => 10449,
		'AEM' => 10450,
		'BRAINBEE' => 10451,
		'VCOIL' => 10452,
		'ADDINDUSTRY' => 10453,
		'PPHTALEKS' => 10454,
		'MAHA' => 10455,
		'SPYLNOTA' => 10456,
		'EKOMED' => 10457,
		'ZISTAN' => 10458,
		'MARUNI' => 10459,
		'STACOSRL' => 10460,
		'DELPHIPOLAND' => 10461,
		'VTECHTUNNING' => 10462,
		'METSATISSUE' => 10463,
		'RESORREX' => 10464,
		'ORMAK' => 10465,
		'ROTA' => 10466,
		'BRIGHTSOLUTIONS' => 10467,
		'SHINNFU' => 10468,
		'VBG' => 10469,
		'INTERCARS' => 10470,
		'CONFEX' => 10471,
		'SOLIDEAL' => 10472,
		'RODCRAFT' => 10473,
		'ELHOS' => 10474,
		'SONY' => 10475,
		'VIP' => 10476,
		'ELIT' => 10477,
		'BAJTEL' => 10478,
		'KOSKISENOY' => 10479,
		'JANUSZSKIBA' => 10480,
		'LANDIRENZO' => 10481,
		'RYBAKI' => 10482,
		'POLGAS' => 10483,
		'TECHMARK' => 10484,
		'WHMTSIELCZAK' => 10485,
		'ZAMKABEL' => 10486,
		'BISTAR' => 10487,
		'ZMIEBROWSKI' => 10488,
		'PRINS' => 10489,
		'AMAX' => 10490,
		'GRODKYW' => 10491,
		'FAGUMIT' => 10492,
		'WERNER' => 10493,
		'PPHUGOMET' => 10494,
		'IZI' => 10495,
		'INGREMIO' => 10496,
		'888' => 10497,
		'BBG' => 10498,
		'EGR' => 10499,
		'ERISTIC' => 10500,
		'FANI' => 10501,
		'JFBK' => 10502,
		'KASHIYAMA' => 10503,
		'MUSASHI' => 10504,
		'RBI' => 10505,
		'RIKEN' => 10506,
		'SH' => 10507,
		'SUN' => 10508,
		'TAIHO' => 10509,
		'TOMASETTO' => 10510,
		'FAPA' => 10511,
		'AUTOTRAPER4X4' => 10512,
		'WISECOEUROPE' => 10513,
		'555' => 10514,
		'AAH' => 10515,
		'ACDELCO' => 10516,
		'CHERY' => 10517,
		'DENKI' => 10518,
		'DOKURO' => 10519,
		'HKT' => 10520,
		'KATO' => 10521,
		'MARUICHI' => 10522,
		'NAPCO' => 10523,
		'OSAKA' => 10524,
		'RD' => 10525,
		'RIMA' => 10526,
		'STONE' => 10527,
		'TAMA' => 10528,
		'TYG' => 10529,
		'WIRTGEN' => 10531,
		'NTSSPLKAZOO' => 10532,
		'TOP' => 10533,
		'FIAMM' => 10534,
		'AUGER' => 10535,
		'CERTOOLS' => 10536,
		'PIUSI' => 10537,
		'EMMEGAS' => 10538,
		'OMNI' => 10539,
		'BERAL' => 10540,
		'ELANDERS' => 10541,
		'SONIC' => 10542,
		'EMUMASTERPIECE' => 10543,
		'MICKEYTOMPSON' => 10544,
		'PJH' => 10545,
		'KAMELMAG' => 10546,
		'ELSIN' => 10547,
		'BENDPAK' => 10548,
		'MOTORONI' => 10549,
		'ROTARY' => 10550,
		'SPIMOTORISRL' => 10551,
		'LAUNCH' => 10552,
		'INLATUNING' => 10553,
		'LAKMA' => 10554,
		'BF' => 10555,
		'MANNFILTER' => 10556,
		'AEROLIFT' => 10557,
		'ANTEC' => 10558,
		'ATV' => 10559,
		'LOUIS' => 10560,
		'CHIEF' => 10561,
		'DECTANE' => 10562,
		'DW' => 10563,
		'FOLIATEC' => 10564,
		'GAMMAREIFEN' => 10565,
		'INPRO' => 10566,
		'RAID' => 10567,
		'REIFEN' => 10568,
		'RICHTER' => 10569,
		'ROMIK' => 10570,
		'RONDEL' => 10571,
		'SHOETLE' => 10572,
		'SCHWENKER' => 10573,
		'SPANGENBERG' => 10574,
		'SUMEX' => 10575,
		'TURBOLOADER' => 10576,
		'APA' => 10577,
		'ATERA' => 10578,
		'BURKERT' => 10579,
		'CLIMPARTS' => 10580,
		'DIONYSHOFMAN' => 10581,
		'DRWACK' => 10582,
		'DRESSELHAUS' => 10583,
		'FACOM' => 10584,
		'HR' => 10585,
		'HATCO' => 10586,
		'HIRSCHMANN' => 10587,
		'HOLTLLOYD' => 10588,
		'HORNBAUER' => 10589,
		'LEINA' => 10590,
		'MOLYKOTE' => 10591,
		'MOTAIR' => 10592,
		'NORDVLIES' => 10593,
		'OMNITECHNIK' => 10594,
		'REINOL' => 10595,
		'SANICO' => 10596,
		'SEBRING' => 10597,
		'SONAX' => 10598,
		'SPLINTEX' => 10599,
		'SUEDRAD' => 10600,
		'TEGUFA' => 10601,
		'TOPLAMP' => 10602,
		'VEGE' => 10603,
		'WD40' => 10604,
		'TEZUKA' => 10605,
		'BUCKERUNTERNEHMENSGRUPPE' => 10606,
		'INTEC' => 10607,
		'RINDER' => 10608,
		'ARVIN' => 10609,
		'ATA' => 10610,
		'HOF' => 10611,
		'HUR' => 10612,
		'NARVA' => 10613,
		'BALO' => 10614,
		'SEADOO' => 10615,
		'KALMAR' => 10616,
		'ETP' => 10617,
		'MAFI' => 10618,
		'MRK' => 10619,
		'KREISS' => 10620,
		'NTS' => 10621,
		'LUMAG' => 10622,
		'ACL' => 10623,
		'DTP' => 10624,
		'API' => 10625,
		'KING' => 10626,
		'MIBA' => 10627,
		'MECDIESEL' => 10628,
		'GLACIER' => 10629,
		'SZMETAL' => 10630,
		'REYCON' => 10631,
		'SEIM' => 10632,
		'DON' => 10633,
		'JAKOBSAUTOTEILE' => 10634,
		'CONTIS' => 10635,
		'FAE' => 10636,
		'KDP' => 10637,
		'KSP' => 10638,
		'KCW' => 10639,
		'TCM' => 10640,
		'BOSS' => 10641,
		'NONAME' => 10642,
		'DW' => 10643,
		'RIEGER' => 10644,
		'FKAUTOMOTIVE' => 10645,
		'NISSHINBO' => 10646,
		'VFM' => 10647,
		'UNION' => 10648,
		'LADOG' => 10649,
		'SANDTLER' => 10650,
		'NOK' => 10651,
		'DIESELTECHNIK' => 10652,
		'NIKKI' => 10653,
		'RIK' => 10654,
		'SEIWA' => 10655,
		'AKITAKA' => 10656,
		'VTR' => 10657,
		'MOBIS' => 10658,
		'THO' => 10659,
		'DIRECTPARTS' => 10660,
		'PITWORK' => 10661,
		'DRIVEJOY' => 10662,
		'MICRO' => 10663,
		'PMC' => 10664,
		'SAKURA' => 10665,
		'GIRLING' => 10666,
		'ROADSAFE' => 10667,
		'BAW' => 10668,
		'OHNO' => 10669,
		'HONDAMOTO' => 10670,
		'MOTORPRO' => 10671,
		'MIYACO' => 10672,
		'MOUNTAIN' => 10673,
		'ADVICS' => 10674,
		'JNBK' => 10675,
		'DINGCHUNG' => 10676,
		'SUZUKIMOTO' => 10677,
		'NINGBO' => 10678,
		'CHERRY' => 10679,
		'HARLEYDAVIDSON' => 10680,
		'PARTSPROFE' => 10681,
		'NAKAMOTO' => 10682,
		'XC' => 10683,
		'QSTEN' => 10684,
		'TEKNOROT' => 10685,
		'HANSE' => 10686,
		'BESER' => 10687,
		'ALLIEDNIPPON' => 10688,
		'HAMP' => 10689,
		'FENOX' => 10690,
		'TUCKERROCKY' => 10691,
		'GLOBAL' => 10692,
		'BLACKBELT' => 10693,
		'ARCTICCAT' => 10694,
		'CHASSISPRO' => 10695,
		'AFA' => 10696,
		'SANGSIN' => 10697,
		'CARDONE' => 10698,
		'IPD' => 10699,
		'NOVA' => 10700,
		'NIBK' => 10701,
		'ASAHI' => 10702,
		'LUCID' => 10703,
		'MASUMA' => 10704,
		'STELLOX' => 10705,
		'PEKO' => 10706,
		'STANT' => 10707,
		'TOYOGUARD' => 10708,
		'AQUILSTAR' => 10709,
		'TOYOPOWER' => 10710,
		'TANAKI' => 10711,
		'JANMOR' => 10712,
		'RTS' => 10713,
		'SFEC' => 10714,
		'VEMA' => 10715,
		'POLARIS' => 10716,
		'SUBAKI' => 10717,
		'TERADA' => 10718,
		'CROSSCANADA' => 10719,
		'TAYEN' => 10720,
		'TJB' => 10721,
		'NISSANDIESEL' => 10722,
		'OZEKI' => 10723,
		'QTOP' => 10724,
		'KINMA' => 10725,
		'ARS' => 10726,
		'GTR' => 10727,
		'FEBEST' => 10728,
		'TSN' => 10729,
		'TONGYANG' => 10730,
		'TOCHKAOPORI' => 10731,
		'HYUNDAIGALLOPER' => 10732,
		'WAI' => 10733,
		'NAC' => 10734,
		'AKYOTO' => 10735,
		'NEWSUN' => 10736,
		'SEINSA' => 10737,
		'TOPFILS' => 10738,
		'SERVA' => 10739,
		'IKA' => 10740,
		'ORUM' => 10741,
		'BOBCAT' => 10742,
		'RAP' => 10743,
		'ANCO' => 10744,
		'TORQUE' => 10745,
		'DL' => 10746,
		'TERMAL' => 10747,
		'AIKO' => 10748,
		'SHINKO' => 10749,
		'MALO' => 10750,
		'JP' => 10751,
		'HOLZER' => 10752,
		'KAPARS' => 10753,
		'DJB' => 10754,
		'LMI' => 10755,
		'GORDON' => 10756,
		'HOSHI' => 10757,
		'MANNOL' => 10758,
		'BCA' => 10759,
		'PIMAX' => 10760,
		'EAGLEEYES' => 10761,
		'TKD' => 10762,
		'FOMAR' => 10763,
		'NAGS' => 10764,
		'JROCKY' => 10765,
		'NFILTER' => 10766,
		'CANAM' => 10767,
		'ART' => 10768,
		'KLAXCAR' => 10769,
		'ETF' => 10770,
		'RECORD' => 10771,
		'FRITECH' => 10772,
		'TOKAI' => 10773,
		'SUMITOMO' => 10774,
		'PATRON' => 10775,
		'CROWN' => 10776,
		'SPICER' => 10777,
		'OBK' => 10778,
		'BGF' => 10779,
		'ANCHOR' => 10780,
		'BJS' => 10781,
		'TW' => 10782,
		'KELIJIE' => 10783,
		'DPH' => 10784,
		'VOLVOTRUCK' => 10785,
		'FEITUO' => 10786,
		'AUTOLITE' => 10787,
		'PRECISION' => 10788,
		'NEAPCO' => 10789,
		'AUTOKOOL' => 10790,
		'STORKRUBBER' => 10791,
		'GOODWILL' => 10792,
		'GHIBAUDI' => 10793,
		'LAUBER' => 10794,
		'GIEFFE' => 10795,
		'USM' => 10796,
		'JOBBER' => 10797,
		'BK' => 10798,
		'GRANDPRIX' => 10799,
		'GREATWALL' => 10800,
		'GQ' => 10801,
		'FELPRO' => 10802,
		'KOITO' => 10803,
		'WUNDER' => 10804,
		'CEVAM' => 10805,
		'HLC' => 10806,
		'AMP' => 10807,
		'DONGIL' => 10808,
		'HCC' => 10809,
		'ILJIN' => 10810,
		'KEUKDONG' => 10811,
		'DOOHAP' => 10813,
		'DOOWON' => 10814,
		'FRIXA' => 10815,
		'HAC' => 10817,
		'KAFUS' => 10818,
		'SECO' => 10819,
		'KAGER' => 10820,
		'FANTUZZI' => 10821,
		'SLP' => 10822,
		'KRONPRINZ' => 10823,
		'KAP' => 10824,
		'YAMATO' => 10825,
		'BESTF1TS' => 10826,
		'GISTORNE' => 10827,
		'YULIM' => 10828,
		'KBC' => 10829,
		'TCIC' => 10830,
		'INZI' => 10831,
		'AUTOTOP' => 10832,
		'POONGSUNG' => 10833,
		'DYC' => 10834,
		'YPR' => 10835,
		'DONGNAM' => 10836,
		'GEUNYOUNG' => 10837,
		'KGC' => 10838,
		'SAMSUNG' => 10839,
		'ASIMCO' => 10840,
		'BW' => 10841,
		'IZUMI' => 10842,
		'HSC' => 10843,
		'SMV' => 10844,
		'KOYORAD' => 10845,
		'CRYOMAX' => 10846,
		'TOYO' => 10847,
		'SABAH' => 10848,
		'VALEOPHC' => 10849,
		'CENTURY' => 10850,
		'MILOTEC' => 10851,
		'AXLETECH' => 10852,
		'BBC' => 10853,
		'ANAM' => 10854,
		'FIC' => 10855,
		'HASAKI' => 10856,
		'OSK' => 10857,
		'ARP' => 10858,
		'ADR' => 10859,
		'NKK' => 10860,
		'JAKOPARTS' => 10861,
		'THERMOTEC' => 10862,
		'WOKING' => 10863,
		'JAPANCARS' => 20000,
		'POLCAR' => 20001,
		'TVH' => 20002,
		'INFAC' => 20004,
		'KF' => 20005,
		'NOVLINE' => 20006,
		'TOPRAN' => 20007,
		'KRAUF' => 20008,
		'FORTUNELINE' => 20009,
		'HVP' => 20010,
		'SHARK' => 20011,
		'ABE' => 20012,
		'FPS' => 20013,
		'MCB' => 20014,
		'ADG' => 20015,
		'AIRTECH' => 20016,
		'CARDEX' => 20017,
		'HAN' => 20018,
		'KOS' => 20020,
		'MX' => 20021,
		'PYUNGHWA' => 20022,
		'NISSIN' => 20023,
		'NOLANHELMETS' => 20024,
		'ONNURI' => 20025,
		'GEELY' => 20026,
		'AUTLOG' => 20027,
		'MAXGEAR' => 20028,
		'KTM' => 20029,
		'PROTTEGO' => 20030,
		'TOWAI' => 20031,
		'KMGERMANY' => 20032,
		'TRIFA' => 20033,
		'SCHNIEDER' => 20034,
		'TAS' => 20035,
		'TRILEX' => 20036,
		'TRUCKTECHNIC' => 20037,
		'CIGUENALESSANZ' => 20038,
		'FKC' => 20039,
		'TADANO' => 20040,
		'AP' => 20041,
		'DAEWHA' => 20042,
		'ETG' => 20043,
		'FLAG' => 20045,
		'JAHN' => 20046,
		'JSASAKASHI' => 20047,
		'STOCKAMSEL' => 20048,
		'AUTOPAL' => 20049,
		'UNIPOINT' => 20050,
		'REPLICA' => 20051,
		'AYFAR' => 20052,
		'LIFAN' => 20053,
		'PARTSMALL' => 20054,
		'NTY' => 20055,
		'BATPARTS' => 20056,
		'KOREASTAR' => 20057,
		'INTERPARTS' => 20058,
		'TENACITY' => 20059,
		'DENCKERMANN' => 20060,
		'TASHIKO' => 20061,
		'ASIA360' => 20062,
		'ALGO' => 20063,
		'ATHENA' => 20064,
		'BIZOL' => 20065,
		'BLACKTECH' => 20066,
		'CAROL' => 20067,
		'CHIARAVALLI' => 20068,
		'CRAFT' => 20069,
		'EMGO' => 20070,
		'ESSO' => 20071,
		'ETENGINETEAM' => 20072,
		'FORCE' => 20073,
		'GENERALRICAMBI' => 20074,
		'GYS' => 20075,
		'HEKRA' => 20076,
		'HPX' => 20077,
		'INTELLI' => 20078,
		'JURATEK' => 20079,
		'KLARIUS' => 20080,
		'KOREA' => 20081,
		'LSGERMANY' => 20082,
		'MAGNETON' => 20083,
		'MFILTER' => 20084,
		'MIKALOR' => 20085,
		'MORSE' => 20086,
		'PEWAG' => 20087,
		'PRESSOL' => 20088,
		'SANMATCH' => 20089,
		'SAPP' => 20090,
		'SEDZISZOW' => 20091,
		'STARLINE' => 20092,
		'SUNMATCH' => 20093,
		'TECNODELTA' => 20094,
		'TOKOCARS' => 20095,
		'TONGRUN' => 20096,
		'VATOIL' => 20097,
		'VIKA' => 20098,
		'WYNNS' => 20099,
		'XINYI' => 20100,
		'ICOR' => 20101,
		'SEKURIT' => 20102,
		'PILKINGTON' => 20103,
		'AND' => 20104,
		'ABESTA' => 20105,
		'AISAN' => 20106,
		'BRITPART' => 20107,
		'BRP' => 20108,
		'CADA' => 20109,
		'DORMAN' => 20110,
		'DREIK' => 20111,
		'EBCBRAKES' => 20112,
		'FBL' => 20113,
		'FIRAD' => 20114,
		'KEYSTER' => 20115,
		'KG' => 20116,
		'KGK' => 20117,
		'M2' => 20118,
		'NT' => 20119,
		'OMEGA' => 20120,
		'PIAA' => 20121,
		'RITCO' => 20122,
		'SABO' => 20123,
		'SCANTECH' => 20124,
		'SHIMAHIDE' => 20125,
		'SK' => 20126,
		'STARKE' => 20127,
		'TBK' => 20128,
		'SUREFILTER' => 20129,
		'YCC' => 20130,
		'ERT' => 20131,
		'AGA' => 20132,
		'KFLEX' => 20133,
		'TONGHONG' => 20134,
		'TIK' => 20135,
		'VITON' => 20136,
		'ARCO' => 20137,
		'MOTREX' => 20138,
		'MBS' => 20139,
		'TDC' => 20140,
		'UNISOL' => 20141,
		'FBK' => 20142,
		'JAGO' => 20143,
		'KANSAI' => 20144,
		'TOTO' => 20145,
		'GLOBER' => 20146,
		'GSP' => 20147,
		'MOPISAN' => 20148,
		'ABAKUS' => 20149,
		'KK' => 20150,
		'DAFMI' => 20151,
		'ALPHAFILTER' => 20152,
		'AT' => 20153,
		'APLUS' => 20154,
		'BRISK' => 20155,
		'PRIMA' => 20156,
		'PILENGA' => 20157,
		'STARTECH' => 20158,
		'NTD' => 20159,
		'LUZAR' => 20160,
		'MARIOGHIBAUDI' => 20161,
		'MOTORHERZ' => 20162,
		'ORME' => 20163,
		'TRANSPO' => 20164,
		'ZM' => 20165,
		'MJ' => 20166,
		'PE' => 20167,
		'TEMPLIN' => 20168,
		'FESTO' => 20169,
		'SAMPA' => 20170,
		'SIGNEDA' => 20171,
		'METGUM' => 20172,
		'METALCAUCHO' => 20173,
		'AUTOTECHTEILE' => 20174,
		'CSGERMANY' => 20175,
		'MAGNUMTECHNOLOGY' => 20176,
		'KAMOKA' => 20177,
		'ARNOTT' => 20178,
		'SAIC' => 20179,
		'SBF' => 20180,
		'BSG' => 20181,
		'MAPA' => 20182,
		'BYD' => 20183,
		'PROFIT' => 20184,
		'GPDF' => 20185,
		'GP' => 20186,
		'FORMPART' => 20187,
		'BESF1TS' => 20188,
		'DPI' => 20189,
		'KRAFTAUTOMOTIVE' => 20190,
		'ROTINGER' => 20191,
		'FRICTIONMASTER' => 20192,
		'ALCA' => 20193,
		'PERSEA' => 20194,
		'FRENKIT' => 20195,
		'FA1' => 20196,
		'ACHR' => 20197,
		'COMMA' => 20198,
		'STILLEN' => 20199,
		'BGA' => 20200,
		'GEN' => 20201,
		'ZHIREX' => 20202,
		'RIBUKO' => 20203,
		'POLMOSTROW' => 20204,
		'DEXWAL' => 20205,
		'FAI' => 20206,
		'MISFAT' => 20207,
		'NEXUS' => 20208,
		'STC' => 20209,
		'CTI' => 20210,
		'TANGUN' => 20211,
		'YMBTECH' => 20212,
		'KIMIKO' => 20213,
		'CHANA' => 20214,
		'PULLSON' => 20215,
		'TOCHKAOPORU' => 20216,
		'AMC' => 20217,
		'AUTOSTARTER' => 20218,
		'ERREVI' => 20219,
		'JMJ' => 20220,
		'METEOR' => 20221,
		'YATO' => 20222,
		'LINEX' => 20223,
		'BLIC' => 20224,
		'BTA' => 20225,
		'KROSNO' => 20226,
		'GALFER' => 20227,
		'STR' => 20228,
		'BOLL' => 20229,
		'BORSEHUNG' => 20230,
		'BOSMA' => 20231,
		'CENTAURO' => 20232,
		'CELMA' => 20233,
		'HUF' => 20234,
		'OSRAV' => 20235,
		'SM' => 20236,
		'BORGECOTERM' => 20238,
		'CAVO' => 20239,
		'HATTAT' => 20240,
		'VIEWMAX' => 20241,
		'ROTWEISS' => 20242,
		'EXPERTLINE' => 20243,
		'TNB' => 20244,
		'BCGUMA' => 20245,
		'GENERALELECTRIC' => 20246,
		'ASM' => 20247,
		'SAT' => 20248,
		'CURE' => 20249,
		'HSB' => 20250,
		'FOBOS' => 20251,
		'MARMOT' => 20252,
		'DUCATI' => 20253,
		'BEGELGERMANY' => 20254,
		'SERTPLAS' => 20255,
		'MERCANCONSAN' => 20256,
		'OPOLTRANS' => 20257,
		'YUMAK' => 20258,
		'SBP' => 20259,
		'CELIKYAY' => 20260,
		'DOSEMENLER' => 20261,
		'MAJORSELL' => 20262,
		'EUROTECH' => 20263,
		'SEMLASTIK' => 20264,
		'TRUCKEXPERT' => 20265,
		'REPA' => 20266,
		'VADEN' => 20267,
		'WINKLER' => 20268,
		'JILONG' => 20269,
		'ATECH' => 20270,
		'GKP' => 20271,
		'FERSA' => 20272,
		'EREN' => 20273,
		'YETSAN' => 20274,
		'KORMAS' => 20275,
		'WUHLERMANN' => 20276,
		'CONTINUAL' => 20277,
		'KRD' => 20278,
		'GMW' => 20279,
		'KANCA' => 20280,
		'MAYSANMANDO' => 20281,
		'TRANSPART' => 20282,
		'LYNX' => 20283,
		'EUROKLIMA' => 20284,
		'MKFILTER' => 20285,
		'DOLPHIN' => 20286,
		'BMCATALYSTS' => 20287,
		'BYPART' => 20288,
		'CF' => 20289,
		'KONCEPTIS' => 20290,
		'NIERMANN' => 20291,
		'RNL' => 20293,
		'SANTECH' => 20294,
		'STEMOT' => 20295,
		'UTM' => 20296,
		'WOODUK' => 20297,
		'ZNP' => 20298,
		'WINBO' => 20299,
		'ENEOS' => 20300,
		'SEINTEX' => 20301,
		'MOTODOR' => 20302,
		'PMATOOLS' => 20303,
		'YOKKI' => 20304,
		'PERMATEX' => 20305,
		'ENGANCHESARAGON' => 20306,
		'PENTOSIN' => 20307,
		'CROLDINO' => 20308,
		'AUTOSOL' => 20309,
		'HEYNER' => 20310,
		'ZIC' => 20311,
		'WEEN' => 20312,
		'KSTOOLS' => 20313,
		'HIGEAR' => 20314,
		'KFZSTAHLRAD' => 20315,
		'NORPLAST' => 20316,
		'SHERIFF' => 20317,
		'AIRLINE' => 20318,
		'BP' => 20319,
		'PARKMASTER' => 20320,
		'NGN' => 20321,
		'RIDER' => 20322,
		'TOMEX' => 20323,
		'GOODREM' => 20324,
		'DAIDOMETAL' => 20325,
		'DIAMOND' => 20326,
		'FJTECH' => 20327,
		'FPI' => 20328,
		'HEC' => 20329,
		'IJK' => 20330,
		'INCOE' => 20331,
		'JBS' => 20332,
		'MAXPART' => 20333,
		'NIKOYO' => 20334,
		'SANYCO' => 20335,
		'SAU' => 20336,
		'TOA' => 20337,
		'YM' => 20338,
		'FREMAX' => 20339,
		'3RG' => 20340,
		'AUTOMOTORFRANCE' => 20341,
		'DPA' => 20342,
		'LECOY' => 20343,
		'NEWCRE' => 20344,
		'BESEKA' => 20345,
		'EMMERRE' => 20346,
		'PERMAFUSE' => 20347,
		'SAMKO' => 20348,
		'SPESSO' => 20349,
		'JIKIU' => 20350,
		'VECAMARTI' => 20351,
		'AUTOPARTS' => 20352,
		'LOOP' => 20353,
		'ASMETAL' => 20354,
		'RIW' => 20355,
		'QFIX' => 20356,
		'AILERON' => 20357,
		'AUTOCLOVER' => 20358,
		'LAVITA' => 20359,
		'PETEX' => 20360,
		'VOREL' => 20361,
		'ZPV' => 20362,
		'AD' => 20363,
		'FITSHI' => 20364,
		'DPGROUP' => 20365,
		'EMMETEC' => 20366,
		'MSG' => 20367,
		'TCS' => 20368,
		'NAK' => 20369,
		'CFW' => 20370,
		'ROLF' => 20371,
		'DELSAFILTER' => 20372,
		'ETS' => 20373,
		'SHAFER' => 20374,
		'CASTER' => 20375,
		'POWERFRICTION' => 20376,
		'POWERSTOP' => 20377,
		'DAEDONG' => 20378,
		'TORK' => 20379,
		'ECOGOLD' => 20380,
		'MASTERSPORT' => 20381,
		'BALATON' => 20382,
		'JRONE' => 20383,
		'CZ' => 20384,
		'NIITSU' => 20385,
		'BORGWARNER' => 20386,
		'SHINOBI' => 20387,
		'ASAM' => 20388,
		'PASCAL' => 20389,
		'NIPPONMOTORS' => 20390,
		'DOMINANT' => 20391,
		'KORTEX' => 20392,
		'VPM' => 20393,
		'CAFFARO' => 20394,
		'XADO' => 20395,
		'LUKOIL' => 20396,
		'TOTACHI' => 20397,
		'RICAMBIFLEX' => 20398,
		'RANCHO' => 20399,
		'ASIAN' => 20400,
		'DRK' => 20401,
		'SOLGY' => 20402,
		'HDE' => 20403,
		'BODYPARTS' => 20404,
		'NGBRAKE' => 20406,
		'AGC' => 20407,
		'KMKGLASS' => 20408,
		'SAILING' => 20409,
		'XYG' => 20410,
		'HIQ' => 20411,
		'FRIGAIR' => 20412,
		'OYODO' => 20413,
		'REPLAY' => 20414,
		'ZEKKERT' => 20415,
		'NAKAYAMA' => 20416,
		'SWP' => 20417,
		'DAEJIN' => 20418,
		'AKKARDAN' => 20419,
		'AKERSAN' => 20420,
		'ASPAR' => 20421,
		'ATF' => 20422,
		'ATY' => 20423,
		'AVTOSTANDART' => 20424,
		'AYD' => 20425,
		'BELGUMPARTS' => 20426,
		'BRECK' => 20427,
		'DACO' => 20428,
		'EUROREPAR' => 20429,
		'FANEX' => 20430,
		'GB' => 20431,
		'HEXEN' => 20432,
		'JBM' => 20433,
		'JUST' => 20434,
		'K2' => 20435,
		'KAMPOL' => 20436,
		'KAPIMSAN' => 20437,
		'MARS' => 20438,
		'MAXXUS' => 20439,
		'MOTUS' => 20440,
		'MTM' => 20441,
		'OEGERMANY' => 20442,
		'OPAR' => 20443,
		'REDAT' => 20444,
		'STR' => 20445,
		'SVAC' => 20446,
		'TACLAR' => 20447,
		'UCEL' => 20448,
		'WENDERPARTS' => 20449,
		'SPEEDMATE' => 20450,
		'TRC' => 20451,
		'MELETT' => 20452,
		'GENON' => 20453,
		'VICMA' => 20454,
		'JURGENLIEBISCH' => 20455,
		'TANGDE' => 20456,
		'MOTORQUALITY' => 20457,
		'OSSCA' => 20458,
		'TEMPEST' => 20459,
		'TOPTUL' => 20460,
		'KENDALL' => 20461,
		'CNC' => 20462,
		'REPSOL' => 20463,
		'JPN' => 20464,
		'MECARM' => 20465,
		'SASSONE' => 20466,
		'SIMER' => 20467,
		'BROTHERSTAR' => 20468,
		'CDN' => 20469,
		'MOGEN' => 20470,
		'KONNER' => 20471,
		'CHANABENNI' => 20472,
		'FAW' => 20473,
		'ASPL' => 20474,
		'BRILLIANCE' => 20475,
		'AGAUTOPARTS' => 20476,
		'OLEOBLITZ' => 20477,
		'SUNOCO' => 20478,
		'JTMOTO' => 20479,
		'PROPLAST' => 20480,
		'NEWLABEL' => 20481,
		'UC' => 20482,
		'CARFACE' => 20483,
		'TYLL' => 20484,
		'POWERFLEX' => 20485,
		'TOURMAX' => 20486,
		'FERDUS' => 20487,
		'DOROZNAYAKARTA' => 20488,
		'SHINHWA' => 20489,
		'BRECKNER' => 20490,
		'APPLUS' => 20491,
		'DOKUJI' => 20492,
		'RKRAFT' => 20493,
		'4CAR' => 20494,
		'KINGTONY' => 20495,
		'BORGAUTOMOTIVE' => 20496,
		'RMS' => 20497,
		'CONDOR' => 20498,
		'RYMEC' => 20499,
		'DEZENT' => 20500,
		'QUARO' => 20501,
		'TURBOMOTOR' => 20502,
		'QUATTROFRENI' => 20503,
		'FOTON' => 20504,
		'GUD' => 20505,
		'KROSS' => 20506,
		'DYS' => 20507,
		'NSP' => 20508,
		'REZAWPLAST' => 20509,
		'AMIWA' => 20510,
		'JAPKO' => 20511,
		'NPS' => 20512,
		'HASTINGS' => 20513,
		'TOHATSU' => 20514,
		'AUTOATTEX' => 20515,
		'SIERRA' => 20516,
		'ASP' => 20517,
		'HACO' => 20518,
		'IZAWIT' => 20519,
		'AUTOTEILE' => 20520,
		'LCC' => 20521,
		'NEWTECHALFA' => 20522,
		'IKO' => 20523,
		'ITR' => 20524,
		'CASP' => 20525,
		'MEYER' => 20526,
		'MVPARTS' => 20527,
		'MUGEN' => 20528,
		'MATSUKO' => 20529,
		'STANLEY' => 20530,
		'SPK' => 20531,
		'NISSMO' => 20532,
		'RUBER' => 20533,
		'KOBELCO' => 20534,
		'LEX' => 20535,
		'WERTTEILE' => 20536,
		'TOYA' => 20537,
		'MARIX' => 20538,
		'STATIM' => 20539,
		'AUTOWELT' => 20540,
		'AMD' => 20541,
		'RIVAL' => 20542,
		'RUEI' => 20543,
		'TRIALLI' => 20544,
		'PACOL' => 20545,
		'JONNESWAY' => 20546,
		'VENEPORTE' => 20547,
		'YENMAK' => 20548,
		'DONGFENG' => 20549,
		'GBRAKE' => 20550,
		'NTP' => 20551,
		'SEM' => 20552,
		'PNEUMATIC' => 20553,
		'RAPRO' => 20554,
		'FAKROSNO' => 20555,
		'PROTECHNIC' => 20556,
		'HAFEI' => 20557,
		'ARIRANG' => 20558,
		'4RIDE' => 20559,
		'FCORE' => 20560,
		'JT' => 20561,
		'MAMMOOTH' => 20562,
		'SCHOMACKER' => 20563,
		'ZZVF' => 20564,
		'ERGON' => 20565,
		'DEPPUL' => 20566,
		'MAXISPARTS' => 20567,
		'4U' => 20568,
		'MILES' => 20569,
		'JUSTDRIVE' => 20570,
		'DYNAMATRIX' => 20571,
		'FBJ' => 20572,
		'IKOMA' => 20573,
		'SKT' => 20574,
		'SIDAT' => 20575,
		'NORMA' => 20576,
		'UDTRUCKS' => 20577,
		'LEMSON' => 20578,
		'RUPARTS' => 20579,
		'BENSON' => 20580,
		'MARSHALL' => 20581,
		'HB' => 20582,
		'JTC' => 20583,
		'BERGKRAFT' => 20584,
		'PROTECH' => 20585,
		'BEARMACH' => 20586,
		'FIT' => 20587,
		'TOPIC' => 20588,
		'RAINX' => 20589,
		'JPM' => 20590,
	);
	return intval($IdByBrand[$BKey]);
}
?>