jQuery(document).ready(function ($) {

    function updateProductIdentifier() {

        var identifier = $('[name=custom_permalinks_product_identifier]:checked').val() === 'default' ? 'product-slug' : 'SKU';

        $('[data-product-identifier]').text(identifier);
    }

    function updateProductPath() {
        var product_path = jQuery('[name=custom_permalinks_product_permalink]:checked').siblings('p').find('code').html();

        jQuery('[data-product-path]').html(product_path);
    }

    function updateCategoryPath() {
        var product_path = jQuery('[name=custom_permalinks_category_permalink]:checked').siblings('p').find('code').html();

        jQuery('[data-category-path]').html(product_path);
    }

    jQuery(":input").inputmask();

    $('[data-ending-field]').on('input', function () {
        $('[data-url-ending]').text($(this).val());
    });

    jQuery('[name=custom_permalinks_product_permalink]').on('change', updateProductPath);
    jQuery('[name=custom_permalinks_product_identifier]').on('change', updateProductIdentifier);
    jQuery('[name=custom_permalinks_category_permalink]').on('change', updateCategoryPath);

    updateProductPath();
    updateCategoryPath();
    updateProductIdentifier();
});