<?php use WooPlugins\Permalinks\PermalinksPlugin;

if ( ! defined( 'WPINC' ) ) {
	die;
}

require_once plugin_dir_path( __FILE__ ) . 'vendor/autoload.php';

/**
 *
 * Plugin Name:       Custom Permalinks for WooCommerce
 * Plugin URI:        https://meow-crew.com
 * Description:       A simple way to get rid of any excess parts of permalinks and create pretty URLs for your products and categories.
 * Version:           1.2.0
 * Author:            Meow Crew
 * Author URI:        https://meow-crew.com
 * License:           GPL-2.0+
 * License URI:       http://www.gnu.org/licenses/gpl-2.0.txt
 * Text Domain:       custom-permalinks-for-woocommerce
 * Domain Path:       /languages
 *
 * Woo: 7938028:71d572539c444d111787a823f1158c26
 *
 * WC requires at least: 4.0.0
 * WC tested up to: 5.9.0
 */

$customPermalinksForWooCommercePlugin = new PermalinksPlugin( __FILE__ );

$customPermalinksForWooCommercePlugin->run();

register_activation_hook( __FILE__, array( $customPermalinksForWooCommercePlugin, 'activate' ) );

register_deactivation_hook( __FILE__, array( $customPermalinksForWooCommercePlugin, 'deactivate' ) );

register_uninstall_hook( __FILE__, array( PermalinksPlugin::class, 'uninstall' ) );


