<?php namespace WooPlugins\Permalinks\Services;

class FlushService {

	const FLUSH_OPTION_KEY = 'custom_permalinks_needs_be_flushed';

	public function __construct() {

		$flushActions = array(
			'created_product_cat',
			'edited_product_cat',
			'delete_product_cat',

			'created_product_tag',
			'edited_product_tag',
			'delete_product_tag',
		);

		foreach ( $flushActions as $action ) {
			add_action( $action, self::class . '::setFlushRules' );
		}

		add_action( 'shutdown', array( $this, 'flushRules' ) );
	}

	public static function setFlushRules() {
		update_option( self::FLUSH_OPTION_KEY, true );
	}

	public function flushRules() {
		if ( get_option( self::FLUSH_OPTION_KEY ) ) {
			flush_rewrite_rules();
			delete_option( self::FLUSH_OPTION_KEY );
		}
	}
}
