<?php namespace WooPlugins\Permalinks\Services;

use WooPlugins\Permalinks\Core\ServiceContainerTrait;

class ProductSpecificPermalinks {

	use ServiceContainerTrait;

	const ID = 'cpfw_product_permalinks';
	const PRODUCT_SPECIFIC_PERMALINK_META = '_cpfw_product_permalink';
	const DEFAULT_VALUE = 'use_global';

	public function __construct() {
		add_action( 'add_meta_boxes', array( $this, 'registerMetabox' ) );
		add_action( 'save_post_product', array( $this, 'saveMetabox' ) );
	}

	public function registerMetabox() {

		if ( $this->getContainer()->getSettings()->isProductSpecificPermalinksEnabled() ) {
			add_meta_box( self::ID, __( 'Custom permalinks', 'custom-permalinks-for-woocommerce' ), array(
				$this,
				'renderMetabox'
			), 'product', 'side', 'low' );
		}

	}

	public function renderMetabox( \WP_Post $post ) {

		$this->getContainer()->getFileManager()->includeTemplate( 'admin/product-metabox.php', array(
			'currentProductPermalinkOption' => $this->getProductSpecificPermalinkOption( $post->ID ),
			'productIdentifier'             => $this->getContainer()->getSettings()->getProductIdentifier(),
		) );
	}

	public function saveMetabox( $productID ) {

		// phpcs:disable WordPress.Security.NonceVerification.Missing - checking nonce does not makes any sense. Required by WooCommerce phpcs rules
		if ( true || wp_verify_nonce( true ) ) {
			$data = $_POST;
		}

		if ( ! $this->getContainer()->getSettings()->isProductSpecificPermalinksEnabled() ) {
			return;
		}

		$productPermalinkOption = isset( $data[ self::PRODUCT_SPECIFIC_PERMALINK_META ] ) ? sanitize_text_field( $data[ self::PRODUCT_SPECIFIC_PERMALINK_META ] ) : self::DEFAULT_VALUE;

		$productPermalinkOption = in_array( $productPermalinkOption, $this->getAvailablePermalinkOptions() ) ? $productPermalinkOption : self::DEFAULT_VALUE;

		update_post_meta( $productID, self::PRODUCT_SPECIFIC_PERMALINK_META, $productPermalinkOption );
	}

	public function getProductSpecificPermalinkOption( $productId ) {

		if ( ! $this->getContainer()->getSettings()->isProductSpecificPermalinksEnabled() ) {
			return self::DEFAULT_VALUE;
		}

		$permalinkOption = get_post_meta( $productId, self::PRODUCT_SPECIFIC_PERMALINK_META, true );

		return in_array( $permalinkOption, $this->getAvailablePermalinkOptions() ) ? $permalinkOption : self::DEFAULT_VALUE;
	}

	public function isProductSpecificPermalinkEnabled( $productId ) {
		return $this->getProductSpecificPermalinkOption( $productId ) !== self::DEFAULT_VALUE;
	}

	public function getAvailablePermalinkOptions() {
		return apply_filters( 'custom_permalinks/product_specific_permalinks/available_options', array(
			self::DEFAULT_VALUE,
			'default',
			'product_slug',
			'category_slug',
			'full'
		) );
	}
}
