<?php namespace WooPlugins\Permalinks\Settings;

use WooPlugins\Permalinks\Core\ServiceContainerTrait;

class PermalinkRadioOption {

	use ServiceContainerTrait;

	const FIELD_TYPE = 'custom_permalinks_radio';

	public function __construct() {
		add_action( 'woocommerce_admin_field_' . self::FIELD_TYPE, array( $this, 'render' ) );
	}

	public function render( $value ) {
		$option_value         = $value['value'];
		$value['description'] = ! empty( $value['description'] ) ? $value['description'] : '';
		?>
		<tr valign="top">
			<th scope="row" class="titledesc">
				<label for="<?php echo esc_attr( $value['id'] ); ?>"><?php echo esc_html( $value['title'] ); ?>
					<?php
					if ( ! empty( $value['desc_tip'] ) ) {
						echo wc_help_tip( $value['desc_tip'] );
					}
					?>
				</label>
			</th>
			<td class="forminp forminp-<?php echo esc_attr( sanitize_title( $value['type'] ) ); ?>">
				<fieldset>
					<?php echo esc_attr( $value['description'] ); ?>
					<ul style="margin-top: 3px">
						<?php foreach ( $value['options'] as $key => $val ) : ?>

							<li>
								<label>
									<input name="<?php echo esc_attr( $value['id'] ); ?>"
										   value="<?php echo esc_attr( $key ); ?>"
										   type="radio"
										   style="<?php echo esc_attr( $value['css'] ); ?>"
										   class="<?php echo esc_attr( $value['class'] ); ?>"
										<?php checked( $key, $option_value ); ?>
									/>
									<?php
									echo esc_html( $val['label'] );
									if ( 'default' === $key && Settings::SETTINGS_PREFIX . 'category_permalink' === $value['id'] ) {
										echo wc_help_tip( __( 'In case you use second level categories, you\'ll find additional /parent-category/ slug in the path, right before /category/ slug', 'custom-permalinks-for-woocommerce' ) );
									}
									if ( ! empty( $val['description'] ) ) :
										?>
										<p>
											<code>
												<?php

												if ( ! empty( $value['product_identifier'] ) ) :
													?>
													<span><?php echo esc_html( $val['description'] ); ?></span><span
														data-product-identifier><?php echo esc_html( $value['product_identifier'] ); ?>
													</span>
												<?php else : ?>
													<span><?php echo esc_html( $val['description'] ); ?></span>
												<?php endif; ?>
											</code>
										</p>
									<?php endif; ?>
								</label>
							</li>

						<?php endforeach; ?>
					</ul>
				</fieldset>
			</td>
		</tr>
		<?php
	}
}
