<?php namespace WooPlugins\Permalinks\Settings;

use WooPlugins\Permalinks\Core\ServiceContainerTrait;

class URLEndingOption {

	use ServiceContainerTrait;

	const FIELD_TYPE = 'custom_permalinks_url_ending';

	public function __construct() {
		add_action( 'woocommerce_admin_field_' . self::FIELD_TYPE, array( $this, 'render' ) );
	}

	public function render( $value ) {

		$option_value = $this->getContainer()->getSettings()->sanitizeURLEnding( (array) $value['value'] );

		$value['description'] = ! empty( $value['description'] ) ? $value['description'] : '';

		$product_permalink  = $value['product_permalink'];
		$category_permalink = $value['category_permalink'];

		?>
		<tr valign="top">
			<th scope="row" class="titledesc">
				<label for="<?php echo esc_attr( $value['id'] ); ?>"><?php echo esc_html( $value['title'] ); ?>
					<?php echo wc_help_tip( $value['desc_tip'] ); ?></label>
			</th>
			<td class="forminp forminp-<?php echo esc_attr( sanitize_title( $value['type'] ) ); ?>">
				<fieldset>
					<?php echo esc_attr( $value['description'] ); ?>
					<ul style="margin-top: 3px">
						<li>
							<input type="text" data-inputmask="'mask': '.[*{1,10}]'" style="width: 200px;"
								   data-ending-field id="<?php echo esc_attr( $value['id'] ); ?>[ending]"
								   name="<?php echo esc_attr( $value['id'] ); ?>[ending]"
								   value="<?php echo esc_attr( $option_value['ending'] ); ?>">
						</li>
						<li>
							<label for="<?php echo esc_attr( $value['id'] ); ?>[enable_product]">
								<input type="checkbox" <?php checked( $option_value['enable_product'], 'yes' ); ?>
									   id="<?php echo esc_attr( $value['id'] ); ?>[enable_product]"
									   name="<?php echo esc_attr( $value['id'] ); ?>[enable_product]" value="yes">
								<?php esc_html_e( 'Enable for products', 'custom-permalinks-for-woocommerce' ); ?>
								<p>
									<?php
									$product_path = 'product/';
									switch ( $product_permalink ) {
										case 'product_slug':
											$product_path = '/';
											break;
										case 'product_category_slug':
											$product_path = 'product-category/';
											break;
										case 'full':
											$product_path = 'parent-category/category/';
											break;
									}
									?>
									<?php if ( ! empty( $product_path ) ) : ?>
										<code>
											<span data-product-path><?php echo esc_html( home_url( $product_path ) ); ?><span
														data-product-identifier><?php echo esc_html( $value['product_identifier'] ); ?></span></span><span
													data-url-ending><?php echo esc_html( $option_value['ending'] ); ?></span>
										</code>
									<?php endif; ?>
								</p>
							</label>
						</li>
						<li>
							<label for="<?php echo esc_attr( $value['id'] ); ?>[enable_category]">
							<input type="checkbox" <?php checked( $option_value['enable_category'], 'yes' ); ?>
								   id="<?php echo esc_attr( $value['id'] ); ?>[enable_category]"
								   name="<?php echo esc_attr( $value['id'] ); ?>[enable_category]" value="yes">
								<?php esc_html_e( 'Enable for categories', 'custom-permalinks-for-woocommerce' ); ?>
							<p>
								<?php
								$category_path = 'product-category/category';
								switch ( $category_permalink ) {
									case 'category_slug':
										$category_path = 'category';
										break;
									case 'full_category_slug':
										$category_path = 'product-category/category';
										break;
								}
								?>
								<?php if ( ! empty( $category_path ) ) : ?>
									<code><span data-category-path><?php echo esc_html( home_url( $category_path ) ); ?></span><span data-url-ending><?php echo esc_html( $option_value['ending'] ); ?></span></code>
								<?php endif; ?>
							</p>
							</label>
						</li>

					</ul>
				</fieldset>
			</td>
		</tr>
		<?php
	}
}
