<?php use WooPlugins\Permalinks\Services\ProductSpecificPermalinks;

defined( 'ABSPATH' ) || die;

/**
 * Available variables
 *
 * @var string $currentProductPermalinkOption
 * @var string $productIdentifier
 */

$availableOptions = array(
	'default'       => array(
		'label'       => __( 'Use WooCommerce defaults', 'custom-permalinks-for-woocommerce' ),
		'description' => home_url( 'product/' ) . $productIdentifier,
	),
	'product_slug'  => array(
		'label'       => __( 'Product slug alone', 'custom-permalinks-for-woocommerce' ),
		'description' => home_url( '/' ) . $productIdentifier,
	),
	'category_slug' => array(
		'label'       => __( 'Product slug with category name', 'custom-permalinks-for-woocommerce' ),
		'description' => home_url( 'product-category/' ) . $productIdentifier,
	),
	'full'          => array(
		'label'       => __( 'Full path', 'custom-permalinks-for-woocommerce' ),
		'description' => home_url( 'parent-category/category/' ) . $productIdentifier,
	)
);

?>

<div>
	<div style="margin: 20px 0;">
		<label>
			<input type="radio"
				   name="<?php echo esc_attr( ProductSpecificPermalinks::PRODUCT_SPECIFIC_PERMALINK_META ); ?>"
				   value="<?php echo esc_attr( ProductSpecificPermalinks::DEFAULT_VALUE ); ?>" <?php checked( ProductSpecificPermalinks::DEFAULT_VALUE, $currentProductPermalinkOption ); ?>>
			<?php esc_html_e( 'Use global settings', 'custom-permalinks-for-woocommerce' ); ?>
		</label>
		<br>
		<b><?php esc_html_e( 'As selected on Custom Permalinks settings page for Product', 'custom-permalinks-for-woocommerce' ); ?></b>
	</div>
	<?php foreach ( $availableOptions as $optionKey => $option ) : ?>
		<div style="margin: 20px 0;">
			<label>
				<input type="radio"
					   name="<?php echo esc_attr( ProductSpecificPermalinks::PRODUCT_SPECIFIC_PERMALINK_META ); ?>"
					   value="<?php echo esc_attr( $optionKey ); ?>" <?php checked( $optionKey, $currentProductPermalinkOption ); ?>>
				<?php echo esc_html( $option['label'] ); ?>
			</label>
			<br style="margin-bottom: 5px">
			<code><?php echo esc_html( $option['description'] ); ?></code>
		</div>
	<?php endforeach; ?>
</div>
