<?php
/**
 * Custom Permalinks term data from options to term table.
 *
 * @package CustomPermalinks
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

/**
 * Term data from options to term table class.
 */
final class Custom_Permalinks_Update_Taxonomy {
	/**
	 * Call Update Taxonomy Terms Function.
	 */
	public function __construct() {
		$this->update_taxonomy_terms();
	}

	/**
	 * Add the Permalinks of the Taxonomy to the term table.
	 */
	private function update_taxonomy_terms() {
		global $wpdb;

		$taxonomy_table = get_option( 'custom_permalink_table', -1 );
		if ( isset( $taxonomy_table ) && ! empty( $taxonomy_table )
			&& is_array( $taxonomy_table ) ) {
			$i = 1;
			foreach ( $taxonomy_table as $link => $info ) {
				if ( $i > 10 ) {
					break;
				}

				// phpcs:disable WordPress.DB.DirectDatabaseQuery.DirectQuery
				// phpcs:ignore WordPress.DB.DirectDatabaseQuery.NoCaching
				$check_term = $wpdb->get_row(
					$wpdb->prepare(
						"SELECT * FROM $wpdb->termmeta AS tm
							WHERE tm.meta_key = 'custom_permalink'
								AND tm.term_id = %d LIMIT 1",
						$info['id']
					)
				);
				// phpcs:enable WordPress.DB.DirectDatabaseQuery.DirectQuery

				if ( isset( $check_term->meta_value )
					&& ! empty( $check_term->meta_value ) ) {
					unset( $taxonomy_table[ $link ] );
				} else {
					$check_update = update_term_meta(
						$info['id'],
						'custom_permalink',
						$link
					);
					if ( ! is_wp_error( $check_update )
						&& true !== $check_update ) {
						unset( $taxonomy_table[ $link ] );
					}
				}
				$i++;
			}
			update_option( 'custom_permalink_table', $taxonomy_table );
		} elseif ( isset( $taxonomy_table ) && empty( $taxonomy_table ) ) {
			delete_option( 'custom_permalink_table' );
			update_option( 'custom_permalinks_plugin_version', '1.3.0' );
		}
	}
}
