<?php
/**
 * This file contains code relate to redux vehicle fields.
 *
 * @package RedParts\Sputnik
 * @since 1.2.0
 */

namespace RedParts\Sputnik\Redux\Vehicle_Fields;

use RedParts\Sputnik\Plugin;
use Redux_Field;

defined( 'ABSPATH' ) || exit;

if ( ! class_exists( 'RedParts\Sputnik\Redux\Vehicle_Fields\Vehicle_Fields' ) && class_exists( 'Redux_Field' ) ) {
	/**
	 * Class Admin
	 */
	class Vehicle_Fields extends Redux_Field {
		/**
		 * Set field and value defaults.
		 */
		public function set_defaults() {
			$this->value = is_array( $this->value ) ? $this->value : array();
		}

		/**
		 * Outputs field.
		 */
		public function render() {
			$fields = array_values( $this->value );

			?>
			<ul class="redparts-vehicle-fields">
				<?php foreach ( $fields as $index => $field ) : ?>
					<?php $this->render_form( $index, $field ); ?>
				<?php endforeach; ?>
			</ul>

			<script type="text/html" class="redparts-vehicle-field-template">
				<?php $this->render_form( -1 ); ?>
			</script>

			<button type="button" class="redparts-vehicle-field-add button">
				<?php echo esc_html__( 'Add Field', 'redparts-sputnik' ); ?>
			</button>
			<?php
		}

		/**
		 * Outputs form.
		 *
		 * @param int   $index Field index.
		 * @param array $field Field data.
		 */
		public function render_form( int $index, $field = array() ) {
			$options           = $this->field;
			$field_type        = ! empty( $field['type'] ) ? $field['type'] : 'year';
			$field_slug        = ! empty( $field['slug'] ) ? $field['slug'] : '';
			$field_label       = ! empty( $field['label'] ) ? $field['label'] : '';
			$field_placeholder = ! empty( $field['placeholder'] ) ? $field['placeholder'] : '';
			$field_order       = ! empty( $field['order'] ) ? $field['order'] : 'asc';

			$idx = function() use ( $index ) {
				if ( -1 === $index ) {
					echo '<%= index %>';
				} else {
					echo esc_html( $index );
				}
			}

			?>
			<li class="redparts-vehicle-fields__item" data-index="<?php $idx(); ?>">
				<div class="redparts-vehicle-fields__item-handle"></div>
				<ul class="redparts-vehicle-fields__item-form">
					<li>
						<label for="<?php echo esc_attr( $options['id'] ); ?>-<?php $idx(); ?>-type">
							<?php echo esc_html__( 'Type' ); ?>
						</label>
						<select
							name="<?php echo esc_attr( $options['name'] . $options['name_suffix'] ); ?>[<?php $idx(); ?>][type]"
							id="<?php echo esc_attr( $options['id'] ); ?>-<?php $idx(); ?>-type"
							data-id="<?php echo esc_attr( $options['id'] ); ?>"
						>
							<option value="year" <?php selected( 'year' === $field_type ); ?>>
								<?php echo esc_html__( 'Year', 'redparts-sputnik' ); ?>
							</option>
							<option value="text" <?php selected( 'text' === $field_type ); ?>>
								<?php echo esc_html__( 'Text', 'redparts-sputnik' ); ?>
							</option>
						</select>
					</li>

					<li>
						<label for="<?php echo esc_attr( $options['id'] ); ?>-<?php $idx(); ?>-order">
							<?php echo esc_html__( 'Options order' ); ?>
						</label>
						<select
							name="<?php echo esc_attr( $options['name'] . $options['name_suffix'] ); ?>[<?php $idx(); ?>][order]"
							id="<?php echo esc_attr( $options['id'] ); ?>-<?php $idx(); ?>-order"
							data-id="<?php echo esc_attr( $options['id'] ); ?>"
						>
							<option value="ask" <?php selected( 'ask' === $field_order ); ?>>
								<?php echo esc_html__( 'Ascending', 'redparts-sputnik' ); ?>
							</option>
							<option value="desk" <?php selected( 'desk' === $field_order ); ?>>
								<?php echo esc_html__( 'Descending', 'redparts-sputnik' ); ?>
							</option>
						</select>
					</li>

					<li>
						<label for="<?php echo esc_attr( $options['id'] ); ?>-<?php $idx(); ?>-slug">
							<?php echo esc_html__( 'Slug' ); ?>
						</label>
						<input
							type="text"
							class="regular-text"
							name="<?php echo esc_attr( $options['name'] . $options['name_suffix'] ); ?>[<?php $idx(); ?>][slug]"
							id="<?php echo esc_attr( $options['id'] ); ?>-<?php $idx(); ?>-slug"
							data-id="<?php echo esc_attr( $options['id'] ); ?>"
							value="<?php echo esc_attr( $field_slug ); ?>"
						/>
					</li>

					<li>
						<label for="<?php echo esc_attr( $options['id'] ); ?>-<?php $idx(); ?>-label">
							<?php echo esc_html__( 'Label' ); ?>
						</label>
						<input
							type="text"
							class="regular-text"
							name="<?php echo esc_attr( $options['name'] . $options['name_suffix'] ); ?>[<?php $idx(); ?>][label]"
							id="<?php echo esc_attr( $options['id'] ); ?>-<?php $idx(); ?>-label"
							data-id="<?php echo esc_attr( $options['id'] ); ?>"
							value="<?php echo esc_attr( $field_label ); ?>"
						/>
					</li>

					<li>
						<label for="<?php echo esc_attr( $options['id'] ); ?>-<?php $idx(); ?>-placeholder">
							<?php echo esc_html__( 'Placeholder' ); ?>
						</label>
						<input
							type="text"
							class="regular-text"
							name="<?php echo esc_attr( $options['name'] . $options['name_suffix'] ); ?>[<?php $idx(); ?>][placeholder]"
							id="<?php echo esc_attr( $options['id'] ); ?>-<?php $idx(); ?>-placeholder"
							data-id="<?php echo esc_attr( $options['id'] ); ?>"
							value="<?php echo esc_attr( $field_placeholder ); ?>"
						/>
					</li>

					<li>
						<button
							type="button"
							class="redparts-vehicle-field-remove button"
							data-confirm="<?php echo esc_attr__( 'Are you sure you want to delete this field?', 'redparts-sputnik' ); ?>"
						>
							<?php echo esc_html__( 'Remove Field', 'redparts-sputnik' ); ?>
						</button>
					</li>
				</ul>
			</li>
			<?php
		}

		/**
		 * Enqueues scripts and styles.
		 */
		public function enqueue() {
			wp_enqueue_style(
				'redparts-sputnik-redux-field-vehicle-fields-css',
				plugin_dir_url( __FILE__ ) . 'vehicle-fields.css',
				array(),
				Plugin::VERSION
			);
			wp_enqueue_script(
				'redparts-sputnik-redux-field-vehicle-fields-js',
				plugin_dir_url( __FILE__ ) . 'vehicle-fields.js',
				array(
					'jquery-ui-sortable',
					'underscore',
				),
				Plugin::VERSION,
				true
			);
		}
	}

	class_alias( 'RedParts\Sputnik\Redux\Vehicle_Fields\Vehicle_Fields', 'Redux_RedParts_Vehicle_Fields' );
}
