<?php
/**
 * Footer links widget.
 *
 * @package RedParts\Sputnik
 * @since 1.0.0
 */

namespace RedParts\Sputnik\Widgets;

use RedParts\Sputnik\Widget;
use WP_Term;

defined( 'ABSPATH' ) || exit;

if ( ! class_exists( 'RedParts\Sputnik\Widgets\Footer_Links' ) ) {
	/**
	 * Class Footer_Links
	 */
	class Footer_Links extends Widget {
		/**
		 * Constructor.
		 */
		public function __construct() {
			$widget_ops = array(
				'classname'                   => 'widget_redparts_sputnik_footer_links',
				'description'                 => esc_html_x( 'Displays links in the footer.', 'Admin', 'redparts-sputnik' ),
				'customize_selective_refresh' => true,
			);

			parent::__construct(
				'redparts_sputnik_footer_links',
				esc_html_x( 'RedParts: Footer Links', 'Admin', 'redparts-sputnik' ),
				$widget_ops
			);
		}

		/**
		 * Echoes the widget body content.
		 *
		 * @param array $args     Display arguments including 'before_title', 'after_title', 'before_widget', and 'after_widget'.
		 * @param array $instance The settings for the particular instance of the widget.
		 */
		protected function widget_body( array $args, array $instance ) {
			$columns = ! empty( $instance['columns'] ) ? $instance['columns'] : array();

			if ( $columns ) :
				uasort(
					$columns,
					function( $a, $b ) {
						$a = intval( $a['order'] );
						$b = intval( $b['order'] );

						if ( $a === $b ) {
							return 0;
						}

						return ( $a < $b ) ? -1 : 1;
					}
				);
				?>
				<div class="th-row">
					<?php foreach ( $columns as $column ) : ?>
						<?php
						$title = ! empty( $column['title'] ) ? $column['title'] : '';

						if ( empty( $column['menu'] ) ) {
							continue;
						}

						$menu = wp_get_nav_menu_object( absint( $column['menu'] ) );

						if ( ! $menu ) {
							continue;
						}

						?>
						<div class="th-col-6 th-footer-links">
							<?php if ( $title ) : ?>
								<h5 class="th-footer-links__title"><?php echo esc_html( $title ); ?></h5>
							<?php endif; ?>
							<?php
							wp_nav_menu(
								array(
									'fallback_cb'     => '',
									'menu'            => $menu,
									'container_class' => 'th-footer-links__list',
									'depth'           => 1,
								)
							);
							?>
						</div>
					<?php endforeach; ?>
				</div>
				<?php
			endif;
		}

		/**
		 * Returns form fields.
		 *
		 * @return array
		 */
		public function form_fields(): array {
			$menu_objects = wp_get_nav_menus();

			if ( ! is_array( $menu_objects ) ) {
				$menu_objects = array();
			}

			$menus = array(
				array(
					'key'   => '',
					'label' => esc_html__( 'Select Menu', 'redparts-sputnik' ),
				),
			);

			/** Menu object. @var WP_Term $menu_object */
			foreach ( $menu_objects as $menu_object ) {
				$menus[] = array(
					'key'   => (string) $menu_object->term_id,
					'label' => $menu_object->name,
				);
			}

			return array(
				array(
					'key'    => 'columns',
					'label'  => esc_html__( 'Columns', 'redparts-sputnik' ),
					'type'   => 'tabs',
					'max'    => 2,
					'fields' => array(
						array(
							'key'   => 'order',
							'label' => esc_html__( 'Order', 'redparts-sputnik' ),
							'type'  => 'number',
						),
						array(
							'key'          => 'title',
							'label'        => esc_html__( 'Title', 'redparts-sputnik' ),
							'type'         => 'text',
							'translatable' => true,
						),
						array(
							'key'     => 'menu',
							'label'   => esc_html__( 'Menu', 'redparts-sputnik' ),
							'type'    => 'select',
							'options' => $menus,
						),

					),
					'l10n'   => array(
						'add'    => esc_html__( 'Add Column', 'redparts-sputnik' ),
						'remove' => esc_html__( 'Remove Column', 'redparts-sputnik' ),
						/* translators: %s: Column number. */
						'title'  => esc_html__( 'Column %s', 'redparts-sputnik' ),
					),
				),
			);
		}

		/**
		 * Enqueue admin scripts.
		 */
		public function enqueue_admin_scripts() {
			wp_enqueue_style( 'redparts-sputnik-admin' );
			wp_enqueue_script( 'redparts-sputnik-admin' );
		}
	}
}
