<?php

global $wpdb;
$wpdb->hide_errors();
$sql = "CREATE TABLE IF NOT EXISTS `".$wpdb->prefix."smapi_social_login` (
`userid` BIGINT(20) NOT NULL,
`social_id` VARCHAR(40) NOT NULL,
`token` TEXT NOT NULL,
`social_type` varchar(20) NOT NULL,
KEY `social_id` (`social_id`,`social_type`)
) CHARSET=utf8;";
dbDelta($sql);

$sql = "CREATE TABLE IF NOT EXISTS `".$wpdb->prefix."smapi_option` (
`id` int(11) NOT NULL AUTO_INCREMENT,
`name` varchar(20) NOT NULL,
`title` varchar(50) NOT NULL,
`description` mediumtext NOT NULL,
`hint` mediumtext NOT NULL,
`type` varchar(20) NOT NULL,
`values` text NOT NULL,
PRIMARY KEY (`id`)
) CHARSET=utf8;";
dbDelta($sql);

$sql = "CREATE TABLE IF NOT EXISTS `".$wpdb->prefix."smapi_service` (
`id` int(11) NOT NULL AUTO_INCREMENT,
`name` varchar(20) NOT NULL,
`description` mediumtext NOT NULL,
`query` text NOT NULL,
`codetype` ENUM('php','query') NOT NULL,
`paging` set('enable','disable') NOT NULL,
`access_level` MEDIUMTEXT NOT NULL,
PRIMARY KEY (`id`)
) CHARSET=utf8;";
dbDelta($sql);

$sql = "CREATE TABLE IF NOT EXISTS `".$wpdb->prefix."smapi_engine` (
`id` int(11) NOT NULL AUTO_INCREMENT,
`name` varchar(50) NOT NULL,
`description` varchar(200) NOT NULL,
`scope` VARCHAR(20) NOT NULL,
`group` varchar(20) NOT NULL,
`params` text NOT NULL,
`access_level` mediumtext NOT NULL,
`active` tinyint(1) NOT NULL,
PRIMARY KEY (`id`),
KEY `name` (`name`)
) CHARSET=utf8;";
dbDelta($sql);

$sql = "CREATE TABLE IF NOT EXISTS `".$wpdb->prefix."smapi_author_followers` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `userid` int(11) NOT NULL,
  `authorid` int(11) NOT NULL,
  PRIMARY KEY (`id`)
) CHARSET=utf8;";
dbDelta($sql);

$sql = "CREATE TABLE IF NOT EXISTS `".$wpdb->prefix."smapi_auth_tokens` (
  `id` INT NOT NULL AUTO_INCREMENT,
  `md5_access_token` varchar(32) NOT NULL,
  `access_token` varchar(256) NOT NULL,
  `clientid` INT NOT NULL,
  `userid` int(11) NOT NULL,
  `expire` varchar(15) DEFAULT NULL,
  `scope` tinytext NOT NULL,
  PRIMARY KEY (`id`)
) CHARSET=utf8;";
dbDelta($sql);

$sql = "CREATE TABLE IF NOT EXISTS `".$wpdb->prefix."smapi_oauth_clients` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `app_id` int(11) NOT NULL,
  `auth_key` varchar(256) NOT NULL,
  `quota` varchar(50) NOT NULL,
  `req_usage` varchar(50) NOT NULL,
  `settings` text NOT NULL,
  `status` BOOLEAN NOT NULL,
  PRIMARY KEY (`id`)
  ) CHARSET=utf8;";
dbDelta($sql);

$wp_smapi_engine = array(
  array('id' => '1','name' => 'login','description' => 'Login','scope' => 'public','group' => '','params' => '','access_level' => 'a:1:{i:0;s:6:"anyone";}','active' => '1'),
  array('id' => '2','name' => 'signup','description' => 'Singup','scope' => 'public','group' => '','params' => '','access_level' => 'a:1:{i:0;s:6:"anyone";}','active' => '1'),
  array('id' => '3','name' => 'social','description' => 'Social signup and login','scope' => 'public','group' => '','params' => '','access_level' => 'a:1:{i:0;s:6:"anyone";}','active' => '1'),
  array('id' => '4','name' => 'lostpwd','description' => 'Lost password','scope' => 'public','group' => '','params' => '','access_level' => 'a:1:{i:0;s:6:"anyone";}','active' => '1'),
  array('id' => '5','name' => 'logout','description' => 'Logout and destroy sessions','scope' => 'public','group' => '','params' => '','access_level' => 'a:1:{i:0;s:6:"anyone";}','active' => '1'),
  array('id' => '6','name' => 'authors','description' => 'List of authors','scope' => 'profiles','group' => 'authors','params' => 'a:18:{i:0;a:3:{s:4:"name";s:2:"ID";s:9:"depend_on";s:0:"";s:6:"active";s:1:"1";}i:1;a:3:{s:4:"name";s:10:"user_login";s:9:"depend_on";s:0:"";s:6:"active";s:1:"1";}i:2;a:3:{s:4:"name";s:13:"user_nicename";s:9:"depend_on";s:0:"";s:6:"active";s:1:"1";}i:3;a:3:{s:4:"name";s:10:"user_email";s:9:"depend_on";s:0:"";s:6:"active";s:1:"1";}i:4;a:3:{s:4:"name";s:8:"user_url";s:9:"depend_on";s:0:"";s:6:"active";s:1:"1";}i:5;a:3:{s:4:"name";s:15:"user_registered";s:9:"depend_on";s:0:"";s:6:"active";s:1:"1";}i:6;a:3:{s:4:"name";s:12:"display_name";s:9:"depend_on";s:0:"";s:6:"active";s:1:"1";}i:7;a:3:{s:4:"name";s:4:"role";s:9:"depend_on";s:0:"";s:6:"active";s:1:"1";}i:8;a:3:{s:4:"name";s:10:"first_name";s:9:"depend_on";s:0:"";s:6:"active";s:1:"1";}i:9;a:3:{s:4:"name";s:9:"last_name";s:9:"depend_on";s:0:"";s:6:"active";s:1:"1";}i:10;a:3:{s:4:"name";s:8:"nickname";s:9:"depend_on";s:0:"";s:6:"active";s:1:"1";}i:11;a:3:{s:4:"name";s:11:"description";s:9:"depend_on";s:0:"";s:6:"active";s:1:"1";}i:12;a:3:{s:4:"name";s:6:"avatar";s:9:"depend_on";s:0:"";s:6:"active";s:1:"1";}i:13;a:3:{s:4:"name";s:3:"aim";s:9:"depend_on";s:0:"";s:6:"active";s:1:"1";}i:14;a:3:{s:4:"name";s:6:"jabber";s:9:"depend_on";s:0:"";s:6:"active";s:1:"1";}i:15;a:3:{s:4:"name";s:3:"yim";s:9:"depend_on";s:0:"";s:6:"active";s:1:"1";}i:16;a:3:{s:4:"name";s:13:"custom_fields";s:9:"depend_on";s:0:"";s:6:"active";s:1:"1";}i:17;a:3:{s:4:"name";s:10:"authormeta";s:9:"depend_on";s:0:"";s:6:"active";s:1:"1";}}','access_level' => 'a:1:{i:0;s:6:"anyone";}','active' => '1'),
  array('id' => '7','name' => 'get_author','description' => 'Get the full profile for an author','scope' => 'profiles','group' => 'authors','params' => 'a:18:{i:0;a:3:{s:4:"name";s:2:"ID";s:9:"depend_on";s:0:"";s:6:"active";s:1:"1";}i:1;a:3:{s:4:"name";s:10:"user_login";s:9:"depend_on";s:0:"";s:6:"active";s:1:"1";}i:2;a:3:{s:4:"name";s:13:"user_nicename";s:9:"depend_on";s:0:"";s:6:"active";s:1:"1";}i:3;a:3:{s:4:"name";s:10:"user_email";s:9:"depend_on";s:0:"";s:6:"active";s:1:"1";}i:4;a:3:{s:4:"name";s:8:"user_url";s:9:"depend_on";s:0:"";s:6:"active";s:1:"1";}i:5;a:3:{s:4:"name";s:15:"user_registered";s:9:"depend_on";s:0:"";s:6:"active";s:1:"1";}i:6;a:3:{s:4:"name";s:12:"display_name";s:9:"depend_on";s:0:"";s:6:"active";s:1:"1";}i:7;a:3:{s:4:"name";s:4:"role";s:9:"depend_on";s:0:"";s:6:"active";s:1:"1";}i:8;a:3:{s:4:"name";s:10:"first_name";s:9:"depend_on";s:0:"";s:6:"active";s:1:"1";}i:9;a:3:{s:4:"name";s:9:"last_name";s:9:"depend_on";s:0:"";s:6:"active";s:1:"1";}i:10;a:3:{s:4:"name";s:8:"nickname";s:9:"depend_on";s:0:"";s:6:"active";s:1:"1";}i:11;a:3:{s:4:"name";s:11:"description";s:9:"depend_on";s:0:"";s:6:"active";s:1:"1";}i:12;a:3:{s:4:"name";s:6:"avatar";s:9:"depend_on";s:0:"";s:6:"active";s:1:"1";}i:13;a:3:{s:4:"name";s:3:"aim";s:9:"depend_on";s:0:"";s:6:"active";s:1:"1";}i:14;a:3:{s:4:"name";s:6:"jabber";s:9:"depend_on";s:0:"";s:6:"active";s:1:"1";}i:15;a:3:{s:4:"name";s:3:"yim";s:9:"depend_on";s:0:"";s:6:"active";s:1:"1";}i:16;a:3:{s:4:"name";s:13:"custom_fields";s:9:"depend_on";s:0:"";s:6:"active";s:1:"1";}i:17;a:3:{s:4:"name";s:10:"authormeta";s:9:"depend_on";s:0:"";s:6:"active";s:1:"1";}}','access_level' => 'a:1:{i:0;s:6:"anyone";}','active' => '1'),
  array('id' => '8','name' => 'author_posts','description' => 'List of posts published by an author','scope' => 'posts','group' => 'getposts','params' => 'a:25:{i:0;a:3:{s:4:"name";s:2:"ID";s:9:"depend_on";s:0:"";s:6:"active";s:1:"1";}i:1;a:3:{s:4:"name";s:10:"post_title";s:9:"depend_on";s:0:"";s:6:"active";s:1:"1";}i:2;a:3:{s:4:"name";s:4:"guid";s:9:"depend_on";s:0:"";s:6:"active";s:1:"1";}i:3;a:3:{s:4:"name";s:12:"post_content";s:9:"depend_on";s:0:"";s:6:"active";s:1:"1";}i:4;a:3:{s:4:"name";s:11:"post_author";s:9:"depend_on";s:0:"";s:6:"active";s:1:"1";}i:5;a:3:{s:4:"name";s:9:"post_date";s:9:"depend_on";s:0:"";s:6:"active";s:1:"1";}i:6;a:3:{s:4:"name";s:13:"post_date_gmt";s:9:"depend_on";s:0:"";s:6:"active";s:1:"1";}i:7;a:3:{s:4:"name";s:14:"comment_status";s:9:"depend_on";s:0:"";s:6:"active";s:1:"1";}i:8;a:3:{s:4:"name";s:11:"ping_status";s:9:"depend_on";s:0:"";s:6:"active";s:1:"1";}i:9;a:3:{s:4:"name";s:9:"post_name";s:9:"depend_on";s:0:"";s:6:"active";s:1:"1";}i:10;a:3:{s:4:"name";s:13:"post_modified";s:9:"depend_on";s:0:"";s:6:"active";s:1:"1";}i:11;a:3:{s:4:"name";s:17:"post_modified_gmt";s:9:"depend_on";s:0:"";s:6:"active";s:1:"1";}i:12;a:3:{s:4:"name";s:21:"post_content_filtered";s:9:"depend_on";s:0:"";s:6:"active";s:1:"1";}i:13;a:3:{s:4:"name";s:11:"post_parent";s:9:"depend_on";s:0:"";s:6:"active";s:1:"1";}i:14;a:3:{s:4:"name";s:10:"menu_order";s:9:"depend_on";s:0:"";s:6:"active";s:1:"1";}i:15;a:3:{s:4:"name";s:13:"comment_count";s:9:"depend_on";s:0:"";s:6:"active";s:1:"1";}i:16;a:3:{s:4:"name";s:13:"featuredimage";s:9:"depend_on";s:0:"";s:6:"active";s:1:"1";}i:17;a:3:{s:4:"name";s:13:"featuredthumb";s:9:"depend_on";s:0:"";s:6:"active";s:1:"1";}i:18;a:3:{s:4:"name";s:8:"category";s:9:"depend_on";s:13:"25@categories";s:6:"active";s:1:"1";}i:19;a:3:{s:4:"name";s:4:"tags";s:9:"depend_on";s:0:"";s:6:"active";s:1:"1";}i:20;a:3:{s:4:"name";s:6:"author";s:9:"depend_on";s:9:"5@authors";s:6:"active";s:1:"1";}i:21;a:3:{s:4:"name";s:11:"post_format";s:9:"depend_on";s:0:"";s:6:"active";s:1:"1";}i:22;a:3:{s:4:"name";s:13:"custom_fields";s:9:"depend_on";s:0:"";s:6:"active";s:1:"1";}i:23;a:3:{s:4:"name";s:8:"postmeta";s:9:"depend_on";s:0:"";s:6:"active";s:1:"1";}i:24;a:3:{s:4:"name";s:10:"taxonomies";s:9:"depend_on";s:0:"";s:6:"active";s:1:"1";}}','access_level' => 'a:1:{i:0;s:6:"anyone";}','active' => '1'),
  array('id' => '9','name' => 'posts_subscribedin','description' => 'Get posts that user comment in it','scope' => 'posts','group' => 'getposts','params' => 'a:25:{i:0;a:3:{s:4:"name";s:2:"ID";s:9:"depend_on";s:0:"";s:6:"active";s:1:"1";}i:1;a:3:{s:4:"name";s:10:"post_title";s:9:"depend_on";s:0:"";s:6:"active";s:1:"1";}i:2;a:3:{s:4:"name";s:4:"guid";s:9:"depend_on";s:0:"";s:6:"active";s:1:"1";}i:3;a:3:{s:4:"name";s:12:"post_content";s:9:"depend_on";s:0:"";s:6:"active";s:1:"1";}i:4;a:3:{s:4:"name";s:11:"post_author";s:9:"depend_on";s:0:"";s:6:"active";s:1:"1";}i:5;a:3:{s:4:"name";s:9:"post_date";s:9:"depend_on";s:0:"";s:6:"active";s:1:"1";}i:6;a:3:{s:4:"name";s:13:"post_date_gmt";s:9:"depend_on";s:0:"";s:6:"active";s:1:"1";}i:7;a:3:{s:4:"name";s:14:"comment_status";s:9:"depend_on";s:0:"";s:6:"active";s:1:"1";}i:8;a:3:{s:4:"name";s:11:"ping_status";s:9:"depend_on";s:0:"";s:6:"active";s:1:"1";}i:9;a:3:{s:4:"name";s:9:"post_name";s:9:"depend_on";s:0:"";s:6:"active";s:1:"1";}i:10;a:3:{s:4:"name";s:13:"post_modified";s:9:"depend_on";s:0:"";s:6:"active";s:1:"1";}i:11;a:3:{s:4:"name";s:17:"post_modified_gmt";s:9:"depend_on";s:0:"";s:6:"active";s:1:"1";}i:12;a:3:{s:4:"name";s:21:"post_content_filtered";s:9:"depend_on";s:0:"";s:6:"active";s:1:"1";}i:13;a:3:{s:4:"name";s:11:"post_parent";s:9:"depend_on";s:0:"";s:6:"active";s:1:"1";}i:14;a:3:{s:4:"name";s:10:"menu_order";s:9:"depend_on";s:0:"";s:6:"active";s:1:"1";}i:15;a:3:{s:4:"name";s:13:"comment_count";s:9:"depend_on";s:0:"";s:6:"active";s:1:"1";}i:16;a:3:{s:4:"name";s:13:"featuredimage";s:9:"depend_on";s:0:"";s:6:"active";s:1:"1";}i:17;a:3:{s:4:"name";s:13:"featuredthumb";s:9:"depend_on";s:0:"";s:6:"active";s:1:"1";}i:18;a:3:{s:4:"name";s:8:"category";s:9:"depend_on";s:13:"25@categories";s:6:"active";s:1:"1";}i:19;a:3:{s:4:"name";s:4:"tags";s:9:"depend_on";s:0:"";s:6:"active";s:1:"1";}i:20;a:3:{s:4:"name";s:6:"author";s:9:"depend_on";s:9:"5@authors";s:6:"active";s:1:"1";}i:21;a:3:{s:4:"name";s:11:"post_format";s:9:"depend_on";s:0:"";s:6:"active";s:1:"1";}i:22;a:3:{s:4:"name";s:13:"custom_fields";s:9:"depend_on";s:0:"";s:6:"active";s:1:"1";}i:23;a:3:{s:4:"name";s:8:"postmeta";s:9:"depend_on";s:0:"";s:6:"active";s:1:"1";}i:24;a:3:{s:4:"name";s:10:"taxonomies";s:9:"depend_on";s:0:"";s:6:"active";s:1:"1";}}','access_level' => 'a:1:{i:0;s:6:"anyone";}','active' => '1'),
  array('id' => '10','name' => 'newpost','description' => 'Publish new post','scope' => 'publish_posts','group' => '','params' => '','access_level' => 'a:1:{i:0;s:6:"logged";}','active' => '1'),
  array('id' => '11','name' => 'upload_media','description' => 'Upload media file','scope' => 'publish_posts','group' => '','params' => '','access_level' => 'a:1:{i:0;s:6:"logged";}','active' => '1'),
  array('id' => '12','name' => 'getposts','description' => 'Get posts by category or custom taxonomy','scope' => 'posts','group' => 'getposts','params' => 'a:25:{i:0;a:3:{s:4:"name";s:2:"ID";s:9:"depend_on";s:0:"";s:6:"active";s:1:"1";}i:1;a:3:{s:4:"name";s:10:"post_title";s:9:"depend_on";s:0:"";s:6:"active";s:1:"1";}i:2;a:3:{s:4:"name";s:4:"guid";s:9:"depend_on";s:0:"";s:6:"active";s:1:"1";}i:3;a:3:{s:4:"name";s:12:"post_content";s:9:"depend_on";s:0:"";s:6:"active";s:1:"1";}i:4;a:3:{s:4:"name";s:11:"post_author";s:9:"depend_on";s:0:"";s:6:"active";s:1:"1";}i:5;a:3:{s:4:"name";s:9:"post_date";s:9:"depend_on";s:0:"";s:6:"active";s:1:"1";}i:6;a:3:{s:4:"name";s:13:"post_date_gmt";s:9:"depend_on";s:0:"";s:6:"active";s:1:"1";}i:7;a:3:{s:4:"name";s:14:"comment_status";s:9:"depend_on";s:0:"";s:6:"active";s:1:"1";}i:8;a:3:{s:4:"name";s:11:"ping_status";s:9:"depend_on";s:0:"";s:6:"active";s:1:"1";}i:9;a:3:{s:4:"name";s:9:"post_name";s:9:"depend_on";s:0:"";s:6:"active";s:1:"1";}i:10;a:3:{s:4:"name";s:13:"post_modified";s:9:"depend_on";s:0:"";s:6:"active";s:1:"1";}i:11;a:3:{s:4:"name";s:17:"post_modified_gmt";s:9:"depend_on";s:0:"";s:6:"active";s:1:"1";}i:12;a:3:{s:4:"name";s:21:"post_content_filtered";s:9:"depend_on";s:0:"";s:6:"active";s:1:"1";}i:13;a:3:{s:4:"name";s:11:"post_parent";s:9:"depend_on";s:0:"";s:6:"active";s:1:"1";}i:14;a:3:{s:4:"name";s:10:"menu_order";s:9:"depend_on";s:0:"";s:6:"active";s:1:"1";}i:15;a:3:{s:4:"name";s:13:"comment_count";s:9:"depend_on";s:0:"";s:6:"active";s:1:"1";}i:16;a:3:{s:4:"name";s:13:"featuredimage";s:9:"depend_on";s:0:"";s:6:"active";s:1:"1";}i:17;a:3:{s:4:"name";s:13:"featuredthumb";s:9:"depend_on";s:0:"";s:6:"active";s:1:"1";}i:18;a:3:{s:4:"name";s:8:"category";s:9:"depend_on";s:13:"25@categories";s:6:"active";s:1:"1";}i:19;a:3:{s:4:"name";s:4:"tags";s:9:"depend_on";s:0:"";s:6:"active";s:1:"1";}i:20;a:3:{s:4:"name";s:6:"author";s:9:"depend_on";s:9:"5@authors";s:6:"active";s:1:"1";}i:21;a:3:{s:4:"name";s:11:"post_format";s:9:"depend_on";s:0:"";s:6:"active";s:1:"1";}i:22;a:3:{s:4:"name";s:13:"custom_fields";s:9:"depend_on";s:0:"";s:6:"active";s:1:"1";}i:23;a:3:{s:4:"name";s:8:"postmeta";s:9:"depend_on";s:0:"";s:6:"active";s:1:"1";}i:24;a:3:{s:4:"name";s:10:"taxonomies";s:9:"depend_on";s:0:"";s:6:"active";s:1:"1";}}','access_level' => 'a:1:{i:0;s:6:"anyone";}','active' => '1'),
  array('id' => '13','name' => 'search_posts','description' => 'Search in posts by title','scope' => 'posts','group' => 'getposts','params' => 'a:25:{i:0;a:3:{s:4:"name";s:2:"ID";s:9:"depend_on";s:0:"";s:6:"active";s:1:"1";}i:1;a:3:{s:4:"name";s:10:"post_title";s:9:"depend_on";s:0:"";s:6:"active";s:1:"1";}i:2;a:3:{s:4:"name";s:4:"guid";s:9:"depend_on";s:0:"";s:6:"active";s:1:"1";}i:3;a:3:{s:4:"name";s:12:"post_content";s:9:"depend_on";s:0:"";s:6:"active";s:1:"1";}i:4;a:3:{s:4:"name";s:11:"post_author";s:9:"depend_on";s:0:"";s:6:"active";s:1:"1";}i:5;a:3:{s:4:"name";s:9:"post_date";s:9:"depend_on";s:0:"";s:6:"active";s:1:"1";}i:6;a:3:{s:4:"name";s:13:"post_date_gmt";s:9:"depend_on";s:0:"";s:6:"active";s:1:"1";}i:7;a:3:{s:4:"name";s:14:"comment_status";s:9:"depend_on";s:0:"";s:6:"active";s:1:"1";}i:8;a:3:{s:4:"name";s:11:"ping_status";s:9:"depend_on";s:0:"";s:6:"active";s:1:"1";}i:9;a:3:{s:4:"name";s:9:"post_name";s:9:"depend_on";s:0:"";s:6:"active";s:1:"1";}i:10;a:3:{s:4:"name";s:13:"post_modified";s:9:"depend_on";s:0:"";s:6:"active";s:1:"1";}i:11;a:3:{s:4:"name";s:17:"post_modified_gmt";s:9:"depend_on";s:0:"";s:6:"active";s:1:"1";}i:12;a:3:{s:4:"name";s:21:"post_content_filtered";s:9:"depend_on";s:0:"";s:6:"active";s:1:"1";}i:13;a:3:{s:4:"name";s:11:"post_parent";s:9:"depend_on";s:0:"";s:6:"active";s:1:"1";}i:14;a:3:{s:4:"name";s:10:"menu_order";s:9:"depend_on";s:0:"";s:6:"active";s:1:"1";}i:15;a:3:{s:4:"name";s:13:"comment_count";s:9:"depend_on";s:0:"";s:6:"active";s:1:"1";}i:16;a:3:{s:4:"name";s:13:"featuredimage";s:9:"depend_on";s:0:"";s:6:"active";s:1:"1";}i:17;a:3:{s:4:"name";s:13:"featuredthumb";s:9:"depend_on";s:0:"";s:6:"active";s:1:"1";}i:18;a:3:{s:4:"name";s:8:"category";s:9:"depend_on";s:13:"25@categories";s:6:"active";s:1:"1";}i:19;a:3:{s:4:"name";s:4:"tags";s:9:"depend_on";s:0:"";s:6:"active";s:1:"1";}i:20;a:3:{s:4:"name";s:6:"author";s:9:"depend_on";s:9:"5@authors";s:6:"active";s:1:"1";}i:21;a:3:{s:4:"name";s:11:"post_format";s:9:"depend_on";s:0:"";s:6:"active";s:1:"1";}i:22;a:3:{s:4:"name";s:13:"custom_fields";s:9:"depend_on";s:0:"";s:6:"active";s:1:"1";}i:23;a:3:{s:4:"name";s:8:"postmeta";s:9:"depend_on";s:0:"";s:6:"active";s:1:"1";}i:24;a:3:{s:4:"name";s:10:"taxonomies";s:9:"depend_on";s:0:"";s:6:"active";s:1:"1";}}','access_level' => 'a:1:{i:0;s:6:"anyone";}','active' => '1'),
  array('id' => '14','name' => 'last_posts','description' => 'Last posts in blog','scope' => 'posts','group' => 'getposts','params' => 'a:25:{i:0;a:3:{s:4:"name";s:2:"ID";s:9:"depend_on";s:0:"";s:6:"active";s:1:"1";}i:1;a:3:{s:4:"name";s:10:"post_title";s:9:"depend_on";s:0:"";s:6:"active";s:1:"1";}i:2;a:3:{s:4:"name";s:4:"guid";s:9:"depend_on";s:0:"";s:6:"active";s:1:"1";}i:3;a:3:{s:4:"name";s:12:"post_content";s:9:"depend_on";s:0:"";s:6:"active";s:1:"1";}i:4;a:3:{s:4:"name";s:11:"post_author";s:9:"depend_on";s:0:"";s:6:"active";s:1:"1";}i:5;a:3:{s:4:"name";s:9:"post_date";s:9:"depend_on";s:0:"";s:6:"active";s:1:"1";}i:6;a:3:{s:4:"name";s:13:"post_date_gmt";s:9:"depend_on";s:0:"";s:6:"active";s:1:"1";}i:7;a:3:{s:4:"name";s:14:"comment_status";s:9:"depend_on";s:0:"";s:6:"active";s:1:"1";}i:8;a:3:{s:4:"name";s:11:"ping_status";s:9:"depend_on";s:0:"";s:6:"active";s:1:"1";}i:9;a:3:{s:4:"name";s:9:"post_name";s:9:"depend_on";s:0:"";s:6:"active";s:1:"1";}i:10;a:3:{s:4:"name";s:13:"post_modified";s:9:"depend_on";s:0:"";s:6:"active";s:1:"1";}i:11;a:3:{s:4:"name";s:17:"post_modified_gmt";s:9:"depend_on";s:0:"";s:6:"active";s:1:"1";}i:12;a:3:{s:4:"name";s:21:"post_content_filtered";s:9:"depend_on";s:0:"";s:6:"active";s:1:"1";}i:13;a:3:{s:4:"name";s:11:"post_parent";s:9:"depend_on";s:0:"";s:6:"active";s:1:"1";}i:14;a:3:{s:4:"name";s:10:"menu_order";s:9:"depend_on";s:0:"";s:6:"active";s:1:"1";}i:15;a:3:{s:4:"name";s:13:"comment_count";s:9:"depend_on";s:0:"";s:6:"active";s:1:"1";}i:16;a:3:{s:4:"name";s:13:"featuredimage";s:9:"depend_on";s:0:"";s:6:"active";s:1:"1";}i:17;a:3:{s:4:"name";s:13:"featuredthumb";s:9:"depend_on";s:0:"";s:6:"active";s:1:"1";}i:18;a:3:{s:4:"name";s:8:"category";s:9:"depend_on";s:13:"25@categories";s:6:"active";s:1:"1";}i:19;a:3:{s:4:"name";s:4:"tags";s:9:"depend_on";s:0:"";s:6:"active";s:1:"1";}i:20;a:3:{s:4:"name";s:6:"author";s:9:"depend_on";s:9:"5@authors";s:6:"active";s:1:"1";}i:21;a:3:{s:4:"name";s:11:"post_format";s:9:"depend_on";s:0:"";s:6:"active";s:1:"1";}i:22;a:3:{s:4:"name";s:13:"custom_fields";s:9:"depend_on";s:0:"";s:6:"active";s:1:"1";}i:23;a:3:{s:4:"name";s:8:"postmeta";s:9:"depend_on";s:0:"";s:6:"active";s:1:"1";}i:24;a:3:{s:4:"name";s:10:"taxonomies";s:9:"depend_on";s:0:"";s:6:"active";s:1:"1";}}','access_level' => 'a:1:{i:0;s:6:"anyone";}','active' => '1'),
  array('id' => '15','name' => 'popular_posts','description' => 'Popular Posts in range days','scope' => 'posts','group' => 'getposts','params' => 'a:25:{i:0;a:3:{s:4:"name";s:2:"ID";s:9:"depend_on";s:0:"";s:6:"active";s:1:"1";}i:1;a:3:{s:4:"name";s:10:"post_title";s:9:"depend_on";s:0:"";s:6:"active";s:1:"1";}i:2;a:3:{s:4:"name";s:4:"guid";s:9:"depend_on";s:0:"";s:6:"active";s:1:"1";}i:3;a:3:{s:4:"name";s:12:"post_content";s:9:"depend_on";s:0:"";s:6:"active";s:1:"1";}i:4;a:3:{s:4:"name";s:11:"post_author";s:9:"depend_on";s:0:"";s:6:"active";s:1:"1";}i:5;a:3:{s:4:"name";s:9:"post_date";s:9:"depend_on";s:0:"";s:6:"active";s:1:"1";}i:6;a:3:{s:4:"name";s:13:"post_date_gmt";s:9:"depend_on";s:0:"";s:6:"active";s:1:"1";}i:7;a:3:{s:4:"name";s:14:"comment_status";s:9:"depend_on";s:0:"";s:6:"active";s:1:"1";}i:8;a:3:{s:4:"name";s:11:"ping_status";s:9:"depend_on";s:0:"";s:6:"active";s:1:"1";}i:9;a:3:{s:4:"name";s:9:"post_name";s:9:"depend_on";s:0:"";s:6:"active";s:1:"1";}i:10;a:3:{s:4:"name";s:13:"post_modified";s:9:"depend_on";s:0:"";s:6:"active";s:1:"1";}i:11;a:3:{s:4:"name";s:17:"post_modified_gmt";s:9:"depend_on";s:0:"";s:6:"active";s:1:"1";}i:12;a:3:{s:4:"name";s:21:"post_content_filtered";s:9:"depend_on";s:0:"";s:6:"active";s:1:"1";}i:13;a:3:{s:4:"name";s:11:"post_parent";s:9:"depend_on";s:0:"";s:6:"active";s:1:"1";}i:14;a:3:{s:4:"name";s:10:"menu_order";s:9:"depend_on";s:0:"";s:6:"active";s:1:"1";}i:15;a:3:{s:4:"name";s:13:"comment_count";s:9:"depend_on";s:0:"";s:6:"active";s:1:"1";}i:16;a:3:{s:4:"name";s:13:"featuredimage";s:9:"depend_on";s:0:"";s:6:"active";s:1:"1";}i:17;a:3:{s:4:"name";s:13:"featuredthumb";s:9:"depend_on";s:0:"";s:6:"active";s:1:"1";}i:18;a:3:{s:4:"name";s:8:"category";s:9:"depend_on";s:13:"25@categories";s:6:"active";s:1:"1";}i:19;a:3:{s:4:"name";s:4:"tags";s:9:"depend_on";s:0:"";s:6:"active";s:1:"1";}i:20;a:3:{s:4:"name";s:6:"author";s:9:"depend_on";s:9:"5@authors";s:6:"active";s:1:"1";}i:21;a:3:{s:4:"name";s:11:"post_format";s:9:"depend_on";s:0:"";s:6:"active";s:1:"1";}i:22;a:3:{s:4:"name";s:13:"custom_fields";s:9:"depend_on";s:0:"";s:6:"active";s:1:"1";}i:23;a:3:{s:4:"name";s:8:"postmeta";s:9:"depend_on";s:0:"";s:6:"active";s:1:"1";}i:24;a:3:{s:4:"name";s:10:"taxonomies";s:9:"depend_on";s:0:"";s:6:"active";s:1:"1";}}','access_level' => 'a:1:{i:0;s:6:"anyone";}','active' => '1'),
  array('id' => '16','name' => 'getposts_format','description' => 'Get posts by post format','scope' => 'posts','group' => 'getposts','params' => 'a:25:{i:0;a:3:{s:4:"name";s:2:"ID";s:9:"depend_on";s:0:"";s:6:"active";s:1:"1";}i:1;a:3:{s:4:"name";s:10:"post_title";s:9:"depend_on";s:0:"";s:6:"active";s:1:"1";}i:2;a:3:{s:4:"name";s:4:"guid";s:9:"depend_on";s:0:"";s:6:"active";s:1:"1";}i:3;a:3:{s:4:"name";s:12:"post_content";s:9:"depend_on";s:0:"";s:6:"active";s:1:"1";}i:4;a:3:{s:4:"name";s:11:"post_author";s:9:"depend_on";s:0:"";s:6:"active";s:1:"1";}i:5;a:3:{s:4:"name";s:9:"post_date";s:9:"depend_on";s:0:"";s:6:"active";s:1:"1";}i:6;a:3:{s:4:"name";s:13:"post_date_gmt";s:9:"depend_on";s:0:"";s:6:"active";s:1:"1";}i:7;a:3:{s:4:"name";s:14:"comment_status";s:9:"depend_on";s:0:"";s:6:"active";s:1:"1";}i:8;a:3:{s:4:"name";s:11:"ping_status";s:9:"depend_on";s:0:"";s:6:"active";s:1:"1";}i:9;a:3:{s:4:"name";s:9:"post_name";s:9:"depend_on";s:0:"";s:6:"active";s:1:"1";}i:10;a:3:{s:4:"name";s:13:"post_modified";s:9:"depend_on";s:0:"";s:6:"active";s:1:"1";}i:11;a:3:{s:4:"name";s:17:"post_modified_gmt";s:9:"depend_on";s:0:"";s:6:"active";s:1:"1";}i:12;a:3:{s:4:"name";s:21:"post_content_filtered";s:9:"depend_on";s:0:"";s:6:"active";s:1:"1";}i:13;a:3:{s:4:"name";s:11:"post_parent";s:9:"depend_on";s:0:"";s:6:"active";s:1:"1";}i:14;a:3:{s:4:"name";s:10:"menu_order";s:9:"depend_on";s:0:"";s:6:"active";s:1:"1";}i:15;a:3:{s:4:"name";s:13:"comment_count";s:9:"depend_on";s:0:"";s:6:"active";s:1:"1";}i:16;a:3:{s:4:"name";s:13:"featuredimage";s:9:"depend_on";s:0:"";s:6:"active";s:1:"1";}i:17;a:3:{s:4:"name";s:13:"featuredthumb";s:9:"depend_on";s:0:"";s:6:"active";s:1:"1";}i:18;a:3:{s:4:"name";s:8:"category";s:9:"depend_on";s:13:"25@categories";s:6:"active";s:1:"1";}i:19;a:3:{s:4:"name";s:4:"tags";s:9:"depend_on";s:0:"";s:6:"active";s:1:"1";}i:20;a:3:{s:4:"name";s:6:"author";s:9:"depend_on";s:9:"5@authors";s:6:"active";s:1:"1";}i:21;a:3:{s:4:"name";s:11:"post_format";s:9:"depend_on";s:0:"";s:6:"active";s:1:"1";}i:22;a:3:{s:4:"name";s:13:"custom_fields";s:9:"depend_on";s:0:"";s:6:"active";s:1:"1";}i:23;a:3:{s:4:"name";s:8:"postmeta";s:9:"depend_on";s:0:"";s:6:"active";s:1:"1";}i:24;a:3:{s:4:"name";s:10:"taxonomies";s:9:"depend_on";s:0:"";s:6:"active";s:1:"1";}}','access_level' => 'a:1:{i:0;s:6:"anyone";}','active' => '1'),
  array('id' => '17','name' => 'getpost','description' => 'View post by id','scope' => 'posts','group' => 'getposts','params' => 'a:26:{i:0;a:3:{s:4:"name";s:2:"ID";s:9:"depend_on";s:0:"";s:6:"active";s:1:"1";}i:1;a:3:{s:4:"name";s:10:"post_title";s:9:"depend_on";s:0:"";s:6:"active";s:1:"1";}i:2;a:3:{s:4:"name";s:4:"guid";s:9:"depend_on";s:0:"";s:6:"active";s:1:"1";}i:3;a:3:{s:4:"name";s:12:"post_content";s:9:"depend_on";s:0:"";s:6:"active";s:1:"1";}i:4;a:3:{s:4:"name";s:11:"post_author";s:9:"depend_on";s:0:"";s:6:"active";s:1:"1";}i:5;a:3:{s:4:"name";s:9:"post_date";s:9:"depend_on";s:0:"";s:6:"active";s:1:"1";}i:6;a:3:{s:4:"name";s:13:"post_date_gmt";s:9:"depend_on";s:0:"";s:6:"active";s:1:"1";}i:7;a:3:{s:4:"name";s:14:"comment_status";s:9:"depend_on";s:0:"";s:6:"active";s:1:"1";}i:8;a:3:{s:4:"name";s:11:"ping_status";s:9:"depend_on";s:0:"";s:6:"active";s:1:"1";}i:9;a:3:{s:4:"name";s:9:"post_name";s:9:"depend_on";s:0:"";s:6:"active";s:1:"1";}i:10;a:3:{s:4:"name";s:13:"post_modified";s:9:"depend_on";s:0:"";s:6:"active";s:1:"1";}i:11;a:3:{s:4:"name";s:17:"post_modified_gmt";s:9:"depend_on";s:0:"";s:6:"active";s:1:"1";}i:12;a:3:{s:4:"name";s:21:"post_content_filtered";s:9:"depend_on";s:0:"";s:6:"active";s:1:"1";}i:13;a:3:{s:4:"name";s:11:"post_parent";s:9:"depend_on";s:0:"";s:6:"active";s:1:"1";}i:14;a:3:{s:4:"name";s:10:"menu_order";s:9:"depend_on";s:0:"";s:6:"active";s:1:"1";}i:15;a:3:{s:4:"name";s:13:"comment_count";s:9:"depend_on";s:0:"";s:6:"active";s:1:"1";}i:16;a:3:{s:4:"name";s:13:"featuredimage";s:9:"depend_on";s:0:"";s:6:"active";s:1:"1";}i:17;a:3:{s:4:"name";s:13:"featuredthumb";s:9:"depend_on";s:0:"";s:6:"active";s:1:"1";}i:18;a:3:{s:4:"name";s:8:"category";s:9:"depend_on";s:13:"25@categories";s:6:"active";s:1:"1";}i:19;a:3:{s:4:"name";s:4:"tags";s:9:"depend_on";s:0:"";s:6:"active";s:1:"1";}i:20;a:3:{s:4:"name";s:6:"author";s:9:"depend_on";s:9:"5@authors";s:6:"active";s:1:"1";}i:21;a:3:{s:4:"name";s:11:"post_format";s:9:"depend_on";s:0:"";s:6:"active";s:1:"1";}i:22;a:3:{s:4:"name";s:13:"custom_fields";s:9:"depend_on";s:0:"";s:6:"active";s:1:"1";}i:23;a:3:{s:4:"name";s:8:"postmeta";s:9:"depend_on";s:0:"";s:6:"active";s:1:"1";}i:24;a:3:{s:4:"name";s:10:"taxonomies";s:9:"depend_on";s:0:"";s:6:"active";s:1:"1";}i:25;a:3:{s:4:"name";s:5:"video";s:9:"depend_on";s:0:"";s:6:"active";s:1:"1";}}','access_level' => 'a:1:{i:0;s:6:"anyone";}','active' => '1'),
  array('id' => '18','name' => 'get_archive','description' => 'Archive','scope' => 'posts','group' => '','params' => 'a:4:{i:0;a:3:{s:4:"name";s:4:"text";s:9:"depend_on";s:0:"";s:6:"active";s:1:"1";}i:1;a:3:{s:4:"name";s:4:"year";s:9:"depend_on";s:0:"";s:6:"active";s:1:"1";}i:2;a:3:{s:4:"name";s:5:"month";s:9:"depend_on";s:0:"";s:6:"active";s:1:"1";}i:3;a:3:{s:4:"name";s:5:"count";s:9:"depend_on";s:0:"";s:6:"active";s:1:"1";}}','access_level' => 'a:1:{i:0;s:6:"anyone";}','active' => '1'),
  array('id' => '19','name' => 'get_posts_archive','description' => 'Get posts by archive time','scope' => 'posts','group' => 'getposts','params' => 'a:25:{i:0;a:3:{s:4:"name";s:2:"ID";s:9:"depend_on";s:0:"";s:6:"active";s:1:"1";}i:1;a:3:{s:4:"name";s:10:"post_title";s:9:"depend_on";s:0:"";s:6:"active";s:1:"1";}i:2;a:3:{s:4:"name";s:4:"guid";s:9:"depend_on";s:0:"";s:6:"active";s:1:"1";}i:3;a:3:{s:4:"name";s:12:"post_content";s:9:"depend_on";s:0:"";s:6:"active";s:1:"1";}i:4;a:3:{s:4:"name";s:11:"post_author";s:9:"depend_on";s:0:"";s:6:"active";s:1:"1";}i:5;a:3:{s:4:"name";s:9:"post_date";s:9:"depend_on";s:0:"";s:6:"active";s:1:"1";}i:6;a:3:{s:4:"name";s:13:"post_date_gmt";s:9:"depend_on";s:0:"";s:6:"active";s:1:"1";}i:7;a:3:{s:4:"name";s:14:"comment_status";s:9:"depend_on";s:0:"";s:6:"active";s:1:"1";}i:8;a:3:{s:4:"name";s:11:"ping_status";s:9:"depend_on";s:0:"";s:6:"active";s:1:"1";}i:9;a:3:{s:4:"name";s:9:"post_name";s:9:"depend_on";s:0:"";s:6:"active";s:1:"1";}i:10;a:3:{s:4:"name";s:13:"post_modified";s:9:"depend_on";s:0:"";s:6:"active";s:1:"1";}i:11;a:3:{s:4:"name";s:17:"post_modified_gmt";s:9:"depend_on";s:0:"";s:6:"active";s:1:"1";}i:12;a:3:{s:4:"name";s:21:"post_content_filtered";s:9:"depend_on";s:0:"";s:6:"active";s:1:"1";}i:13;a:3:{s:4:"name";s:11:"post_parent";s:9:"depend_on";s:0:"";s:6:"active";s:1:"1";}i:14;a:3:{s:4:"name";s:10:"menu_order";s:9:"depend_on";s:0:"";s:6:"active";s:1:"1";}i:15;a:3:{s:4:"name";s:13:"comment_count";s:9:"depend_on";s:0:"";s:6:"active";s:1:"1";}i:16;a:3:{s:4:"name";s:13:"featuredimage";s:9:"depend_on";s:0:"";s:6:"active";s:1:"1";}i:17;a:3:{s:4:"name";s:13:"featuredthumb";s:9:"depend_on";s:0:"";s:6:"active";s:1:"1";}i:18;a:3:{s:4:"name";s:8:"category";s:9:"depend_on";s:13:"25@categories";s:6:"active";s:1:"1";}i:19;a:3:{s:4:"name";s:4:"tags";s:9:"depend_on";s:0:"";s:6:"active";s:1:"1";}i:20;a:3:{s:4:"name";s:6:"author";s:9:"depend_on";s:9:"5@authors";s:6:"active";s:1:"1";}i:21;a:3:{s:4:"name";s:11:"post_format";s:9:"depend_on";s:0:"";s:6:"active";s:1:"1";}i:22;a:3:{s:4:"name";s:13:"custom_fields";s:9:"depend_on";s:0:"";s:6:"active";s:1:"1";}i:23;a:3:{s:4:"name";s:8:"postmeta";s:9:"depend_on";s:0:"";s:6:"active";s:1:"1";}i:24;a:3:{s:4:"name";s:10:"taxonomies";s:9:"depend_on";s:0:"";s:6:"active";s:1:"1";}}','access_level' => 'a:1:{i:0;s:6:"anyone";}','active' => '1'),
  array('id' => '20','name' => 'getComments','description' => 'Get comments of post','scope' => 'comments','group' => 'getComments','params' => 'a:15:{i:0;a:3:{s:4:"name";s:10:"comment_ID";s:9:"depend_on";s:0:"";s:6:"active";s:1:"1";}i:1;a:3:{s:4:"name";s:15:"comment_post_ID";s:9:"depend_on";s:0:"";s:6:"active";s:1:"1";}i:2;a:3:{s:4:"name";s:14:"comment_author";s:9:"depend_on";s:0:"";s:6:"active";s:1:"1";}i:3;a:3:{s:4:"name";s:20:"comment_author_email";s:9:"depend_on";s:0:"";s:6:"active";s:1:"1";}i:4;a:3:{s:4:"name";s:18:"comment_author_url";s:9:"depend_on";s:0:"";s:6:"active";s:1:"1";}i:5;a:3:{s:4:"name";s:17:"comment_author_IP";s:9:"depend_on";s:0:"";s:6:"active";s:1:"1";}i:6;a:3:{s:4:"name";s:12:"comment_date";s:9:"depend_on";s:0:"";s:6:"active";s:1:"1";}i:7;a:3:{s:4:"name";s:16:"comment_date_gmt";s:9:"depend_on";s:0:"";s:6:"active";s:1:"1";}i:8;a:3:{s:4:"name";s:15:"comment_content";s:9:"depend_on";s:0:"";s:6:"active";s:1:"1";}i:9;a:3:{s:4:"name";s:13:"comment_agent";s:9:"depend_on";s:0:"";s:6:"active";s:1:"1";}i:10;a:3:{s:4:"name";s:16:"comment_approved";s:9:"depend_on";s:0:"";s:6:"active";s:1:"1";}i:11;a:3:{s:4:"name";s:7:"user_id";s:9:"depend_on";s:0:"";s:6:"active";s:1:"1";}i:12;a:3:{s:4:"name";s:12:"childcomment";s:9:"depend_on";s:0:"";s:6:"active";s:1:"1";}i:13;a:3:{s:4:"name";s:6:"author";s:9:"depend_on";s:9:"5@authors";s:6:"active";s:1:"1";}i:14;a:3:{s:4:"name";s:11:"commentmeta";s:9:"depend_on";s:0:"";s:6:"active";s:1:"1";}}','access_level' => 'a:1:{i:0;s:6:"anyone";}','active' => '1'),
  array('id' => '21','name' => 'newcomment','description' => 'Comment in post','scope' => 'publish_comments','group' => '','params' => '','access_level' => 'a:1:{i:0;s:6:"anyone";}','active' => '1'),
  array('id' => '22','name' => 'last_comments','description' => 'Last comments in blog','scope' => 'comments','group' => 'getComments','params' => 'a:15:{i:0;a:3:{s:4:"name";s:10:"comment_ID";s:9:"depend_on";s:0:"";s:6:"active";s:1:"1";}i:1;a:3:{s:4:"name";s:15:"comment_post_ID";s:9:"depend_on";s:0:"";s:6:"active";s:1:"1";}i:2;a:3:{s:4:"name";s:14:"comment_author";s:9:"depend_on";s:0:"";s:6:"active";s:1:"1";}i:3;a:3:{s:4:"name";s:20:"comment_author_email";s:9:"depend_on";s:0:"";s:6:"active";s:1:"1";}i:4;a:3:{s:4:"name";s:18:"comment_author_url";s:9:"depend_on";s:0:"";s:6:"active";s:1:"1";}i:5;a:3:{s:4:"name";s:17:"comment_author_IP";s:9:"depend_on";s:0:"";s:6:"active";s:1:"1";}i:6;a:3:{s:4:"name";s:12:"comment_date";s:9:"depend_on";s:0:"";s:6:"active";s:1:"1";}i:7;a:3:{s:4:"name";s:16:"comment_date_gmt";s:9:"depend_on";s:0:"";s:6:"active";s:1:"1";}i:8;a:3:{s:4:"name";s:15:"comment_content";s:9:"depend_on";s:0:"";s:6:"active";s:1:"1";}i:9;a:3:{s:4:"name";s:13:"comment_agent";s:9:"depend_on";s:0:"";s:6:"active";s:1:"1";}i:10;a:3:{s:4:"name";s:16:"comment_approved";s:9:"depend_on";s:0:"";s:6:"active";s:1:"1";}i:11;a:3:{s:4:"name";s:7:"user_id";s:9:"depend_on";s:0:"";s:6:"active";s:1:"1";}i:12;a:3:{s:4:"name";s:12:"childcomment";s:9:"depend_on";s:0:"";s:6:"active";s:1:"1";}i:13;a:3:{s:4:"name";s:6:"author";s:9:"depend_on";s:9:"5@authors";s:6:"active";s:1:"1";}i:14;a:3:{s:4:"name";s:11:"commentmeta";s:9:"depend_on";s:0:"";s:6:"active";s:1:"1";}}','access_level' => 'a:1:{i:0;s:6:"anyone";}','active' => '1'),
  array('id' => '23','name' => 'get_comment','description' => 'View comment by id','scope' => 'comments','group' => 'getComments','params' => 'a:15:{i:0;a:3:{s:4:"name";s:10:"comment_ID";s:9:"depend_on";s:0:"";s:6:"active";s:1:"1";}i:1;a:3:{s:4:"name";s:15:"comment_post_ID";s:9:"depend_on";s:0:"";s:6:"active";s:1:"1";}i:2;a:3:{s:4:"name";s:14:"comment_author";s:9:"depend_on";s:0:"";s:6:"active";s:1:"1";}i:3;a:3:{s:4:"name";s:20:"comment_author_email";s:9:"depend_on";s:0:"";s:6:"active";s:1:"1";}i:4;a:3:{s:4:"name";s:18:"comment_author_url";s:9:"depend_on";s:0:"";s:6:"active";s:1:"1";}i:5;a:3:{s:4:"name";s:17:"comment_author_IP";s:9:"depend_on";s:0:"";s:6:"active";s:1:"1";}i:6;a:3:{s:4:"name";s:12:"comment_date";s:9:"depend_on";s:0:"";s:6:"active";s:1:"1";}i:7;a:3:{s:4:"name";s:16:"comment_date_gmt";s:9:"depend_on";s:0:"";s:6:"active";s:1:"1";}i:8;a:3:{s:4:"name";s:15:"comment_content";s:9:"depend_on";s:0:"";s:6:"active";s:1:"1";}i:9;a:3:{s:4:"name";s:13:"comment_agent";s:9:"depend_on";s:0:"";s:6:"active";s:1:"1";}i:10;a:3:{s:4:"name";s:16:"comment_approved";s:9:"depend_on";s:0:"";s:6:"active";s:1:"1";}i:11;a:3:{s:4:"name";s:7:"user_id";s:9:"depend_on";s:0:"";s:6:"active";s:1:"1";}i:12;a:3:{s:4:"name";s:12:"childcomment";s:9:"depend_on";s:0:"";s:6:"active";s:1:"1";}i:13;a:3:{s:4:"name";s:6:"author";s:9:"depend_on";s:9:"5@authors";s:6:"active";s:1:"1";}i:14;a:3:{s:4:"name";s:11:"commentmeta";s:9:"depend_on";s:0:"";s:6:"active";s:1:"1";}}','access_level' => 'a:1:{i:0;s:6:"anyone";}','active' => '1'),
  array('id' => '24','name' => 'getpages','description' => 'Get a list of pages','scope' => 'core','group' => 'getpages','params' => 'a:25:{i:0;a:3:{s:4:"name";s:2:"ID";s:9:"depend_on";s:0:"";s:6:"active";s:1:"1";}i:1;a:3:{s:4:"name";s:10:"post_title";s:9:"depend_on";s:0:"";s:6:"active";s:1:"1";}i:2;a:3:{s:4:"name";s:4:"guid";s:9:"depend_on";s:0:"";s:6:"active";s:1:"1";}i:3;a:3:{s:4:"name";s:12:"post_content";s:9:"depend_on";s:0:"";s:6:"active";s:1:"1";}i:4;a:3:{s:4:"name";s:11:"post_author";s:9:"depend_on";s:0:"";s:6:"active";s:1:"1";}i:5;a:3:{s:4:"name";s:9:"post_date";s:9:"depend_on";s:0:"";s:6:"active";s:1:"1";}i:6;a:3:{s:4:"name";s:13:"post_date_gmt";s:9:"depend_on";s:0:"";s:6:"active";s:1:"1";}i:7;a:3:{s:4:"name";s:14:"comment_status";s:9:"depend_on";s:0:"";s:6:"active";s:1:"1";}i:8;a:3:{s:4:"name";s:11:"ping_status";s:9:"depend_on";s:0:"";s:6:"active";s:1:"1";}i:9;a:3:{s:4:"name";s:9:"post_name";s:9:"depend_on";s:0:"";s:6:"active";s:1:"1";}i:10;a:3:{s:4:"name";s:13:"post_modified";s:9:"depend_on";s:0:"";s:6:"active";s:1:"1";}i:11;a:3:{s:4:"name";s:17:"post_modified_gmt";s:9:"depend_on";s:0:"";s:6:"active";s:1:"1";}i:12;a:3:{s:4:"name";s:21:"post_content_filtered";s:9:"depend_on";s:0:"";s:6:"active";s:1:"1";}i:13;a:3:{s:4:"name";s:11:"post_parent";s:9:"depend_on";s:0:"";s:6:"active";s:1:"1";}i:14;a:3:{s:4:"name";s:10:"menu_order";s:9:"depend_on";s:0:"";s:6:"active";s:1:"1";}i:15;a:3:{s:4:"name";s:13:"comment_count";s:9:"depend_on";s:0:"";s:6:"active";s:1:"1";}i:16;a:3:{s:4:"name";s:13:"featuredimage";s:9:"depend_on";s:0:"";s:6:"active";s:1:"1";}i:17;a:3:{s:4:"name";s:13:"featuredthumb";s:9:"depend_on";s:0:"";s:6:"active";s:1:"1";}i:18;a:3:{s:4:"name";s:8:"category";s:9:"depend_on";s:13:"25@categories";s:6:"active";s:1:"1";}i:19;a:3:{s:4:"name";s:4:"tags";s:9:"depend_on";s:0:"";s:6:"active";s:1:"1";}i:20;a:3:{s:4:"name";s:6:"author";s:9:"depend_on";s:9:"5@authors";s:6:"active";s:1:"1";}i:21;a:3:{s:4:"name";s:11:"post_format";s:9:"depend_on";s:0:"";s:6:"active";s:1:"1";}i:22;a:3:{s:4:"name";s:13:"custom_fields";s:9:"depend_on";s:0:"";s:6:"active";s:1:"1";}i:23;a:3:{s:4:"name";s:8:"postmeta";s:9:"depend_on";s:0:"";s:6:"active";s:1:"1";}i:24;a:3:{s:4:"name";s:10:"taxonomies";s:9:"depend_on";s:0:"";s:6:"active";s:1:"1";}}','access_level' => 'a:1:{i:0;s:6:"anyone";}','active' => '1'),
  array('id' => '25','name' => 'getpage','description' => 'View page by id','scope' => 'core','group' => 'getpages','params' => 'a:26:{i:0;a:3:{s:4:"name";s:2:"ID";s:9:"depend_on";s:0:"";s:6:"active";s:1:"1";}i:1;a:3:{s:4:"name";s:10:"post_title";s:9:"depend_on";s:0:"";s:6:"active";s:1:"1";}i:2;a:3:{s:4:"name";s:4:"guid";s:9:"depend_on";s:0:"";s:6:"active";s:1:"1";}i:3;a:3:{s:4:"name";s:12:"post_content";s:9:"depend_on";s:0:"";s:6:"active";s:1:"1";}i:4;a:3:{s:4:"name";s:11:"post_author";s:9:"depend_on";s:0:"";s:6:"active";s:1:"1";}i:5;a:3:{s:4:"name";s:9:"post_date";s:9:"depend_on";s:0:"";s:6:"active";s:1:"1";}i:6;a:3:{s:4:"name";s:13:"post_date_gmt";s:9:"depend_on";s:0:"";s:6:"active";s:1:"1";}i:7;a:3:{s:4:"name";s:14:"comment_status";s:9:"depend_on";s:0:"";s:6:"active";s:1:"1";}i:8;a:3:{s:4:"name";s:11:"ping_status";s:9:"depend_on";s:0:"";s:6:"active";s:1:"1";}i:9;a:3:{s:4:"name";s:9:"post_name";s:9:"depend_on";s:0:"";s:6:"active";s:1:"1";}i:10;a:3:{s:4:"name";s:13:"post_modified";s:9:"depend_on";s:0:"";s:6:"active";s:1:"1";}i:11;a:3:{s:4:"name";s:17:"post_modified_gmt";s:9:"depend_on";s:0:"";s:6:"active";s:1:"1";}i:12;a:3:{s:4:"name";s:21:"post_content_filtered";s:9:"depend_on";s:0:"";s:6:"active";s:1:"1";}i:13;a:3:{s:4:"name";s:11:"post_parent";s:9:"depend_on";s:0:"";s:6:"active";s:1:"1";}i:14;a:3:{s:4:"name";s:10:"menu_order";s:9:"depend_on";s:0:"";s:6:"active";s:1:"1";}i:15;a:3:{s:4:"name";s:13:"comment_count";s:9:"depend_on";s:0:"";s:6:"active";s:1:"1";}i:16;a:3:{s:4:"name";s:13:"featuredimage";s:9:"depend_on";s:0:"";s:6:"active";s:1:"1";}i:17;a:3:{s:4:"name";s:13:"featuredthumb";s:9:"depend_on";s:0:"";s:6:"active";s:1:"1";}i:18;a:3:{s:4:"name";s:8:"category";s:9:"depend_on";s:13:"25@categories";s:6:"active";s:1:"1";}i:19;a:3:{s:4:"name";s:4:"tags";s:9:"depend_on";s:0:"";s:6:"active";s:1:"1";}i:20;a:3:{s:4:"name";s:6:"author";s:9:"depend_on";s:9:"5@authors";s:6:"active";s:1:"1";}i:21;a:3:{s:4:"name";s:11:"post_format";s:9:"depend_on";s:0:"";s:6:"active";s:1:"1";}i:22;a:3:{s:4:"name";s:13:"custom_fields";s:9:"depend_on";s:0:"";s:6:"active";s:1:"1";}i:23;a:3:{s:4:"name";s:8:"postmeta";s:9:"depend_on";s:0:"";s:6:"active";s:1:"1";}i:24;a:3:{s:4:"name";s:10:"taxonomies";s:9:"depend_on";s:0:"";s:6:"active";s:1:"1";}i:25;a:3:{s:4:"name";s:5:"video";s:9:"depend_on";s:0:"";s:6:"active";s:1:"1";}}','access_level' => 'a:1:{i:0;s:6:"anyone";}','active' => '1'),
  array('id' => '26','name' => 'categories','description' => 'Get a list of all categories','scope' => 'taxonomies','group' => 'categories','params' => 'a:11:{i:0;a:3:{s:4:"name";s:2:"id";s:9:"depend_on";s:0:"";s:6:"active";s:1:"1";}i:1;a:3:{s:4:"name";s:4:"name";s:9:"depend_on";s:0:"";s:6:"active";s:1:"1";}i:2;a:3:{s:4:"name";s:4:"slug";s:9:"depend_on";s:0:"";s:6:"active";s:1:"1";}i:3;a:3:{s:4:"name";s:11:"description";s:9:"depend_on";s:0:"";s:6:"active";s:1:"1";}i:4;a:3:{s:4:"name";s:5:"count";s:9:"depend_on";s:0:"";s:6:"active";s:1:"1";}i:5;a:3:{s:4:"name";s:6:"parent";s:9:"depend_on";s:0:"";s:6:"active";s:1:"1";}i:6;a:3:{s:4:"name";s:5:"image";s:9:"depend_on";s:0:"";s:6:"active";s:1:"1";}i:7;a:3:{s:4:"name";s:11:"subcategory";s:9:"depend_on";s:0:"";s:6:"active";s:1:"1";}i:8;a:3:{s:4:"name";s:13:"custom_fields";s:9:"depend_on";s:0:"";s:6:"active";s:1:"1";}i:9;a:3:{s:4:"name";s:13:"custom_fields";s:9:"depend_on";s:0:"";s:6:"active";s:1:"1";}i:10;a:3:{s:4:"name";s:13:"custom_fields";s:9:"depend_on";s:0:"";s:6:"active";s:1:"1";}}','access_level' => 'a:1:{i:0;s:6:"anyone";}','active' => '1'),
  array('id' => '27','name' => 'viewcategory','description' => 'View category by id','scope' => 'taxonomies','group' => 'categories','params' => 'a:8:{i:0;a:3:{s:4:"name";s:2:"id";s:9:"depend_on";s:0:"";s:6:"active";s:1:"1";}i:1;a:3:{s:4:"name";s:4:"name";s:9:"depend_on";s:0:"";s:6:"active";s:1:"1";}i:2;a:3:{s:4:"name";s:4:"slug";s:9:"depend_on";s:0:"";s:6:"active";s:1:"1";}i:3;a:3:{s:4:"name";s:11:"description";s:9:"depend_on";s:0:"";s:6:"active";s:1:"1";}i:4;a:3:{s:4:"name";s:5:"count";s:9:"depend_on";s:0:"";s:6:"active";s:1:"1";}i:5;a:3:{s:4:"name";s:6:"parent";s:9:"depend_on";s:0:"";s:6:"active";s:1:"1";}i:6;a:3:{s:4:"name";s:5:"image";s:9:"depend_on";s:0:"";s:6:"active";s:1:"1";}i:7;a:3:{s:4:"name";s:11:"subcategory";s:9:"depend_on";s:0:"";s:6:"active";s:1:"1";}}','access_level' => 'a:1:{i:0;s:6:"anyone";}','active' => '1'),
  array('id' => '28','name' => 'get_taxonomies','description' => 'Get a list of all custom taxonomies','scope' => 'core','group' => '','params' => 'a:1:{i:0;a:3:{s:4:"name";s:14:"get_taxonomies";s:9:"depend_on";s:13:"25@categories";s:6:"active";s:1:"1";}}','access_level' => 'a:1:{i:0;s:6:"anyone";}','active' => '1'),
  array('id' => '29','name' => 'get_taxonomy','description' => 'View custom taxonomy object','scope' => 'taxonomies','group' => '','params' => 'a:8:{i:0;a:3:{s:4:"name";s:2:"id";s:9:"depend_on";s:0:"";s:6:"active";s:1:"1";}i:1;a:3:{s:4:"name";s:4:"name";s:9:"depend_on";s:0:"";s:6:"active";s:1:"1";}i:2;a:3:{s:4:"name";s:4:"slug";s:9:"depend_on";s:0:"";s:6:"active";s:1:"1";}i:3;a:3:{s:4:"name";s:11:"description";s:9:"depend_on";s:0:"";s:6:"active";s:1:"1";}i:4;a:3:{s:4:"name";s:5:"count";s:9:"depend_on";s:0:"";s:6:"active";s:1:"1";}i:5;a:3:{s:4:"name";s:6:"parent";s:9:"depend_on";s:0:"";s:6:"active";s:1:"1";}i:6;a:3:{s:4:"name";s:5:"image";s:9:"depend_on";s:0:"";s:6:"active";s:1:"1";}i:7;a:3:{s:4:"name";s:11:"subcategory";s:9:"depend_on";s:0:"";s:6:"active";s:1:"1";}}','access_level' => 'a:1:{i:0;s:6:"anyone";}','active' => '1'),
  array('id' => '30','name' => 'tags','description' => 'Get a list of all tags','scope' => 'taxonomies','group' => '','params' => 'a:6:{i:0;a:3:{s:4:"name";s:2:"id";s:9:"depend_on";s:0:"";s:6:"active";s:1:"1";}i:1;a:3:{s:4:"name";s:4:"name";s:9:"depend_on";s:0:"";s:6:"active";s:1:"1";}i:2;a:3:{s:4:"name";s:4:"slug";s:9:"depend_on";s:0:"";s:6:"active";s:1:"1";}i:3;a:3:{s:4:"name";s:11:"description";s:9:"depend_on";s:0:"";s:6:"active";s:1:"1";}i:4;a:3:{s:4:"name";s:5:"count";s:9:"depend_on";s:0:"";s:6:"active";s:1:"1";}i:5;a:3:{s:4:"name";s:6:"parent";s:9:"depend_on";s:0:"";s:6:"active";s:1:"1";}}','access_level' => 'a:1:{i:0;s:6:"anyone";}','active' => '1'),
  array('id' => '31','name' => 'tag_posts','description' => 'Get posts by tag','scope' => 'posts','group' => 'getposts','params' => 'a:25:{i:0;a:3:{s:4:"name";s:2:"ID";s:9:"depend_on";s:0:"";s:6:"active";s:1:"1";}i:1;a:3:{s:4:"name";s:10:"post_title";s:9:"depend_on";s:0:"";s:6:"active";s:1:"1";}i:2;a:3:{s:4:"name";s:4:"guid";s:9:"depend_on";s:0:"";s:6:"active";s:1:"1";}i:3;a:3:{s:4:"name";s:12:"post_content";s:9:"depend_on";s:0:"";s:6:"active";s:1:"1";}i:4;a:3:{s:4:"name";s:11:"post_author";s:9:"depend_on";s:0:"";s:6:"active";s:1:"1";}i:5;a:3:{s:4:"name";s:9:"post_date";s:9:"depend_on";s:0:"";s:6:"active";s:1:"1";}i:6;a:3:{s:4:"name";s:13:"post_date_gmt";s:9:"depend_on";s:0:"";s:6:"active";s:1:"1";}i:7;a:3:{s:4:"name";s:14:"comment_status";s:9:"depend_on";s:0:"";s:6:"active";s:1:"1";}i:8;a:3:{s:4:"name";s:11:"ping_status";s:9:"depend_on";s:0:"";s:6:"active";s:1:"1";}i:9;a:3:{s:4:"name";s:9:"post_name";s:9:"depend_on";s:0:"";s:6:"active";s:1:"1";}i:10;a:3:{s:4:"name";s:13:"post_modified";s:9:"depend_on";s:0:"";s:6:"active";s:1:"1";}i:11;a:3:{s:4:"name";s:17:"post_modified_gmt";s:9:"depend_on";s:0:"";s:6:"active";s:1:"1";}i:12;a:3:{s:4:"name";s:21:"post_content_filtered";s:9:"depend_on";s:0:"";s:6:"active";s:1:"1";}i:13;a:3:{s:4:"name";s:11:"post_parent";s:9:"depend_on";s:0:"";s:6:"active";s:1:"1";}i:14;a:3:{s:4:"name";s:10:"menu_order";s:9:"depend_on";s:0:"";s:6:"active";s:1:"1";}i:15;a:3:{s:4:"name";s:13:"comment_count";s:9:"depend_on";s:0:"";s:6:"active";s:1:"1";}i:16;a:3:{s:4:"name";s:13:"featuredimage";s:9:"depend_on";s:0:"";s:6:"active";s:1:"1";}i:17;a:3:{s:4:"name";s:13:"featuredthumb";s:9:"depend_on";s:0:"";s:6:"active";s:1:"1";}i:18;a:3:{s:4:"name";s:8:"category";s:9:"depend_on";s:13:"25@categories";s:6:"active";s:1:"1";}i:19;a:3:{s:4:"name";s:4:"tags";s:9:"depend_on";s:0:"";s:6:"active";s:1:"1";}i:20;a:3:{s:4:"name";s:6:"author";s:9:"depend_on";s:9:"5@authors";s:6:"active";s:1:"1";}i:21;a:3:{s:4:"name";s:11:"post_format";s:9:"depend_on";s:0:"";s:6:"active";s:1:"1";}i:22;a:3:{s:4:"name";s:13:"custom_fields";s:9:"depend_on";s:0:"";s:6:"active";s:1:"1";}i:23;a:3:{s:4:"name";s:8:"postmeta";s:9:"depend_on";s:0:"";s:6:"active";s:1:"1";}i:24;a:3:{s:4:"name";s:10:"taxonomies";s:9:"depend_on";s:0:"";s:6:"active";s:1:"1";}}','access_level' => 'a:1:{i:0;s:6:"anyone";}','active' => '1'),
  array('id' => '32','name' => 'social_links','description' => 'Social accounts links and stats','scope' => 'public','group' => '','params' => '','access_level' => 'a:1:{i:0;s:6:"anyone";}','active' => '1'),
  array('id' => '33','name' => 'bloginfo','description' => 'Blog options and information','scope' => 'core','group' => '','params' => 'a:8:{i:0;a:3:{s:4:"name";s:8:"blogname";s:9:"depend_on";s:0:"";s:6:"active";s:1:"1";}i:1;a:3:{s:4:"name";s:15:"blogdescription";s:9:"depend_on";s:0:"";s:6:"active";s:1:"1";}i:2;a:3:{s:4:"name";s:11:"admin_email";s:9:"depend_on";s:0:"";s:6:"active";s:1:"1";}i:3;a:3:{s:4:"name";s:7:"siteurl";s:9:"depend_on";s:0:"";s:6:"active";s:1:"1";}i:4;a:3:{s:4:"name";s:4:"home";s:9:"depend_on";s:0:"";s:6:"active";s:1:"1";}i:5;a:3:{s:4:"name";s:16:"default_category";s:9:"depend_on";s:0:"";s:6:"active";s:1:"1";}i:6;a:3:{s:4:"name";s:13:"start_of_week";s:9:"depend_on";s:0:"";s:6:"active";s:1:"1";}i:7;a:3:{s:4:"name";s:18:"require_name_email";s:9:"depend_on";s:0:"";s:6:"active";s:1:"1";}}','access_level' => 'a:1:{i:0;s:6:"anyone";}','active' => '1'),
  array('id' => '34','name' => 'contactus','description' => 'Contact Wordpress administrator','scope' => 'public','group' => '','params' => '','access_level' => 'a:1:{i:0;s:6:"anyone";}','active' => '1'),
  array('id' => '35','name' => 'custom_service','description' => 'Call one of the custom services you made','scope' => 'public','group' => '','params' => '','access_level' => 'a:1:{i:0;s:6:"anyone";}','active' => '1'),
  array('id' => '36','name' => 'custom_options','description' => 'Get a list of all custom options value','scope' => 'public','group' => '','params' => '','access_level' => 'a:1:{i:0;s:6:"anyone";}','active' => '1'),
  array('id' => '37','name' => 'savetoken','description' => 'Save new device token','scope' => 'public','group' => '','params' => '','access_level' => 'a:1:{i:0;s:6:"anyone";}','active' => '1'),
  array('id' => '38','name' => 'channels_subscribe','description' => 'Edit the device subscription in channels','scope' => 'public','group' => '','params' => '','access_level' => 'a:1:{i:0;s:6:"anyone";}','active' => '1'),
  array('id' => '39','name' => 'device_channels','description' => 'Get a list of channels and whichever device subscribed','scope' => 'public','group' => '','params' => '','access_level' => 'a:1:{i:0;s:6:"anyone";}','active' => '1'),
  array('id' => '40','name' => 'get_channels','description' => 'Get the list of all channels','scope' => 'public','group' => '','params' => '','access_level' => 'a:1:{i:0;s:6:"anyone";}','active' => '1'),
  array('id' => '41','name' => 'debug','description' => 'Show plugin version and working status','scope' => 'public','group' => '','params' => '','access_level' => 'a:1:{i:0;s:6:"anyone";}','active' => '1'),
  array('id' => '42','name' => 'network_sites','description' => 'Display the list of network sites','scope' => 'core','group' => '','params' => 'a:10:{i:0;a:3:{s:4:"name";s:7:"blog_id";s:9:"depend_on";s:0:"";s:6:"active";s:1:"1";}i:1;a:3:{s:4:"name";s:8:"blogname";s:9:"depend_on";s:0:"";s:6:"active";s:1:"1";}i:2;a:3:{s:4:"name";s:7:"siteurl";s:9:"depend_on";s:0:"";s:6:"active";s:1:"1";}i:3;a:3:{s:4:"name";s:7:"site_id";s:9:"depend_on";s:0:"";s:6:"active";s:1:"1";}i:4;a:3:{s:4:"name";s:6:"domain";s:9:"depend_on";s:0:"";s:6:"active";s:1:"1";}i:5;a:3:{s:4:"name";s:4:"path";s:9:"depend_on";s:0:"";s:6:"active";s:1:"1";}i:6;a:3:{s:4:"name";s:10:"registered";s:9:"depend_on";s:0:"";s:6:"active";s:1:"1";}i:7;a:3:{s:4:"name";s:6:"public";s:9:"depend_on";s:0:"";s:6:"active";s:1:"1";}i:8;a:3:{s:4:"name";s:7:"lang_id";s:9:"depend_on";s:0:"";s:6:"active";s:1:"1";}i:9;a:3:{s:4:"name";s:10:"post_count";s:9:"depend_on";s:0:"";s:6:"active";s:1:"1";}}','access_level' => 'a:1:{i:0;s:6:"anyone";}','active' => '1'),
  array('id' => '43','name' => 'changepwd','description' => 'Change user password','scope' => 'edit_profile','group' => '','params' => '','access_level' => 'a:1:{i:0;s:6:"logged";}','active' => '1'),
  array('id' => '44','name' => 'profile_image','description' => 'Change user profile image','scope' => 'edit_profile','group' => '','params' => '','access_level' => 'a:1:{i:0;s:6:"logged";}','active' => '1'),
  array('id' => '45','name' => 'post_status','description' => 'Change the post status','scope' => 'manage_posts','group' => 'management','params' => '','access_level' => 'a:1:{i:0;s:13:"administrator";}','active' => '1'),
  array('id' => '46','name' => 'comment_status','description' => 'Change the comment status','scope' => 'manage_comments','group' => 'management','params' => '','access_level' => 'a:1:{i:0;s:13:"administrator";}','active' => '1'),
  array('id' => '47','name' => 'delete_user','description' => 'Delete user permanently','scope' => 'core','group' => 'management','params' => '','access_level' => 'a:1:{i:0;s:13:"administrator";}','active' => '1'),
  array('id' => '48','name' => 'delete_post','description' => 'Delete post permanently','scope' => 'manage_posts','group' => 'management','params' => '','access_level' => 'a:1:{i:0;s:13:"administrator";}','active' => '1'),
  array('id' => '49','name' => 'delete_comment','description' => 'Delete comment permanently','scope' => 'manage_comments','group' => 'management','params' => '','access_level' => 'a:1:{i:0;s:13:"administrator";}','active' => '1'),
  array('id' => '50','name' => 'updatepost','description' => 'Update or edit a post','scope' => 'manage_posts','group' => '','params' => '','access_level' => 'a:1:{i:0;s:6:"logged";}','active' => '1'),
  array('id' => '51','name' => 'updatecomment','description' => 'Update or edit a comment','scope' => 'publish_comments','group' => '','params' => '','access_level' => 'a:1:{i:0;s:6:"logged";}','active' => '1'),
  array('id' => '52','name' => 'edit_profile','description' => 'Edit the user profile','scope' => 'edit_profile','group' => '','params' => '','access_level' => 'a:1:{i:0;s:6:"logged";}','active' => '1'),
  array('id' => '53','name' => 'menu_items','description' => 'Retrieve items of menu','scope' => 'core','group' => '','params' => '','access_level' => 'a:1:{i:0;s:6:"anyone";}','active' => '1'),
  array('id' => '54','name' => 'appBootstrape','description' => 'Mobile application bootstrape','scope' => 'public','group' => '','params' => '','access_level' => 'a:1:{i:0;s:6:"anyone";}','active' => '1'),
  array('id' => '55','name' => 'follow_author','description' => 'Users can follow authors','scope' => 'public','group' => '','params' => '','access_level' => 'a:1:{i:0;s:6:"logged";}','active' => '1'),
  array('id' => '56','name' => 'unfollow_author','description' => 'Users can unfollow authors','scope' => 'public','group' => '','params' => '','access_level' => 'a:1:{i:0;s:6:"logged";}','active' => '1'),
  array('id' => '57','name' => 'bb_new_topic','description' => 'Add new bbPress topic','scope' => 'publish_posts','group' => '','params' => '','access_level' => 'a:1:{i:0;s:6:"logged";}','active' => '1'),
  array('id' => '58','name' => 'bb_new_comment','description' => 'Add new bbPress comment','scope' => 'publish_comments','group' => '','params' => '','access_level' => 'a:1:{i:0;s:6:"logged";}','active' => '1'),
  array('id' => '59','name' => 'request_token','description' => 'Request new access token','scope' => 'core','group' => '','params' => '','access_level' => 'a:1:{i:0;s:6:"anyone";}','active' => '1'),
  array('id' => '60','name' => 'refresh_token','description' => 'Refresh generated access token','scope' => 'core','group' => '','params' => '','access_level' => 'a:1:{i:0;s:6:"anyone";}','active' => '1'),
  array('id' => '61','name' => 'delete_myaccount','description' => 'User terminate his account','scope' => 'core','group' => '','params' => '','access_level' => 'a:1:{i:0;s:6:"logged";}','active' => '1')
);
foreach($wp_smapi_engine as $engine){
  $wpdb->insert($wpdb->prefix.'smapi_engine', $engine);
}

$setting = array(
'purchase_code' => $purchase_code,
'auth_type' => 'acctoken',
'token_expire' => 0,
'oauth2scopes' => array('public','core','posts','publish_posts','comments','publish_comments','profiles','edit_profile','taxonomies','publish_posts','manage_posts','manage_comments'),
'allowed_scopes' => array('public','core','posts','publish_posts','comments','publish_comments','profiles','edit_profile','taxonomies','publish_posts','manage_posts','manage_comments'),
'public_scopes' => array('public','posts','comments','profiles','taxonomies','core'),
'auth_key' => (SMAPI_MOBAPP_MODE && is_multisite())? $network_authkey : smapi_helper::saltHash(25),
'postlist_content' => 'html',
'post_content' => 'html',
'api_basename' => 'api',
'output_type' => 'json',
'jsonp_param' => 'callback',
'visitor_can_post' => 0,
'users_can_register' => 2,
'new_post_status' => 'open',
'exclude_cats' => '',
'resize_image' => 98,
'who_can_comment' => 'default',
'comment_moderation' => 2,
'popular_range' => 0,
'developer_mode' => 1,
'maintenance_mode' => 0,
'maintenance_msg' => 'We are performing scheduled maintenance. We should be back online shortly.',
'cdata_tags' => '',
'geo_provider' => 'telize.com',
'db_ip_apikey' => '',
'max_perpage' => 100,
'mob_categories' => '',
'mob_pages' => '',
'mob_cat_post_type' => 'post',
'mob_cat_post_type_tax' => 'category',
'mob_home_cover' => '',
'mob_headtitle' => '',
'mob_home_catids' => '',
'mob_gmaps_apikey' => '',
'mob_contact_photo1' => '',
'mob_contact_photo2' => '',
'mob_contact_photo3' => '',
'mob_contact_photo4' => '',
'mob_contact_name' => '',
'mob_contact_desc' => '',
'mob_contact_lat' => '',
'mob_contact_lng' => '',
'mob_contact_address' => '',
'mob_contact_website' => '',
'mob_contact_email' => '',
'mob_contact_phone' => '',
'mob_contact_rating' => '',
'mob_feeds_style' => 'list',
'mob_feeds_contsource' => 'contents',
'mob_common_iosappid' => '',
'mob_common_andappid' => '',
'mob_common_winappid' => '',
'mob_common_iosadid' => '',
'mob_common_andadid' => '',
'mob_common_adtype' => 'interstitial',
'mob_cache_expire' => 60,
'mob_metakey_lat' => '',
'mob_metakey_lng' => '',
'mob_menu_nearby' => 0,
'mob_menu_follow' => 0,
'mob_menu_subscription' => 0,
'mob_menu_notfhistory' => 0,
'mob_menu_contactus' => 0,
'mob_home_catmetro' => 1,
'mob_home_popular' => 0,
'mob_home_recent' => 1,
'mob_home_iosads' => 0,
'mob_home_andads' => 0,
'mob_feeds_fimage' => 1,
'mob_post_fimage' => 1,
'mob_post_showcomms' => 0,
'mob_post_addcomms' => 0,
'mob_post_author' => 0,
'mob_post_categories' => 0,
'mob_post_iosads' => 0,
'mob_post_andads' => 0,
'mob_common_gps' => 0,
'mob_common_push' => 0
);

add_option('smapi_options', $setting);
add_option('smapi_version', SMAPIVERSION);

if(SMAPI_MOBAPP_MODE && is_multisite()){
  add_option('smapi_network_authkey', $network_authkey);
}

if($blog_id !== false){
  restore_current_blog();
}
