# Super Progressive Web Apps
<p>
    <a href="https://twitter.com/intent/follow?screen_name=superpwa">
		<img src="https://img.shields.io/twitter/follow/superpwa.svg?style=social&logo=twitter" alt="follow SuperPWA on Twitter">
	</a>
	<a href="https://github.com/SuperPWA/Super-Progressive-Web-Apps">
		<img src="https://img.shields.io/github/stars/SuperPWA/Super-Progressive-Web-Apps.svg?style=social&logo=github&label=SuperPWA" alt="Star Super Progressive Web Apps">
	</a>	


</p>

<p align="center">
  <a href="https://superpwa.com/?utm_source=GitHub&utm_medium=Readme-SuperPWALogo">
    <img src="https://pbs.twimg.com/profile_images/975224418543681536/X9-CESOD_400x400.jpg" alt="Super Progressive Web Apps" width=175 height=175>
  </a>

  <h3 align="center">Super Progressive Web Apps</h3>

  <p align="center">
    SuperPWA helps to convert your WordPress website into Progressive Web Apps easily.
    <br>
    <br>
    <a href="https://superpwa.com/?utm_source=GitHub&utm_medium=Readme-viewWeb"><strong>Visit Website »</strong></a>
    <br>
    <br>
    <a href="https://github.com/SuperPWA/Super-Progressive-Web-Apps/issues/new?template=bug.md">Report bug</a>
    ·
    <a href="https://wordpress.org/plugins/super-progressive-web-apps/">WordPress Plugin</a>
    ·
    <a href="https://wordpress.org/support/plugin/super-progressive-web-apps/reviews/">Reviews</a>
    ·
    <a href="https://wordpress.org/plugins/super-progressive-web-apps/#faq">FAQ</a>
    · 
    <a href="#-contributions">Contributions</a>
  </p>
</p>


<p align="center">
	<a href="https://superpwa.com/?utm_source=GitHub&utm_medium=Readme-LighthouseScore">
			<img src="https://lighthouse-badge.appspot.com?score=100" alt="LightHouse Score">
	</a>
	<a href="https://wordpress.org/plugins/super-progressive-web-apps/">
		<img src="https://img.shields.io/wordpress/plugin/dt/super-progressive-web-apps.svg?style=plastic" alt="Super Progressive Web Apps Downloads">
	</a>
	<a href="https://wordpress.org/plugins/super-progressive-web-apps/">
		<img src="https://img.shields.io/wordpress/plugin/r/super-progressive-web-apps.svg?style=plastic" alt="Super Progressive Web Apps Rating">
	</a>
	<a href="https://wordpress.org/plugins/super-progressive-web-apps/">
		<img src="https://img.shields.io/wordpress/plugin/v/super-progressive-web-apps.svg?style=plastic" alt="Super Progressive Web Apps Version">
	</a>
	<a href="https://wordpress.org/plugins/super-progressive-web-apps/">
		<img src="https://img.shields.io/wordpress/v/super-progressive-web-apps.svg?style=plastic" alt="Super Progressive Web Apps Version">
	</a>	
</p>

## Welcome to the Super PWA GitHub repository

 ⚡️ Demo :  <a href="https://superpwa.com/?utm_source=GitHub&utm_medium=Readme-WelcomeDemo">superpwa.com</a> [Check Video's to know how it works](#videos-on-how-add-to-home-screen--progressive-web-apps-works-on-different-browsers)

## What is Progressive Web Apps
Progressive Web Apps (PWA) is a new technology that creates a middle ground between a website and a mobile app. They are installed on the phone like a normal app (web app) and can be accessed from the home screen. 

Users can come back to your website by launching the app from their home screen and interact with your website through an app-like interface. Your return visitors will experience almost-instant loading times and enjoy the great performance benefits of your PWA!

<a href="https://superpwa.com?utm_source=github&utm_medium=Readme-what-is-pwa">Super Progressive Web Apps</a> makes it easy for you to convert your WordPress website into a Progressive Web App easily!

## ⭐ Support the project
If you feel super excited and want to support us in a small way, please consider starring and/or sharing the repo! This helps us getting known and grow the community.

<a href="#"><img src="https://raw.githubusercontent.com/josevarghese/Super-Progressive-Web-Apps/master/jose-github-star-gif.gif" alt="Star our repo" width="300px" height="76.95px" /></a>

Also you can support us via [following on social media's and share about us](#share-via-social-medias-and-spread-superpwa).

## 🏗 Installation
Once SuperPWA ⚡️ is installed, users browsing your website from a supported mobile device will see a "Add To Home Screen" notice (from the bottom of the screen) and will be able to 'install your website' on the home screen of their device. Every page visited is stored locally on their device and will be available to read even when they are offline!

SuperPWA is easy to configure, it takes less than a minute to set-up your Progressive Web App! SuperPWA does a clean uninstall, by removing every database entry and file that it creates. In fact, none of the default settings are saved to the database until you manually save it the first time. Go ahead and give it a try.

### 💡 Progressive Web App Minimum Requirments
- [x] Progressive Web Apps require that your WordPress website is served from a secure origin i.e. your website should be HTTPS and not HTTP. If your website isn’t HTTPS, please contact your host about it. You can also ask us [Support Forums](https://wordpress.org/support/plugin/super-progressive-web-apps) if you need help.
</br>

##### Videos on How Add to Home Screen & Progressive Web Apps works on Different Browsers

|<a href="https://www.youtube.com/watch?v=n3TjhNblvqs"><img src="http://i3.ytimg.com/vi/n3TjhNblvqs/maxresdefault.jpg" alt="Google Chrome for Android"/> </br>📽️ Google Chrome for Android| <a href="https://www.youtube.com/watch?v=9v4RwahRQFU"><img src="http://i3.ytimg.com/vi/9v4RwahRQFU/maxresdefault.jpg" alt="Mozilla Firefox for Android" /> </br>📽️ Mozilla Firefox for Android | <a href="https://www.youtube.com/watch?v=V8-AdKxm134"><img src="http://i3.ytimg.com/vi/V8-AdKxm134/maxresdefault.jpg" alt="Microsoft Edge for Android"/> </br>📽️ Microsoft Edge for Android | <a href="https://www.youtube.com/watch?v=Sbhgb6_QKfQ"><img src="http://i3.ytimg.com/vi/Sbhgb6_QKfQ/maxresdefault.jpg" alt="Samung Internet for Android "/> </br>📽️ Samung Internet for Android | <a href="https://www.youtube.com/watch?v=bV8xE6lOdoY"><img src="http://i3.ytimg.com/vi/bV8xE6lOdoY/maxresdefault.jpg" alt="PWA on iOS - Safari Browser"/> </br>📽️ PWA on iOS - Safari Browser  |
| :---------: | :---------: | :---------: | :---------: | :---------: |
</br>

##### Detailed Documentations for testing PWA on Browsers

* [PWA on Chrome for Android](https://superpwa.com/doc/test-pwa-google-chrome/)
* [PWA on Desktop - Chrome](https://superpwa.com/doc/test-pwa-on-desktop/)
* [PWA on iOS device - Safari Browser](https://superpwa.com/doc/test-pwa-ios-devices/)
* [PWA on Microsoft Edge Browser for Android](https://superpwa.com/doc/test-pwa-microsoft-edge/)
* [PWA on Samsung Internet Browser for Android](https://superpwa.com/doc/test-pwa-samsung-internet-browser/)

#### 📦 What's in the box

Here are the current features of Super Progressive Web Apps: 

* Generate a manifest for your website and add it to the head of your website.
* Set the application icon for your Progressive Web App. 
* Set the background color for the splash screen of your Progressive Web App. 
* Your website will show the "Add to home screen" notice when accessed in a supported browser.
* Aggressive caching of pages using CacheStorage API.
* Pages once cached are served even if the user is offline. 
* Set custom offline page: Select the page you want the user to see when a page that isn't in the cache is accessed and the user is offline.
* New in version 1.2: Support for theme-color.
* New in version 1.2: Now you can edit the Application Name and Application Short name.
* New in version 1.2: Set the start page of your PWA.
* New in version 1.2: Set Accelerated Mobile Pages (AMP) version of the start page. Supported plugins: AMP for WordPress, AMP for WP, Better AMP, AMP Supremacy, WP AMP.
* New in version 1.3: Added support for high-quality splash screen. You can now set the 512x512 icon for the splash screen of your Progressive Web App.
* New in version 1.3: Super Progressive Web Apps now accounts for content updates and will update the cache as you update the website. 
* New in version 1.3: Improved in-browser service worker update handling.
* New in version 1.4: You can now set the default orientation of your PWA. Choose from "any" (Follow Device Orientation), "Portrait" and "Landscape".
* New in version 1.4: You can now set the theme_color property in the manifest.
* New in version 1.5: OneSignal integration for Push notifications.
* New in version 1.6: WordPress Multisite Network compatibility.
* New in version 1.7: Add-Ons for SuperPWA is here! Ships with [UTM Tracking Add-On](https://superpwa.com/addons/utm-tracking/?utm_source=GitHub&utm_medium=Readme-version) to track visits coming from your PWA.
* New in version 1.8: Compatibility issues with OneSignal are now resolved!
* New in version 1.8: New Add-On: [Apple Touch Icons](https://superpwa.com/addons/apple-touch-icons/?utm_source=GitHub&utm_medium=Readme-version) that sets your app icons as Apple Touch Icons.
* New in version 2.0: SuperPWA is now compatible with WordPress installed in a sub-folder.
* New in version 2.0: You can now set [display property](https://superpwa.com/doc/web-app-manifest-display-modes/?utm_source=GitHub&utm_medium=Readme-version) from SuperPWA settings.
* New in version 2.1.1: Support for maskabale icons.

#### 🔮 Upcoming features:
* Offline Indicator Notice.
 
 ### Device and Browser Support For PWA
 | | <img src="https://image.flaticon.com/icons/svg/732/732205.svg" alt="Chrome" width="32px" height="32px" /> Chrome | <img src="https://image.flaticon.com/icons/svg/732/732198.svg" alt="Firefox" width="32px" height="32px" /> Firefox | <img src="https://image.flaticon.com/icons/svg/732/732219.svg" alt="Edge" width="32px" height="32px" /> Edge | <img src="https://camo.githubusercontent.com/3fb130c75d01178836d96dcf3baccbe7b95b3642/68747470733a2f2f696d6167652e666c617469636f6e2e636f6d2f69636f6e732f7376672f3733322f3733323233332e737667" alt="Opera" width="32px" height="32px" /> Opera | <img src="https://image.flaticon.com/icons/svg/732/732241.svg" alt="Safari" width="32px" height="32px" /> Safari |<img src="https://upload.wikimedia.org/wikipedia/commons/thumb/5/52/Samsung_Internet_Logo.png/800px-Samsung_Internet_Logo.png" alt="Samsung" width="32px" height="32px" /> Samsung | <img src="https://upload.wikimedia.org/wikipedia/en/d/d0/UC_Browser_Logo.png" alt="UC Browser" width="32px" height="32px" /> UC Browser | <img src="https://upload.wikimedia.org/wikipedia/en/a/a5/Brave_Software_Logo.png" alt="Brave" width="32px" height="32px" /> Brave |
| :---------: | :---------: | :---------: | :---------: | :---------: | :---------: | :---------: | :---------: | :---------: |
| Add to Home Screen | <img src="https://image.flaticon.com/icons/svg/144/144008.svg" alt="Yes" width="32px" height="32px" /> | <img src="https://image.flaticon.com/icons/svg/144/144008.svg" alt="Supported" width="32px" height="32px" /> | <img src="https://image.flaticon.com/icons/svg/123/123381.svg" alt="Beta or Partial Support" width="20px" height="20px" /> | <img src="https://image.flaticon.com/icons/svg/144/144008.svg" alt="Supported" width="32px" height="32px" /> | <img src="https://image.flaticon.com/icons/svg/123/123381.svg" alt="Beta or Partial Support" width="20px" height="20px" /> | <img src="https://image.flaticon.com/icons/svg/144/144008.svg" alt="Supported" width="32px" height="32px" /> | <img src="https://image.flaticon.com/icons/svg/144/144008.svg" alt="Supported" width="32px" height="32px" /> | <img src="https://image.flaticon.com/icons/svg/144/144008.svg" alt="Supported" width="32px" height="32px" /> |
| Service Workers | <img src="https://image.flaticon.com/icons/svg/144/144008.svg" alt="Yes" width="32px" height="32px" /> | <img src="https://image.flaticon.com/icons/svg/144/144008.svg" alt="Supported" width="32px" height="32px" /> | <img src="https://image.flaticon.com/icons/svg/144/144008.svg" alt="Supported" width="32px" height="32px" /> | <img src="https://image.flaticon.com/icons/svg/144/144008.svg" alt="Supported" width="32px" height="32px" /> | <img src="https://image.flaticon.com/icons/svg/144/144008.svg" alt="Supported" width="32px" height="32px" /> | <img src="https://image.flaticon.com/icons/svg/144/144008.svg" alt="Supported" width="32px" height="32px" /> | <img src="https://image.flaticon.com/icons/svg/144/144008.svg" alt="Supported" width="32px" height="32px" /> | <img src="https://image.flaticon.com/icons/svg/144/144008.svg" alt="Supported" width="32px" height="32px" /> |
| Web Push & Notifications| <img src="https://image.flaticon.com/icons/svg/144/144008.svg" alt="Yes" width="32px" height="32px" /> | <img src="https://image.flaticon.com/icons/svg/144/144008.svg" alt="Supported" width="32px" height="32px" /> | <img src="https://image.flaticon.com/icons/svg/144/144008.svg" alt="Supported" width="32px" height="32px" /> | <img src="https://image.flaticon.com/icons/svg/144/144008.svg" alt="Supported" width="32px" height="32px" /> | <img src="https://image.flaticon.com/icons/svg/123/123381.svg" alt="Beta or Partial Support" width="20px" height="20px" /> | <img src="https://image.flaticon.com/icons/svg/144/144008.svg" alt="Supported" width="32px" height="32px" /> | <img src="https://image.flaticon.com/icons/svg/144/144008.svg" alt="Supported" width="32px" height="32px" /> | <img src="https://image.flaticon.com/icons/svg/144/144008.svg" alt="Supported" width="32px" height="32px" /> |
| Payment Request API | <img src="https://image.flaticon.com/icons/svg/144/144008.svg" alt="Yes" width="32px" height="32px" /> | <img src="https://image.flaticon.com/icons/svg/876/876101.svg" alt="In Development" width="32px" height="32px" /> | <img src="https://image.flaticon.com/icons/svg/144/144008.svg" alt="Supported" width="32px" height="32px" /> | <img src="https://image.flaticon.com/icons/svg/876/876101.svg" alt="In Development" width="32px" height="32px" /> | <img src="https://image.flaticon.com/icons/svg/144/144008.svg" alt="Supported" width="32px" height="32px" /> | <img src="https://image.flaticon.com/icons/svg/144/144008.svg" alt="Supported" width="32px" height="32px" /> | - | - |
| Meta Theme Color | <img src="https://image.flaticon.com/icons/svg/144/144008.svg" alt="Yes" width="32px" height="32px" /> | - | - | - | - | <img src="https://image.flaticon.com/icons/svg/144/144008.svg" alt="Yes" width="32px" height="32px" /> | - | <img src="https://image.flaticon.com/icons/svg/144/144008.svg" alt="Yes" width="32px" height="32px" /> |

</br>

<p align="center">
  <img src="https://image.flaticon.com/icons/svg/144/144008.svg" alt="Supported" width="32px" height="32px" /> Supported
&nbsp;
&nbsp;
&nbsp;
&nbsp;
  <img src="https://image.flaticon.com/icons/svg/123/123381.svg" alt="Beta or Partial Support" width="32px" height="32px" /> Beta or Partial Support
&nbsp;
&nbsp;
&nbsp;
&nbsp;
  <img src="https://image.flaticon.com/icons/svg/876/876101.svg" alt="In Development" width="32px" height="32px" /> In Development
</p>


Progressive web apps need browsers that support manifests and service workers. Currently Google Chrome (version 57+), Chrome for Android (62), Mozilla Firefox (57), Firefox for Android (58) are the major browsers that support PWA. 

The list is fast growing and is likely to be supported in most major browsers by the end of this year.

### Why Build Progressive Web Apps?
[![Why Build Progressive Web Apps](http://i3.ytimg.com/vi/1QILz1lAzWY/maxresdefault.jpg)](https://www.youtube.com/embed/1QILz1lAzWY)

### How To Convert Your WordPress Website Into A Progressive Web App

#### ⚙️ WordPress Installation

* Visit WordPress Admin > **Plugins** > **Add New**
* Search for **Super Progressive Web Apps**
* Click "**Install Now**" and then "**Activate**" Super Progressive Web Apps

#### ⚙️ To install manually:

* Upload super-progressive-web-apps folder to the /wp-content/plugins/ directory on your server
* Go to WordPress Admin > **Plugins**
* Activate **Super Progressive Web Apps** plugin from the list.

#### Customizing Your Progressive Web App

Your Progressive Web App should be ready to test with the default settings upon activation. You can customize it further and make it truly your own.

* Go to WordPress Admin > "**SuperPWA**" > **Settings**
* Set a Background Color for the splash screen to be shown when your PWA is opened on a mobile device.
* Set the Application Icon. This will be the icon of your PWA when it is added to the homescreen in a mobile device. The icon must be a PNG image and exactly 192 x 192 pixels in size.
* Set the Offline Page. This page will be displayed if the user is offline and the page he requested is not cached already. Ideally you should create a dedicated WordPress page and set it here. Within the page you create, you could add a note that reads, "It looks like you are offline and the page you requested is not available right now. Please check back again once you are online.". 
* Click "Save Settings".

#### Testing Your Progressive Web App

* Open a supported browser in a supported device (for eg: Chrome for Android (62 or higher) in an Android device)
* Enter your website and wait till it fully loads
* You should see a pop-up that has your Application Icon and a button that reads "ADD TO HOME SCREEN".
* Click on it and your PWA will be added to your home screen. Wait for the install to complete. 
* Go to your home screen and open your PWA. Browse into a few pages if you like. Close the App.
* Disconnect from the internet and now open your PWA again. You should be able to see all the pages that you previously browsed. 
* Try visiting a page that you did not visit before. You should see the page you set as your "Offline Page" in the settings of SuperPWA. 


### 🤝 About us
> We are a duo who got excited about the idea. Our mission is simple: Help you build an awesome PWA that your users would want to have on their home screen. When we first heard about PWA we wanted to learn everything about it. We have spent countless hours learning and wants to share it with the world. Please give us your constructive feedback and support. 

## ⛷️ Support
This is a developer's portal for Super Progressive Web Apps and should not be used for support. Please visit the
[Support Forums](https://wordpress.org/support/plugin/super-progressive-web-apps).

## 🐛 Reporting bugs
If you ever get stuck, we are here to watch your back! [Open a New Support Topic](https://wordpress.org/support/plugin/super-progressive-web-apps) ticket if you have a question or need a feature. We are super excited to hear your feedback and we want to genuinely help you build the best Progressive Web App for your WordPress website!

## 🎍 Contributions
Anyone is welcome to contribute to Super PWA to make it SUPER.

There are various ways you can contribute:

* [Raise an issue](https://github.com/SuperPWA/Super-Progressive-Web-Apps/issues) on GitHub.
* Follow and Engage with us on Social Media

 &nbsp;&nbsp;&nbsp; <a href="https://twitter.com/intent/follow?screen_name=superpwa" target="_blank" style="width:100%"><img src="https://image.flaticon.com/icons/svg/174/174876.svg" title="Follow SuperPWA on Twitter" width=35 height=35></a>&nbsp;&nbsp;&nbsp;&nbsp;
<a href="https://www.youtube.com/channel/UCMFlNeutNCwTNls186moUUA" target="_blank" style="width:100%"><img src="https://image.flaticon.com/icons/svg/174/174883.svg" title="Follow SuperPWA on YouTube" width=35 height=35></a>&nbsp;&nbsp;&nbsp;&nbsp;
<a href="https://www.facebook.com/SuperPWA/" target="_blank" style="width:100%"><img src="https://image.flaticon.com/icons/svg/174/174848.svg" title="Follow SuperPWA on Facebook" width=35 height=35></a>&nbsp;&nbsp;&nbsp;&nbsp;
<a href="https://www.instagram.com/superpwa/" target="_blank" style="width:100%"><img src="https://image.flaticon.com/icons/svg/174/174855.svg" title="Follow SuperPWA on Instagram" width=35 height=35></a>&nbsp;&nbsp;&nbsp;&nbsp;

* Send us a Pull Request with your bug fixes and/or new features.
* Provide feedback and [suggestions on enhancements](https://github.com/SuperPWA/Super-Progressive-Web-Apps/issues?direction=desc&labels=Enhancement&page=1&sort=created&state=open).
* ##### Share via Social Media's and spread SuperPWA

 &nbsp;&nbsp;&nbsp; <a href="https://twitter.com/home?status=Super%20Progressive%20Web%20Apps%20helps%20to%20convert%20your%20WordPress%20website%20into%20PWA%20%23SuperPWA%20https%3A//github.com/SuperPWA/Super-Progressive-Web-Apps/%20%40SuperPWA" target="_blank" style="width:100%"><img src="https://image.flaticon.com/icons/svg/174/174876.svg" title="Share SuperPWA on Twitter" width=20 height=20> Share on Twitter </a>&nbsp;&nbsp;&nbsp;&nbsp;
<p> &nbsp;&nbsp;&nbsp; <a href="https://www.facebook.com/sharer/sharer.php?u=https%3A//github.com/SuperPWA/Super-Progressive-Web-Apps/" target="_blank" style="width:100%"><img src="https://image.flaticon.com/icons/svg/174/174848.svg" title="Follow SuperPWA on Facebook" width=20 height=20> Share on Facebook </a>&nbsp;&nbsp;&nbsp;&nbsp;</p>
<p> &nbsp;&nbsp;&nbsp; <a href="https://www.linkedin.com/shareArticle?mini=true&url=https%3A//github.com/SuperPWA/Super-Progressive-Web-Apps/&title=Super%20Progressive%20Web%20Apps&summary=Super%20Progressive%20Web%20Apps%20helps%20to%20convert%20your%20WordPress%20website%20into%20PWA%20%23SuperPWA&source=GitHub" target="_blank" style="width:100%"><img src="https://image.flaticon.com/icons/svg/174/174857.svg" title="Share SuperPWA on LinkedIn" width=20 height=20> Share on LinkedIn</a>&nbsp;&nbsp;&nbsp;&nbsp;</p>

## 📇 Changelog
[superpwa.com/changelog/](https://superpwa.com/changelog/?utm_source=GitHub&utm_medium=Readme-Changelog).
    
Emoji Credits : [Emojipedia](emojipedia.org)
Social Media Icon Credits : [Flaticon](flaticon.com)

**[⬆ back to top](#super-progressive-web-apps)**
