<?php

/*
  Plugin Name: WP Sheet Editor - Troubleshooting
  Description: Tools to identify missing columns quickly. This plugin can be deactivated anytime, it is used for technical support only.
  Version: 1.0.0
  Author: WP Sheet Editor
  Author URI: https://wpsheeteditor.com/?utm_source=wp-admin&utm_medium=plugins-list&utm_campaign=yoast
  Plugin URI: http://wpsheeteditor.com/?utm_source=wp-admin&utm_medium=plugins-list&utm_campaign=yoast
 */

if (!defined('ABSPATH')) {
	exit;
}
if (!class_exists('WP_Sheet_Editor_Debugging')) {

	class WP_Sheet_Editor_Debugging {

		private static $instance = false;
		var $version = '1.0.0';
		var $plugin_url = null;
		var $textname = 'vg_sheet_editor_debugging';
		var $plugin_dir = null;
		var $vg_plugin_sdk = null;

		private function __construct() {
			
		}

		function init() {
			$this->plugin_url = plugins_url('/', __FILE__);
			$this->plugin_dir = __DIR__;

			add_action('vg_sheet_editor/initialized', array($this, 'after_core_init'));
		}

		function after_core_init() {
			if (!current_user_can('manage_options')) {
				return;
			}
			if (!apply_filters('vg_sheet_editor/troubleshooting/allow_to_load', true)) {
				return;
			}

			$this->print_data();
			add_action('admin_bar_menu', array($this, 'add_toolbar_items'), 100);
			add_filter('post_row_actions', array($this, 'add_print_data_link'), 10, 2);
			foreach (get_taxonomies() as $taxonomy_key) {
				add_filter($taxonomy_key . '_row_actions', array($this, 'add_print_data_link'), 10, 2);
			}
			add_filter('user_row_actions', array($this, 'add_print_data_link'), 10, 2);
			add_action('vg_sheet_editor/editor/before_init', array($this, 'register_columns'));
			add_action('vg_sheet_editor/editor/before_init', array($this, 'register_toolbar'), 80);
			add_action('vg_sheet_editor/editor_page/after_editor_page', array($this, 'render_scripts'));
		}

		function register_toolbar($editor) {

			$post_types = $editor->args['enabled_post_types'];
			foreach ($post_types as $post_type) {
				$editor->args['toolbars']->register_item(
						'troubleshooting', array(
					'type' => 'button',
					'allow_in_frontend' => false,
					'content' => __('Troubleshooting', VGSE()->textname),
					'icon' => 'fa fa-cog',
					'toolbar_key' => 'secondary',
					'extra_html_attributes' => 'data-remodal-target="modal-troubleshooting"',
					'parent' => 'support',
					'footer_callback' => array($this, 'render_troubleshooting_page'),
						), $post_type
				);
			}
		}

		function render_scripts() {
			?>

			<script>
				jQuery(window).load(function () {
					var $sections = jQuery('.sections');
					var sectionsHtml = '';
					jQuery('h3.section').each(function () {
						var $h3 = jQuery(this);
						sectionsHtml += '<a href="#' + $h3.attr('id') + '">' + $h3.text() + '</a>';
					});

					if (sectionsHtml) {
						$sections.append(sectionsHtml);
					}

					jQuery('h3.section, .label').click(function (e) {
						jQuery(this).next().slideToggle();
					});
					jQuery('h3.section').click();

					jQuery('body').on('change', '.troubleshoot-column-key', function (e) {
						var columnKey = jQuery(this).val();

						if (columnKey) {
							var visible = false;
							if (typeof vgse_editor_settings.columnsFormat[columnKey] !== 'undefined') {
								var visible = true;
							}
							if (!visible) {
								jQuery.each(vgse_editor_settings.final_spreadsheet_columns_settings, function (key, columnSettings) {
									if (columnSettings.serialized_field_original_key === columnKey) {
										columnKey = key;
									}
								});
								if (typeof vgse_editor_settings.columnsFormat[columnKey] !== 'undefined') {
									var visible = true;
								}
							}
							var color = visible ? 'green' : 'red';
							jQuery(this).css('border', '2px solid ' + color);
						}
						console.log('columnKey: ', columnKey);
						console.log('color: ', color);
					});
				});
			</script>
			<style>
				h3.section, .label {
					display: block;
					cursor: pointer;
				}
				.sections a {
					display: inline-block;
					padding-right: 15px;
				}
			</style>
			<?php

		}

		/**
		 * Register spreadsheet columns
		 */
		function register_columns($editor) {
			if (!$editor->provider->is_post_type) {
				return;
			}
			$post_types = $editor->args['enabled_post_types'];
			foreach ($post_types as $post_type) {
				if (post_type_exists($post_type)) {
					$type = 'post';
				} elseif (taxonomy_exists($post_type)) {
					$type = 'term';
				} elseif ($post_type === 'user') {
					$type = 'user';
				}
				if (empty($type)) {
					return;
				}
				$editor->args['columns']->register_item(
						'sheet_editor_print_data', $post_type, array(
					'data_type' => 'post_data',
					'unformatted' => array(
						'renderer' => 'wp_external_button',
						'readOnly' => true,
					),
					'column_width' => 210,
					'title' => __('Sheet Editor : Print Data', VGSE()->textname),
					'type' => 'external_button',
					'supports_formulas' => false,
					'formatted' => array(
						'renderer' => 'wp_external_button',
						'readOnly' => true,
					),
					'allow_to_hide' => true,
					'allow_to_save' => false,
					'allow_to_rename' => true,
					'allow_for_variations' => true,
					'external_button_template' => admin_url('post.php?action=edit&wpse_type=' . $type . '&wpse_print_meta={ID}'),
						)
				);
			}
		}

		public function add_print_data_link($actions, $post) {
			if (strpos($_SERVER['REQUEST_URI'], 'edit.php') !== false) {
				$type = 'post';
				$id = $post->ID;
			} elseif (strpos($_SERVER['REQUEST_URI'], 'edit-tags.php') !== false) {
				$type = 'term';
				$id = $post->term_id;
			} elseif (strpos($_SERVER['REQUEST_URI'], 'users.php') !== false) {
				$type = 'user';
				$id = $post->ID;
			}
			if (empty($type)) {
				return $actions;
			}

			$actions['print_data'] = '<a target="_blank" href="' . add_query_arg(
							array(
								'wpse_type' => $type,
								'wpse_print_meta' => $id,
							)
					) . '">' . esc_html__('Sheet Editor: Print data', $this->textname) . '</a>';

			return $actions;
		}

		function custom_taxonomies_terms($post_id) {
			// get post by post id
			$post = get_post($post_id);
			// get post type by post
			$post_type = $post->post_type;
			// get post type taxonomies
			$taxonomies = get_object_taxonomies($post_type);
			foreach ($taxonomies as $taxonomy) {
				echo 'Taxonomy: ' . $taxonomy . ' ===== ' . PHP_EOL;
				// get the terms related to post
				$terms = get_the_terms($post->ID, $taxonomy);
				if (!empty($terms)) {
					foreach ($terms as $term) {
						var_dump('$term', $term);
					}
				}
			}
		}

		function add_toolbar_items($admin_bar) {
			if (is_multisite()) {
				$admin_bar->add_menu(
						array(
							'id' => 'wpse-blog-id',
							'title' => 'Blog ID: ' . get_current_blog_id(),
							'href' => '#'
						)
				);
			}
			if (!empty($_GET['post'])) {
				$admin_bar->add_menu(
						array(
							'id' => 'wpse-print-meta',
							'title' => 'Post meta',
							'href' => add_query_arg(
									array(
										'wpse_type' => 'post',
										'wpse_print_meta' => (int) $_GET['post'],
									)
							),
							'meta' => array(
								'title' => __('Print meta'),
								'target' => '_blank',
							),
						)
				);
			}
		}

		function _is_not_object($value) {
			return !is_object($value);
		}

		function get_meta_field_unique_values($meta_key, $post_type = 'post') {
			global $wpdb;
			$post_meta_table = $wpdb->postmeta;
			$post_meta_post_id_key = 'post_id';
			$sql = "SELECT m.post_id, m.meta_value FROM $wpdb->posts p LEFT JOIN $post_meta_table m ON p.ID = m.$post_meta_post_id_key WHERE p.post_type = '" . esc_sql($post_type) . "' AND m.meta_key = '" . esc_sql($meta_key) . "' GROUP BY m.meta_value ORDER BY LENGTH(m.meta_value) DESC LIMIT 4";
			$values = apply_filters('vg_sheet_editor/provider/post/meta_field_unique_values', $wpdb->get_results($sql, ARRAY_A), $meta_key, $post_type);

			// Remove any field value with extremely long length (5mb) to avoid high memory usage
			foreach ($values as $index => $value) {
				if (!isset($value['meta_value'])) {
					continue;
				}
				$values[$index]['meta_value'] = maybe_unserialize($value['meta_value']);
				if (is_string($value) && strlen($value) > 5000000) {
					unset($values[$index]);
				}
			}
//			$values = array_map('maybe_unserialize', $values);
//			$values = array_filter($values, array($this, '_is_not_object'));
			return $values;
		}

		function print_data() {
			global $wpdb;
			if (!empty($_GET['wpse_print_meta'])) {
				header('Content-type: text/plain');
				$id = (int) $_GET['wpse_print_meta'];
				$type = sanitize_text_field($_GET['wpse_type']);

				if ($type === 'post') {
					echo 'Meta ========' . PHP_EOL;
					$meta = get_post_meta($id);
					foreach ($meta as $key => $values) {
						foreach ($values as $index => $value) {
							$meta[$key][$index] = maybe_unserialize($value);
						}
					}
					var_dump($meta);
					echo PHP_EOL . 'Post data ========' . PHP_EOL;
					var_dump($wpdb->get_row("SELECT * FROM $wpdb->posts WHERE ID = " . $id, ARRAY_A));

					$this->custom_taxonomies_terms($id);
					echo 'Comments ======== You need the comments and reviews spreadsheet to edit this data' . PHP_EOL;
					var_dump(get_comments(array(
						'post_id' => $id
					)));
				} elseif ($type === 'user') {
					echo 'Meta ========' . PHP_EOL;
					var_dump(get_user_meta($id));
					echo 'User data ========' . PHP_EOL;
					var_dump($wpdb->get_row("SELECT * FROM $wpdb->users WHERE ID = " . $id, ARRAY_A));
				} elseif ($type === 'term') {
					echo 'Meta ========' . PHP_EOL;
					var_dump(get_term_meta($id));
					echo 'Term ========' . PHP_EOL;
					var_dump($wpdb->get_row("SELECT * FROM $wpdb->terms WHERE term_id = " . $id, ARRAY_A));
					echo 'Term taxonomy ========' . PHP_EOL;
					var_dump($wpdb->get_row("SELECT * FROM $wpdb->term_taxonomy WHERE term_id = " . $id, ARRAY_A));
				}
				die();
			}
		}

		/**
		 * Render extensions page
		 */
		function render_troubleshooting_page() {
			require 'views/troubleshooting-page.php';
		}

		/**
		 * Creates or returns an instance of this class.
		 */
		static function get_instance() {
			if (null == self::$instance) {
				self::$instance = new WP_Sheet_Editor_Debugging();
				self::$instance->init();
			}
			return self::$instance;
		}

		function __set($name, $value) {
			$this->$name = $value;
		}

		function __get($name) {
			return $this->$name;
		}

	}

}

if (!function_exists('WP_Sheet_Editor_Debugging_Obj')) {

	function WP_Sheet_Editor_Debugging_Obj() {
		return WP_Sheet_Editor_Debugging::get_instance();
	}

}


add_action('vg_sheet_editor/initialized', 'WP_Sheet_Editor_Debugging_Obj', 1);
