<?php
global $wpdb;
$nonce = wp_create_nonce('bep-nonce');
$post_type = VGSE()->helpers->get_provider_from_query_string();
$column_key = isset($_GET['debug_column_key']) ? sanitize_text_field($_GET['debug_column_key']) : '';

if (!empty($_GET['vgse_debug_clear_columns_visibility'])) {
	delete_option('vgse_columns_visibility');
}
if (!empty($_GET['vgse_debug_clear_deleted_columns'])) {
	delete_option('vgse_removed_columns');
}
if (!empty($_GET['vgse_debug_clear_custom_columns'])) {
	delete_option('vg_sheet_editor_custom_columns');
}
if (!empty($_GET['vgse_debug_clear_columns_manager'])) {
	delete_option('vgse_columns_manager');
}
if (!empty($_GET['wpse_convert_orphan_variations_to_simple_products'])) {
	$wpdb->update($wpdb->posts, array(
		'post_type' => 'product',
		'post_parent' => '0',
		'post_status' => 'draft'
			), array(
		'post_type' => 'product_variation',
		'post_parent' => '0',
	));
}
?>
<div data-remodal-id="modal-troubleshooting" data-remodal-options="closeOnOutsideClick: false" class="remodal remodal-troubleshooting modal-troubleshooting">

	<h1><?php _e('Troubleshooting', VGSE()->textname); ?></h1>
	<form method="GET" action="<?php echo esc_url(add_query_arg('wpse_troubleshoot_form', 1)); ?>#modal-troubleshooting">
		<?php foreach ($_GET as $get_key => $get_value) {
			?>
			<input type="hidden" name="<?php echo esc_attr(esc_html($get_key)); ?>" value="<?php echo esc_attr(esc_html($get_value)); ?>" />
		<?php }
		?>
		<label>Column key</label>
		<input class="troubleshoot-column-key" name="debug_column_key" value="<?php echo esc_attr($column_key); ?>">

		<button type="submit">Submit</button>
	</form>

	<div class="sections">Sections: </div>

	<?php
	$editor = VGSE()->helpers->get_provider_editor($post_type);
	$items = array(
		'Column' => array(),
		'Post type' => array(),
		'Global' => array(),
	);

	$items['Global']['DB Prefix'] = $wpdb->prefix;
	$items['Global']['Table names'] = array('commentmeta', 'comments', 'options', 'posts', 'postmeta', 'users', 'usermeta', 'termmeta', 'term_relationships', 'term_taxonomy', 'terms', 'blogs', 'blogmeta', 'blog_version', 'registration_log', 'signups', 'site', 'sitemeta');

	$custom_tables_cache_key = 'vgse_custom_tables_trouble';
	$custom = get_transient($custom_tables_cache_key);
	if (!$custom) {
		$custom = $wpdb->get_col("SHOW TABLES;");
		set_transient($custom_tables_cache_key, $custom, DAY_IN_SECONDS * 3);
	}
	$core_tables_regex = '/(' . implode('|', $items['Global']['Table names']) . ')$/';
	foreach ($custom as $index => $table_name) {
		if (strpos($table_name, $wpdb->prefix) !== 0 || preg_match($core_tables_regex, $table_name)) {
			unset($custom[$index]);
		}
	}
	$items['Global']['Custom table names'] = $custom;
	if ($post_type) {
		$deleted_columns = WP_Sheet_Editor_Columns_Visibility::get_instance()->get_removed_columns($post_type)[$post_type];
		$items['Post type']['Deleted columns (' . count($deleted_columns) . ')'] = $deleted_columns;
		$visibility_options = WP_Sheet_Editor_Columns_Visibility::get_visibility_options($post_type);
		if (empty($visibility_options['enabled'])) {
			$visibility_options['enabled'] = array();
		}
		if (empty($visibility_options['disabled'])) {
			$visibility_options['disabled'] = array();
		}

		$label_key = 'Enabled columns (' . count($visibility_options['enabled']) . ')';
		$items['Post type'][$label_key] = '';
		foreach ($visibility_options['enabled'] as $key => $label) {
			$items['Post type'][$label_key] .= '<br>' . esc_html($key) . ': ' . $label;
		}
		$label_key = 'Disabled columns (' . count($visibility_options['disabled']) . ')';
		$items['Post type'][$label_key] = '';
		foreach ($visibility_options['disabled'] as $key => $label) {
			$items['Post type'][$label_key] .= '<br>' . esc_html($key) . ': ' . $label;
		}

		$all_columns = $editor->args['columns']->get_items(true);
		$items['Post type']['Registered columns (unfiltered) (' . count($all_columns[$post_type]) . ')'] = array_keys($all_columns[$post_type]);
		$filtered_columns = $editor->args['columns']->get_provider_items($post_type);
		$items['Post type']['Registered columns (filtered) (' . count($filtered_columns) . ')'] = array_keys($filtered_columns);

		$columns_detected = get_transient('vgse_detected_fields_' . $post_type);
		if (empty($columns_detected)) {
			$columns_detected = array('normal' => array(), 'serialized' => array(), 'infinite_serialized' => array());
		}
		if (empty($columns_detected['normal'])) {
			$columns_detected['normal'] = array();
		}
		if (empty($columns_detected['infinite_serialized'])) {
			$columns_detected['infinite_serialized'] = array();
		}
		if (empty($columns_detected['serialized'])) {
			$columns_detected['serialized'] = array();
		}
		$items['Post type']['Meta columns detected automatically: Normal (' . count($columns_detected['normal']) . ')'] = array_keys($columns_detected['normal']);
		$items['Post type']['Meta columns detected automatically: Infinite Serialized (' . count($columns_detected['infinite_serialized']) . ')'] = array_keys($columns_detected['infinite_serialized']);
		$items['Post type']['Meta columns detected automatically: Serialized (' . count($columns_detected['serialized']) . ')'] = array_keys($columns_detected['serialized']);
		if (post_type_exists($post_type)) {
			$all_serialized_fields = array_unique(array_merge(array_keys($columns_detected['infinite_serialized']), array_keys($columns_detected['serialized'])));
			foreach ($all_serialized_fields as $serialized_field_key) {
				$sample_values = $this->get_meta_field_unique_values($serialized_field_key, $post_type);
				$items['Post type']['Samples values used for columns from the serialized field (' . esc_html($serialized_field_key) . ')'] = '<pre style="    text-align: left;">' . var_export($sample_values, true) . '</pre>';
			}
		}
	}

	if ($column_key) {
		$meta_keys = apply_filters('vg_sheet_editor/custom_columns/all_meta_keys', VGSE()->helpers->get_all_meta_keys($post_type, VGSE()->helpers->get_columns_limit() + 200), $post_type, $editor);
		$items['Column']['Field exists in the database with at least one value?'] = in_array($column_key, $meta_keys, true) ? 'Yes' : 'No';
		$items['Column']['Is column deleted manually?'] = in_array($column_key, $deleted_columns, true) ? 'Yes' : 'No';
		$items['Column']['Is column enabled in the columns manager?'] = isset($visibility_options['enabled'][$column_key]) ? 'Yes' : 'No';
		$items['Column']['Is column disabled in the columns manager?'] = isset($visibility_options['disabled'][$column_key]) ? 'Yes' : 'No';

		if (is_numeric($column_key)) {
			$items['Column']['Known rejection'] = 'Columns with numbers as KEY are not supported by PHP';
		} else {
			$items['Column']['Known rejection'] = $editor->args['columns']->get_rejections($post_type, $column_key);
		}
	}

	foreach ($items as $group => $group_items) {
		echo '<hr>';
		echo '<h3 class="section" id="' . sanitize_html_class($group) . '">' . esc_html($group) . '</h3>';
		echo '<ul>';
		foreach ($group_items as $label => $value) {
			$final_value = '';
			if (is_array($value)) {
				$final_value = count($value) < 6 ? implode(', ', $value) : '<br>' . implode('<br>', $value);
			} elseif (is_string($value)) {
				$final_value = $value;
			}
			echo '<li><b class="label">' . esc_html($label) . ':</b> <span class="value ' . sanitize_html_class($final_value) . '">' . wp_kses_post($final_value) . '</span></li>';
		}
		echo '</ul>';
	}
	?>
	<hr>
	<h3 class="section" id="clear-options"><?php _e('Clear database options (for all sheets)', VGSE()->textname); ?></h3>
	<p>
		<a class="button" href="<?php echo esc_url(add_query_arg('vgse_debug_clear_columns_visibility', 1)); ?>" target="_blank">Columns visibility</a> - 
		<a class="button" href="<?php echo esc_url(add_query_arg('vgse_debug_clear_deleted_columns', 1)); ?>" target="_blank">Deleted Columns</a> - 
		<a class="button" href="<?php echo esc_url(add_query_arg('vgse_debug_clear_custom_columns', 1)); ?>" target="_blank">Custom Columns</a> - 
		<a class="button" href="<?php echo esc_url(add_query_arg('vgse_debug_clear_columns_manager', 1)); ?>" target="_blank">Columns manager</a> - 
		<a class="button"  href="<?php echo esc_url(add_query_arg('wpse_rescan_db_fields', 1)); ?>" target="_blank">Scan DB to find new fields</a>
		<a class="button"  href="<?php echo esc_url(add_query_arg('wpse_convert_orphan_variations_to_simple_products', 1)); ?>" target="_blank">Convert orphan variations to simple products</a>
	</p>
	<hr>
	<h3 class="section" id="related-tools"><?php _e('Related tools', VGSE()->textname); ?></h3>
	<p><a class="button" href="<?php echo esc_url(admin_url('plugin-install.php?s=file+manager&tab=search&type=term')); ?>" target="_blank">File manager</a> - <a class="button" href="<?php echo esc_url(admin_url('plugin-install.php?s=run+sql+query&tab=search&type=term')); ?>" target="_blank">Run SQL Query</a></p>

	<button data-remodal-action="confirm" class="remodal-cancel"><?php _e('Close', VGSE()->textname); ?></button>
</div>